/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.plugin;

import org.eclipse.pde.core.plugin.IPlugin;
import org.eclipse.pde.core.plugin.IPluginModel;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.pde.internal.ui.wizards.IProjectProvider;
import org.eclipse.pde.internal.ui.wizards.PluginSelectionDialog;
import org.eclipse.pde.internal.ui.wizards.plugin.AbstractFieldData;
import org.eclipse.pde.internal.ui.wizards.plugin.ContentPage;
import org.eclipse.pde.internal.ui.wizards.plugin.FragmentFieldData;
import org.eclipse.pde.internal.ui.wizards.plugin.NewProjectCreationPage;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.help.WorkbenchHelp;

public class FragmentContentPage
extends ContentPage {
    public FragmentContentPage(String pageName, IProjectProvider provider, NewProjectCreationPage page, AbstractFieldData data) {
        super(pageName, provider, page, data);
        this.setTitle(PDEPlugin.getResourceString("ContentPage.ftitle"));
        this.setDescription(PDEPlugin.getResourceString("ContentPage.fdesc"));
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 15;
        container.setLayout((Layout)layout);
        this.createFragmentPropertiesGroup(container);
        this.createParentPluginGroup(container);
        this.setControl((Control)container);
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)"org.eclipse.pde.doc.user.new_fragment_required_data");
    }

    public void createFragmentPropertiesGroup(Composite container) {
        Group propertiesGroup = new Group(container, 0);
        propertiesGroup.setLayout((Layout)new GridLayout(2, false));
        propertiesGroup.setLayoutData((Object)new GridData(768));
        propertiesGroup.setText(PDEPlugin.getResourceString("ContentPage.fGroup"));
        Label label = new Label((Composite)propertiesGroup, 0);
        label.setText(PDEPlugin.getResourceString("ContentPage.fid"));
        this.fIdText = this.createText((Composite)propertiesGroup, this.propertiesListener);
        label = new Label((Composite)propertiesGroup, 0);
        label.setText(PDEPlugin.getResourceString("ContentPage.fversion"));
        this.fVersionText = this.createText((Composite)propertiesGroup, this.propertiesListener);
        label = new Label((Composite)propertiesGroup, 0);
        label.setText(PDEPlugin.getResourceString("ContentPage.fname"));
        this.fNameText = this.createText((Composite)propertiesGroup, this.propertiesListener);
        label = new Label((Composite)propertiesGroup, 0);
        label.setText(PDEPlugin.getResourceString("ContentPage.fprovider"));
        this.fProviderText = this.createText((Composite)propertiesGroup, this.propertiesListener);
        this.fLibraryLabel = new Label((Composite)propertiesGroup, 0);
        this.fLibraryLabel.setText(PDEPlugin.getResourceString("ProjectStructurePage.library"));
        this.fLibraryText = this.createText((Composite)propertiesGroup, this.propertiesListener);
    }

    private void createParentPluginGroup(Composite container) {
        Group parentGroup = new Group(container, 0);
        parentGroup.setLayout((Layout)new GridLayout(2, false));
        parentGroup.setLayoutData((Object)new GridData(768));
        parentGroup.setText(PDEPlugin.getResourceString("ContentPage.parentPluginGroup"));
        Label label = new Label((Composite)parentGroup, 0);
        label.setText(PDEPlugin.getResourceString("ContentPage.pid"));
        this.createPluginIdContainer((Composite)parentGroup);
        label = new Label((Composite)parentGroup, 0);
        label.setText(PDEPlugin.getResourceString("ContentPage.pversion"));
        this.fPluginVersion = this.createText((Composite)parentGroup, this.listener);
        label = new Label((Composite)parentGroup, 0);
        label.setText(PDEPlugin.getResourceString(PDEPlugin.getResourceString("ContentPage.matchRule")));
        this.fMatchCombo = new Combo((Composite)parentGroup, 2056);
        this.fMatchCombo.setLayoutData((Object)new GridData(768));
        this.fMatchCombo.setItems(new String[]{"", PDEPlugin.getResourceString("ManifestEditor.MatchSection.equivalent"), PDEPlugin.getResourceString("ManifestEditor.MatchSection.compatible"), PDEPlugin.getResourceString("ManifestEditor.MatchSection.perfect"), PDEPlugin.getResourceString("ManifestEditor.MatchSection.greater")});
        this.fMatchCombo.setText(this.fMatchCombo.getItem(0));
    }

    private void createPluginIdContainer(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(768));
        this.fPluginIdText = this.createText(container, this.listener);
        Button browse = new Button(container, 8);
        browse.setText(PDEPlugin.getResourceString("ContentPage.browse"));
        browse.setLayoutData((Object)new GridData());
        browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BusyIndicator.showWhile((Display)FragmentContentPage.this.fPluginIdText.getDisplay(), (Runnable)new Runnable(this){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        PluginSelectionDialog dialog = new PluginSelectionDialog(1.access$0(this.this$1).fPluginIdText.getShell(), false, false);
                        dialog.create();
                        if (dialog.open() == 0) {
                            IPluginModel model = (IPluginModel)dialog.getFirstResult();
                            IPlugin plugin = model.getPlugin();
                            1.access$0(this.this$1).fPluginIdText.setText(plugin.getId());
                            1.access$0(this.this$1).fPluginVersion.setText(plugin.getVersion());
                        }
                    }
                });
            }

            static /* synthetic */ FragmentContentPage access$0(1 var0) {
                return var0.FragmentContentPage.this;
            }
        });
        SWTUtil.setButtonDimensionHint(browse);
    }

    public void updateData() {
        super.updateData();
        ((FragmentFieldData)this.fData).setPluginId(this.fPluginIdText.getText().trim());
        ((FragmentFieldData)this.fData).setPluginVersion(this.fPluginVersion.getText().trim());
        ((FragmentFieldData)this.fData).setMatch(this.fMatchCombo.getSelectionIndex());
    }

    protected void validatePage() {
        String errorMessage = this.validateProperties();
        if (errorMessage == null) {
            String pluginID = this.fPluginIdText.getText().trim();
            if (pluginID.length() == 0) {
                errorMessage = PDEPlugin.getResourceString("ContentPage.nopid");
            } else if (PDECore.getDefault().getModelManager().findEntry(pluginID) == null) {
                errorMessage = PDEPlugin.getResourceString("ContentPage.pluginNotFound");
            } else if (this.fPluginVersion.getText().trim().length() == 0) {
                errorMessage = PDEPlugin.getResourceString("ContentPage.nopversion");
            } else if (!this.isVersionValid(this.fPluginVersion.getText().trim())) {
                errorMessage = PDEPlugin.getResourceString("ContentPage.badpversion");
            }
        }
        if (this.fInitialized) {
            this.setErrorMessage(errorMessage);
        }
        this.setPageComplete(errorMessage == null);
    }

    protected String getNameFieldQualifier() {
        return PDEPlugin.getResourceString("ContentPage.fragment");
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.fMainPage.updateData();
        }
        super.setVisible(visible);
    }
}

