/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.plugin;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.wizards.IProjectProvider;
import org.eclipse.pde.internal.ui.wizards.NewWizard;
import org.eclipse.pde.internal.ui.wizards.plugin.ContentPage;
import org.eclipse.pde.internal.ui.wizards.plugin.FragmentContentPage;
import org.eclipse.pde.internal.ui.wizards.plugin.FragmentFieldData;
import org.eclipse.pde.internal.ui.wizards.plugin.NewProjectCreationOperation;
import org.eclipse.pde.internal.ui.wizards.plugin.NewProjectCreationPage;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;

public class NewFragmentProjectWizard
extends NewWizard
implements IExecutableExtension {
    private NewProjectCreationPage fMainPage;
    private ContentPage fContentPage;
    private FragmentFieldData fFragmentData;
    private IProjectProvider fProjectProvider;
    private IConfigurationElement fConfig;

    public NewFragmentProjectWizard() {
        this.setDefaultPageImageDescriptor(PDEPluginImages.DESC_NEWFRAGPRJ_WIZ);
        this.setWindowTitle(PDEPlugin.getResourceString("NewFragmentProjectWizard.title"));
        this.setNeedsProgressMonitor(true);
        PDEPlugin.getDefault().getLabelProvider().connect(this);
        this.fFragmentData = new FragmentFieldData();
    }

    public void addPages() {
        this.fMainPage = new NewProjectCreationPage("main", this.fFragmentData, true);
        this.fMainPage.setTitle(PDEPlugin.getResourceString("NewProjectWizard.MainPage.ftitle"));
        this.fMainPage.setDescription(PDEPlugin.getResourceString("NewProjectWizard.MainPage.fdesc"));
        this.addPage((IWizardPage)this.fMainPage);
        this.fProjectProvider = new IProjectProvider(){

            public String getProjectName() {
                return NewFragmentProjectWizard.this.fMainPage.getProjectName();
            }

            public IProject getProject() {
                return NewFragmentProjectWizard.this.fMainPage.getProjectHandle();
            }

            public IPath getLocationPath() {
                return NewFragmentProjectWizard.this.fMainPage.getLocationPath();
            }
        };
        this.fContentPage = new FragmentContentPage("page2", this.fProjectProvider, this.fMainPage, this.fFragmentData);
        this.addPage((IWizardPage)this.fContentPage);
    }

    public boolean canFinish() {
        IWizardPage page = this.getContainer().getCurrentPage();
        return page.isPageComplete() && page != this.fMainPage;
    }

    public boolean performFinish() {
        try {
            this.fMainPage.updateData();
            this.fContentPage.updateData();
            BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.fConfig);
            this.getContainer().run(false, true, (IRunnableWithProgress)new NewProjectCreationOperation(this.fFragmentData, this.fProjectProvider, null));
            return true;
        }
        catch (InvocationTargetException e) {
            PDEPlugin.logException(e);
        }
        catch (InterruptedException interruptedException) {}
        return false;
    }

    public void dispose() {
        super.dispose();
        PDEPlugin.getDefault().getLabelProvider().disconnect(this);
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.fConfig = config;
    }
}

