/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.plugin;

import java.util.StringTokenizer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.wizards.IProjectProvider;
import org.eclipse.pde.internal.ui.wizards.plugin.AbstractFieldData;
import org.eclipse.pde.internal.ui.wizards.plugin.ContentPage;
import org.eclipse.pde.internal.ui.wizards.plugin.NewProjectCreationPage;
import org.eclipse.pde.internal.ui.wizards.plugin.PluginFieldData;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.WorkbenchHelp;

public class PluginContentPage
extends ContentPage {
    private Label fLabel;
    private Button fYesButton;
    private Button fNoButton;
    private ModifyListener classListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            if (PluginContentPage.this.fInitialized) {
                PluginContentPage.this.fChangedGroups |= 2;
            }
            PluginContentPage.this.validatePage();
        }
    };
    private Label fAppIdLabel;
    private Text fAppIdText;
    private Label fAppClassLabel;
    private Text fAppClassText;
    private Group fRCPGroup;

    public PluginContentPage(String pageName, IProjectProvider provider, NewProjectCreationPage page, AbstractFieldData data) {
        super(pageName, provider, page, data);
        this.setTitle(PDEPlugin.getResourceString("ContentPage.title"));
        this.setDescription(PDEPlugin.getResourceString("ContentPage.desc"));
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout());
        this.createPluginPropertiesGroup(container);
        this.createPluginClassGroup(container);
        this.createRCPGroup(container);
        this.setControl((Control)container);
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)"org.eclipse.pde.doc.user.new_project_required_data");
    }

    private void createPluginPropertiesGroup(Composite container) {
        Group propertiesGroup = new Group(container, 0);
        propertiesGroup.setLayout((Layout)new GridLayout(2, false));
        propertiesGroup.setLayoutData((Object)new GridData(768));
        propertiesGroup.setText(PDEPlugin.getResourceString("ContentPage.pGroup"));
        Label label = new Label((Composite)propertiesGroup, 0);
        label.setText(PDEPlugin.getResourceString("ContentPage.pid"));
        this.fIdText = this.createText((Composite)propertiesGroup, this.propertiesListener);
        label = new Label((Composite)propertiesGroup, 0);
        label.setText(PDEPlugin.getResourceString("ContentPage.pversion"));
        this.fVersionText = this.createText((Composite)propertiesGroup, this.propertiesListener);
        label = new Label((Composite)propertiesGroup, 0);
        label.setText(PDEPlugin.getResourceString("ContentPage.pname"));
        this.fNameText = this.createText((Composite)propertiesGroup, this.propertiesListener);
        label = new Label((Composite)propertiesGroup, 0);
        label.setText(PDEPlugin.getResourceString("ContentPage.pprovider"));
        this.fProviderText = this.createText((Composite)propertiesGroup, this.propertiesListener);
        this.fLibraryLabel = new Label((Composite)propertiesGroup, 0);
        this.fLibraryLabel.setText(PDEPlugin.getResourceString("ProjectStructurePage.library"));
        this.fLibraryText = this.createText((Composite)propertiesGroup, this.propertiesListener);
    }

    private void createPluginClassGroup(Composite container) {
        Group classGroup = new Group(container, 0);
        classGroup.setLayout((Layout)new GridLayout(2, false));
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        classGroup.setLayoutData((Object)gd);
        classGroup.setText(PDEPlugin.getResourceString("ContentPage.pClassGroup"));
        this.fGenerateClass = new Button((Composite)classGroup, 32);
        this.fGenerateClass.setText(PDEPlugin.getResourceString("ContentPage.generate"));
        this.fGenerateClass.setSelection(true);
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.fGenerateClass.setLayoutData((Object)gd);
        this.fGenerateClass.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PluginContentPage.this.fClassLabel.setEnabled(PluginContentPage.this.fGenerateClass.getSelection());
                PluginContentPage.this.fClassText.setEnabled(PluginContentPage.this.fGenerateClass.getSelection());
                PluginContentPage.this.fUIPlugin.setEnabled(PluginContentPage.this.fGenerateClass.getSelection());
                PluginContentPage.this.fRCPGroup.setVisible(!PluginContentPage.this.fGenerateClass.getSelection() || PluginContentPage.this.fUIPlugin.getSelection());
                PluginContentPage.this.validatePage();
            }
        });
        this.fClassLabel = new Label((Composite)classGroup, 0);
        this.fClassLabel.setText(PDEPlugin.getResourceString("ContentPage.classname"));
        gd = new GridData();
        gd.horizontalIndent = 20;
        this.fClassLabel.setLayoutData((Object)gd);
        this.fClassText = this.createText((Composite)classGroup, this.classListener);
        this.fUIPlugin = new Button((Composite)classGroup, 32);
        this.fUIPlugin.setText(PDEPlugin.getResourceString("ContentPage.uicontribution"));
        this.fUIPlugin.setSelection(true);
        gd = new GridData();
        gd.horizontalIndent = 20;
        gd.horizontalSpan = 2;
        this.fUIPlugin.setLayoutData((Object)gd);
        this.fUIPlugin.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PluginContentPage.this.fRCPGroup.setVisible(PluginContentPage.this.fUIPlugin.getSelection());
                PluginContentPage.this.validatePage();
            }
        });
    }

    public void updateData() {
        super.updateData();
        PluginFieldData data = (PluginFieldData)this.fData;
        data.setClassname(this.fClassText.getText().trim());
        data.setUIPlugin(this.fUIPlugin.getSelection());
        data.setDoGenerateClass(this.fGenerateClass.isEnabled() && this.fGenerateClass.getSelection());
        data.setRCPApplicationPlugin(!this.fData.isSimple() && !this.fData.isLegacy() && this.fYesButton.getSelection() && (this.fUIPlugin.getSelection() || !this.fGenerateClass.getSelection()));
        data.setApplicationID(this.fAppIdText.getText().trim());
        data.setApplicationClassname(this.fAppClassText.getText().trim());
    }

    private void createRCPGroup(Composite container) {
        this.fRCPGroup = new Group(container, 0);
        this.fRCPGroup.setLayout((Layout)new GridLayout(2, false));
        this.fRCPGroup.setLayoutData((Object)new GridData(768));
        this.fRCPGroup.setText(PDEPlugin.getResourceString("PluginContentPage.rcpGroup"));
        this.createRCPQuestion((Composite)this.fRCPGroup, 2);
        this.fAppIdLabel = new Label((Composite)this.fRCPGroup, 0);
        this.fAppIdLabel.setText(PDEPlugin.getResourceString("PluginContentPage.appID"));
        GridData gd = new GridData();
        gd.horizontalIndent = 20;
        this.fAppIdLabel.setLayoutData((Object)gd);
        this.fAppIdLabel.setEnabled(false);
        this.fAppIdText = this.createText((Composite)this.fRCPGroup, this.propertiesListener);
        this.fAppIdText.setText("application");
        this.fAppIdText.setLayoutData((Object)new GridData(768));
        this.fAppIdText.setEnabled(false);
        this.fAppClassLabel = new Label((Composite)this.fRCPGroup, 0);
        this.fAppClassLabel.setText(PDEPlugin.getResourceString("PluginContentPage.appClass"));
        gd = new GridData();
        gd.horizontalIndent = 20;
        this.fAppClassLabel.setLayoutData((Object)gd);
        this.fAppClassLabel.setEnabled(false);
        this.fAppClassText = this.createText((Composite)this.fRCPGroup, this.classListener);
        this.fAppClassText.setLayoutData((Object)new GridData(768));
        this.fAppClassText.setEnabled(false);
    }

    private void createRCPQuestion(Composite parent, int horizontalSpan) {
        Composite comp = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        comp.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = horizontalSpan;
        comp.setLayoutData((Object)gd);
        this.fLabel = new Label(comp, 0);
        this.fLabel.setText(PDEPlugin.getResourceString("PluginContentPage.appQuestion"));
        this.fLabel.setLayoutData((Object)new GridData(768));
        this.fYesButton = new Button(comp, 16);
        this.fYesButton.setText(PDEPlugin.getResourceString("PluginContentPage.yes"));
        this.fYesButton.setSelection(false);
        gd = new GridData();
        gd.widthHint = 50;
        this.fYesButton.setLayoutData((Object)gd);
        this.fYesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean enable = PluginContentPage.this.fYesButton.getSelection();
                PluginContentPage.this.fAppIdLabel.setEnabled(enable);
                PluginContentPage.this.fAppIdText.setEnabled(enable);
                PluginContentPage.this.fAppClassLabel.setEnabled(enable);
                PluginContentPage.this.fAppClassText.setEnabled(enable);
                PluginContentPage.this.validatePage();
            }
        });
        this.fNoButton = new Button(comp, 16);
        this.fNoButton.setText(PDEPlugin.getResourceString("PluginContentPage.no"));
        this.fNoButton.setSelection(true);
        gd = new GridData();
        gd.widthHint = 50;
        this.fNoButton.setLayoutData((Object)gd);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.fMainPage.updateData();
            this.fGenerateClass.setEnabled(!this.fData.isSimple());
            this.fClassLabel.setEnabled(!this.fData.isSimple() && this.fGenerateClass.getSelection());
            this.fClassText.setEnabled(!this.fData.isSimple() && this.fGenerateClass.getSelection());
            this.fUIPlugin.setEnabled(!this.fData.isSimple() && this.fGenerateClass.getSelection());
            if ((this.fChangedGroups & 2) == 0) {
                int oldfChanged = this.fChangedGroups;
                this.presetClassField(this.fClassText, this.computeId(), "Plugin");
                this.presetClassField(this.fAppClassText, this.computeId(), "Application");
                this.fChangedGroups = oldfChanged;
            }
            this.fRCPGroup.setVisible(!this.fData.isLegacy() && !this.fData.isSimple() && (this.fUIPlugin.getSelection() || !this.fGenerateClass.getSelection()));
        }
        super.setVisible(visible);
    }

    private void presetClassField(Text text, String id, String suffix) {
        IStatus status;
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < id.length()) {
            char ch = id.charAt(i);
            if (buffer.length() == 0) {
                if (Character.isJavaIdentifierStart(ch)) {
                    buffer.append(Character.toLowerCase(ch));
                }
            } else if (Character.isJavaIdentifierPart(ch)) {
                buffer.append(ch);
            } else if (ch == '.') {
                status = JavaConventions.validatePackageName((String)buffer.toString());
                if (status.getSeverity() == 4) {
                    buffer.append(suffix.toLowerCase());
                }
                buffer.append(ch);
            }
            ++i;
        }
        StringTokenizer tok = new StringTokenizer(buffer.toString(), ".");
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            if (tok.hasMoreTokens()) continue;
            status = JavaConventions.validatePackageName((String)buffer.toString());
            if (status.getSeverity() == 4) {
                buffer.append(suffix.toLowerCase());
            }
            buffer.append("." + Character.toUpperCase(token.charAt(0)) + token.substring(1) + suffix);
        }
        text.setText(buffer.toString());
    }

    protected void validatePage() {
        IStatus status;
        this.setMessage(null);
        String errorMessage = this.validateProperties();
        if (errorMessage == null && this.fGenerateClass.isEnabled() && this.fGenerateClass.getSelection()) {
            status = JavaConventions.validateJavaTypeName((String)this.fClassText.getText().trim());
            if (status.getSeverity() == 4) {
                errorMessage = status.getMessage();
            } else if (status.getSeverity() == 2) {
                this.setMessage(status.getMessage(), 2);
            }
        }
        if (!(errorMessage != null || this.fData.isSimple() || this.fData.isLegacy() || !this.fYesButton.getSelection() || !this.fUIPlugin.getSelection() && this.fGenerateClass.getSelection())) {
            status = JavaConventions.validateJavaTypeName((String)this.fAppClassText.getText().trim());
            if (status.getSeverity() == 4) {
                errorMessage = status.getMessage();
            } else if (status.getSeverity() == 2) {
                this.setMessage(status.getMessage(), 2);
            }
            if (errorMessage == null) {
                errorMessage = this.validateApplicationID();
            }
        }
        this.setErrorMessage(errorMessage);
        this.setPageComplete(errorMessage == null);
    }

    private String validateApplicationID() {
        String id = this.fAppIdText.getText().trim();
        if (id.length() == 0) {
            return PDEPlugin.getResourceString("PluginContentPage.noApp");
        }
        int i = 0;
        while (i < id.length()) {
            if (!id.substring(i, i + 1).matches("[a-zA-Z0-9_]")) {
                return PDEPlugin.getResourceString("PluginContentPage.invalidAppID");
            }
            ++i;
        }
        return null;
    }

    protected String getNameFieldQualifier() {
        return PDEPlugin.getResourceString("ContentPage.plugin");
    }
}

