/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.ui.internal.samples;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.elements.DefaultContentProvider;
import org.eclipse.pde.internal.ui.parts.TablePart;
import org.eclipse.pde.ui.internal.samples.SampleWizard;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.WorkbenchHelp;

public class SelectionPage
extends WizardPage {
    private TablePart part;
    private Text desc;
    private SampleWizard wizard;

    public SelectionPage(SampleWizard wizard) {
        super("selection");
        this.wizard = wizard;
        this.setTitle(PDEPlugin.getResourceString("SelectionPage.title"));
        this.setDescription(PDEPlugin.getResourceString("SelectionPage.desc"));
        this.part = new SelectionPart();
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 2;
        this.part.setMinimumSize(300, 300);
        this.part.createControl(container, 2816, 2, null);
        this.part.getTableViewer().setContentProvider((IContentProvider)new SampleProvider());
        this.part.getTableViewer().setLabelProvider((IBaseLabelProvider)new SampleLabelProvider());
        this.desc = new Text(container, 2626);
        GridData gd = new GridData(768);
        gd.heightHint = 64;
        this.desc.setLayoutData((Object)gd);
        this.part.getTableViewer().setInput((Object)this);
        this.updateSelection(null);
        this.setControl((Control)container);
    }

    private void doMoreInfo() {
        if (this.wizard.getSelection() != null) {
            IConfigurationElement[] desc = this.wizard.getSelection().getChildren("description");
            String helpHref = desc[0].getAttribute("helpHref");
            WorkbenchHelp.displayHelpResource((String)helpHref);
        }
    }

    private void updateSelection(IStructuredSelection selection) {
        if (selection == null) {
            this.desc.setText("");
            this.part.setButtonEnabled(0, false);
            this.setPageComplete(false);
        } else {
            IConfigurationElement sample = (IConfigurationElement)selection.getFirstElement();
            String text = "";
            String helpHref = null;
            IConfigurationElement[] sampleDesc = sample.getChildren("description");
            if (sampleDesc.length == 1) {
                text = sampleDesc[0].getValue();
                helpHref = sampleDesc[0].getAttribute("helpHref");
            }
            this.desc.setText(text);
            this.part.setButtonEnabled(0, helpHref != null);
            this.wizard.setSelection(sample);
            this.setPageComplete(true);
        }
    }

    class SelectionPart
    extends TablePart {
        public SelectionPart() {
            super(new String[]{"More Info"});
        }

        protected void buttonSelected(Button button, int index) {
            if (index == 0) {
                SelectionPage.this.doMoreInfo();
            }
        }

        protected void selectionChanged(IStructuredSelection selection) {
            SelectionPage.this.updateSelection(selection);
        }

        protected void handleDoubleClick(IStructuredSelection selection) {
        }
    }

    class SampleProvider
    extends DefaultContentProvider
    implements IStructuredContentProvider {
        SampleProvider() {
        }

        public Object[] getElements(Object input) {
            return SelectionPage.this.wizard.getSamples();
        }
    }

    class SampleLabelProvider
    extends LabelProvider {
        private Image image = PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_NEWEXP_TOOL);

        public String getText(Object obj) {
            IConfigurationElement sample = (IConfigurationElement)obj;
            return sample.getAttribute("name");
        }

        public Image getImage(Object obj) {
            return this.image;
        }
    }
}

