/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.ui.templates;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.pde.core.plugin.IPlugin;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginReference;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.wizards.templates.ControlStack;
import org.eclipse.pde.internal.ui.wizards.templates.PluginReference;
import org.eclipse.pde.ui.templates.ITemplateSection;
import org.eclipse.pde.ui.templates.IVariableProvider;

public abstract class AbstractTemplateSection
implements ITemplateSection,
IVariableProvider {
    protected IProject project;
    protected IPluginModelBase model;
    public static final String KEY_PLUGIN_CLASS = "pluginClass";
    public static final String KEY_PLUGIN_ID = "pluginId";
    public static final String KEY_PLUGIN_NAME = "pluginName";
    public static final String KEY_PACKAGE_NAME = "packageName";
    private static final String KEY_GENERATING = "AbstractTemplateSection.generating";
    private boolean pagesAdded = false;

    public String getReplacementString(String fileName, String key) {
        if (key.equals(KEY_PLUGIN_CLASS) && this.model != null && this.model instanceof IPluginModel) {
            IPlugin plugin = (IPlugin)this.model.getPluginBase();
            return plugin.getClassName();
        }
        if (key.equals(KEY_PLUGIN_ID) && this.model != null) {
            IPluginBase plugin = this.model.getPluginBase();
            return plugin.getId();
        }
        if (key.equals(KEY_PLUGIN_NAME) && this.model != null) {
            IPluginBase plugin = this.model.getPluginBase();
            return plugin.getTranslatedName();
        }
        return key;
    }

    public Object getValue(String key) {
        return null;
    }

    public URL getTemplateLocation() {
        return null;
    }

    public String getDescription() {
        return "";
    }

    public String getPluginResourceString(String key) {
        ResourceBundle bundle = this.getPluginResourceBundle();
        if (bundle == null) {
            return key;
        }
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    protected abstract ResourceBundle getPluginResourceBundle();

    public void addPages(Wizard wizard) {
    }

    public boolean getPagesAdded() {
        return this.pagesAdded;
    }

    protected void markPagesAdded() {
        this.pagesAdded = true;
    }

    public int getNumberOfWorkUnits() {
        return 1;
    }

    public IPluginReference[] getDependencies(String schemaVersion) {
        return new IPluginReference[]{new PluginReference("org.eclipse.ui", null, 0)};
    }

    protected IFolder getSourceFolder(IProgressMonitor monitor) throws CoreException {
        IFolder sourceFolder = null;
        try {
            IJavaProject javaProject = JavaCore.create((IProject)this.project);
            IClasspathEntry[] classpath = javaProject.getRawClasspath();
            int i = 0;
            while (i < classpath.length) {
                IClasspathEntry entry = classpath[i];
                if (entry.getEntryKind() == 3) {
                    IPath path = entry.getPath().removeFirstSegments(1);
                    if (path.segmentCount() > 0) {
                        sourceFolder = this.project.getFolder(path);
                    }
                    break;
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {}
        return sourceFolder;
    }

    protected void generateFiles(IProgressMonitor monitor) throws CoreException {
        monitor.setTaskName(PDEPlugin.getResourceString(KEY_GENERATING));
        File templateDirectory = this.getTemplateDirectory();
        if (templateDirectory == null || !templateDirectory.exists()) {
            return;
        }
        this.generateFiles(templateDirectory, (IContainer)this.project, true, false, monitor);
        monitor.subTask("");
        monitor.worked(1);
    }

    protected boolean isOkToCreateFolder(File sourceFolder) {
        return true;
    }

    protected boolean isOkToCreateFile(File sourceFile) {
        return true;
    }

    protected abstract void updateModel(IProgressMonitor var1) throws CoreException;

    public void execute(IProject project, IPluginModelBase model, IProgressMonitor monitor) throws CoreException {
        this.project = project;
        this.model = model;
        this.generateFiles(monitor);
        this.updateModel(monitor);
    }

    protected IPluginExtension createExtension(String pointId, boolean reuse) throws CoreException {
        if (reuse) {
            IPluginExtension[] extensions = this.model.getPluginBase().getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IPluginExtension extension = extensions[i];
                if (extension.getPoint().equalsIgnoreCase(pointId)) {
                    return extension;
                }
                ++i;
            }
        }
        IPluginExtension extension = this.model.getFactory().createExtension();
        extension.setPoint(pointId);
        return extension;
    }

    private File getTemplateDirectory() {
        try {
            URL location = this.getTemplateLocation();
            if (location == null) {
                return null;
            }
            URL url = Platform.resolve((URL)location);
            if ((url = Platform.asLocalURL((URL)url)) != null) {
                String name = url.getFile();
                return new File(name);
            }
        }
        catch (Exception exception) {
            return null;
        }
        return null;
    }

    private void generateFiles(File src, IContainer dst, boolean firstLevel, boolean binary, IProgressMonitor monitor) throws CoreException {
        File[] members = src.listFiles();
        int i = 0;
        while (i < members.length) {
            block12: {
                File member;
                block10: {
                    IFolder dstContainer;
                    block11: {
                        member = members[i];
                        if (!member.isDirectory()) break block10;
                        dstContainer = null;
                        if (firstLevel) {
                            binary = false;
                            if (member.getName().equals("java")) {
                                IFolder sourceFolder = this.getSourceFolder(monitor);
                                dstContainer = this.generateJavaSourceFolder(sourceFolder, monitor);
                            } else if (member.getName().equals("bin")) {
                                binary = true;
                                dstContainer = dst;
                            }
                        }
                        if (dstContainer != null) break block11;
                        if (!this.isOkToCreateFolder(member)) break block12;
                        String folderName = this.getProcessedString(member.getName(), member.getName());
                        dstContainer = dst.getFolder((IPath)new Path(folderName));
                    }
                    if (dstContainer instanceof IFolder && !dstContainer.exists()) {
                        ((IFolder)dstContainer).create(true, true, monitor);
                    }
                    this.generateFiles(member, (IContainer)dstContainer, false, binary, monitor);
                    break block12;
                }
                if (this.isOkToCreateFile(member)) {
                    if (firstLevel) {
                        binary = false;
                    }
                    this.copyFile(member, dst, binary, monitor);
                }
            }
            ++i;
        }
    }

    private IFolder generateJavaSourceFolder(IFolder sourceFolder, IProgressMonitor monitor) throws CoreException {
        String packageName;
        Object packageValue = this.getValue(KEY_PACKAGE_NAME);
        String string = packageName = packageValue != null ? packageValue.toString() : null;
        if (packageName == null) {
            packageName = this.model.getPluginBase().getId();
        }
        Path path = new Path(packageName.replace('.', File.separatorChar));
        if (sourceFolder != null) {
            path = sourceFolder.getProjectRelativePath().append((IPath)path);
        }
        int i = 1;
        while (i <= path.segmentCount()) {
            IPath subpath = path.uptoSegment(i);
            IFolder subfolder = this.project.getFolder(subpath);
            if (!subfolder.exists()) {
                subfolder.create(true, true, monitor);
            }
            ++i;
        }
        return this.project.getFolder((IPath)path);
    }

    private void copyFile(File file, IContainer dst, boolean binary, IProgressMonitor monitor) throws CoreException {
        String targetFileName = this.getProcessedString(file.getName(), file.getName());
        monitor.subTask(targetFileName);
        IFile dstFile = dst.getFile((IPath)new Path(targetFileName));
        try {
            InputStream stream = this.getProcessedStream(file, binary);
            if (dstFile.exists()) {
                dstFile.setContents(stream, true, true, monitor);
            } else {
                dstFile.create(stream, true, monitor);
            }
            stream.close();
        }
        catch (IOException iOException) {}
    }

    private String getProcessedString(String fileName, String source) {
        if (source.indexOf(36) == -1) {
            return source;
        }
        int loc = -1;
        StringBuffer buffer = new StringBuffer();
        boolean replacementMode = false;
        int i = 0;
        while (i < source.length()) {
            char c = source.charAt(i);
            if (c == '$') {
                if (replacementMode) {
                    String key = source.substring(loc, i);
                    String value = this.getReplacementString(fileName, key);
                    buffer.append(value);
                    replacementMode = false;
                } else {
                    replacementMode = true;
                    loc = i + 1;
                }
            } else if (!replacementMode) {
                buffer.append(c);
            }
            ++i;
        }
        return buffer.toString();
    }

    private InputStream getProcessedStream(File file, boolean binary) throws IOException, CoreException {
        FileInputStream stream = new FileInputStream(file);
        if (binary) {
            return stream;
        }
        InputStreamReader reader = new InputStreamReader(stream);
        int bufsize = 1024;
        char[] cbuffer = new char[bufsize];
        int read = 0;
        StringBuffer keyBuffer = new StringBuffer();
        StringBuffer outBuffer = new StringBuffer();
        StringBuffer preBuffer = new StringBuffer();
        boolean newLine = true;
        ControlStack preStack = new ControlStack();
        preStack.setValueProvider(this);
        boolean replacementMode = false;
        boolean preprocessorMode = false;
        boolean escape = false;
        while (read != -1) {
            read = reader.read(cbuffer);
            int i = 0;
            while (i < read) {
                char c = cbuffer[i];
                if (escape) {
                    StringBuffer buf = preprocessorMode ? preBuffer : outBuffer;
                    buf.append(c);
                    escape = false;
                } else if (newLine && c == '%') {
                    preprocessorMode = true;
                    preBuffer.delete(0, preBuffer.length());
                } else if (preprocessorMode) {
                    if (c == '\\') {
                        escape = true;
                    } else if (c == '\n') {
                        preprocessorMode = false;
                        newLine = true;
                        String line = preBuffer.toString().trim();
                        preStack.processLine(line);
                    } else {
                        preBuffer.append(c);
                    }
                } else if (preStack.getCurrentState()) {
                    if (c == '$') {
                        if (replacementMode) {
                            replacementMode = false;
                            String key = keyBuffer.toString();
                            String value = this.getReplacementString(file.getName(), key);
                            outBuffer.append(value);
                            keyBuffer.delete(0, keyBuffer.length());
                        } else {
                            replacementMode = true;
                        }
                    } else if (replacementMode) {
                        keyBuffer.append(c);
                    } else {
                        outBuffer.append(c);
                        newLine = c == '\n';
                    }
                }
                ++i;
            }
        }
        stream.close();
        return new ByteArrayInputStream(outBuffer.toString().getBytes(this.project.getDefaultCharset()));
    }
}

