/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.preferences;

import org.eclipse.core.internal.preferences.EclipsePreferences;
import org.eclipse.core.internal.runtime.Policy;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IExportedPreferences;
import org.osgi.service.prefs.BackingStoreException;

public class ExportedPreferences
extends EclipsePreferences
implements IExportedPreferences {
    private boolean isExportRoot = false;
    private String version;

    protected ExportedPreferences(EclipsePreferences parent, String name) {
        super(parent, name);
    }

    public boolean isExportRoot() {
        return this.isExportRoot;
    }

    public void setExportRoot() {
        this.isExportRoot = true;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    protected EclipsePreferences internalCreate(EclipsePreferences nodeParent, String nodeName, Plugin context) {
        return new ExportedPreferences(nodeParent, nodeName);
    }

    public void remove(String key) {
        super.remove(key);
        if (this.properties == null) {
            try {
                this.removeNode();
            }
            catch (BackingStoreException e) {
                String message = Policy.bind("preferences.removeExported", this.absolutePath());
                Status status = new Status(4, "org.eclipse.core.runtime", 4, message, e);
                this.log(status);
            }
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.isExportRoot) {
            buffer.append("* ");
        }
        buffer.append(this.absolutePath());
        if (this.version != null) {
            buffer.append(" (" + this.version + ')');
        }
        return buffer.toString();
    }
}

