/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import jalview.AlignFrame;
import jalview.DrawableSequence;
import jalview.MSFfile;
import jalview.PCA;
import jalview.PCAPanel;
import jalview.ResidueProperties;
import jalview.Sequence;
import java.awt.BorderLayout;
import java.awt.Frame;
import java.io.IOException;

public class BinarySequence
extends Sequence {
    int[] binary;
    double[] dbinary;

    public BinarySequence(Sequence sequence) {
        super(sequence);
    }

    public BinarySequence(String string, String string2, int n, int n2) {
        super(string, string2, n, n2);
    }

    public void encode() {
        this.dbinary = new double[this.getSequence().length() * 21];
        int n = 21;
        int n2 = 0;
        while (n2 < this.dbinary.length) {
            this.dbinary[n2] = 0.0;
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.getSequence().length()) {
            int n4 = 20;
            try {
                n4 = (Integer)ResidueProperties.aaHash.get(this.getSequence().substring(n3, n3 + 1));
            }
            catch (NullPointerException nullPointerException) {
                n4 = 20;
            }
            if (n4 > 20) {
                n4 = 20;
            }
            this.dbinary[n3 * n + n4] = 1.0;
            ++n3;
        }
    }

    public void blosumEncode() {
        this.dbinary = new double[this.getSequence().length() * 21];
        int n = 21;
        int n2 = 0;
        while (n2 < this.getSequence().length()) {
            int n3 = 20;
            try {
                n3 = (Integer)ResidueProperties.aaHash.get(this.getSequence().substring(n2, n2 + 1));
            }
            catch (NullPointerException nullPointerException) {
                n3 = 20;
            }
            if (n3 > 20) {
                n3 = 20;
            }
            int n4 = 0;
            while (n4 < 20) {
                this.dbinary[n2 * n + n4] = ResidueProperties.BLOSUM62[n3][n4];
                ++n4;
            }
            ++n2;
        }
    }

    public String toBinaryString() {
        String string = "";
        int n = 0;
        while (n < this.binary.length) {
            string = String.valueOf(string) + new Integer(this.binary[n]).toString();
            if (n < this.binary.length - 1) {
                string = String.valueOf(string) + " ";
            }
            ++n;
        }
        return string;
    }

    public static void printMemory(Runtime runtime) {
        System.out.println("Free memory = " + runtime.freeMemory());
    }

    public static void main(String[] stringArray) {
        long l = System.currentTimeMillis();
        Runtime runtime = Runtime.getRuntime();
        BinarySequence.printMemory(runtime);
        try {
            long l2 = System.currentTimeMillis();
            System.out.println("Reading file " + (l2 - l) + "ms");
            l = System.currentTimeMillis();
            MSFfile mSFfile = new MSFfile(stringArray[0], "File");
            l2 = System.currentTimeMillis();
            System.out.println("done " + (l2 - l) + "ms");
            System.out.println("Creating sequences");
            l = System.currentTimeMillis();
            Sequence[] sequenceArray = new DrawableSequence[mSFfile.seqs.size()];
            int n = 0;
            while (n < mSFfile.seqs.size()) {
                sequenceArray[n] = new DrawableSequence((Sequence)mSFfile.seqs.elementAt(n));
                ++n;
            }
            l2 = System.currentTimeMillis();
            System.out.println("done " + (l2 - l) + "ms");
            System.out.println("Diagonalizing matrix");
            l = System.currentTimeMillis();
            PCA pCA = new PCA(sequenceArray);
            pCA.run();
            l2 = System.currentTimeMillis();
            System.out.println("done " + (l2 - l) + "ms");
            System.out.println("Finding component coords");
            l = System.currentTimeMillis();
            double[][] dArray = new double[mSFfile.seqs.size()][mSFfile.seqs.size()];
            int n2 = 0;
            while (n2 < mSFfile.seqs.size()) {
                if (pCA.eigenvector.d[n2] > 1.0E-4) {
                    dArray[n2] = pCA.component(n2);
                }
                ++n2;
            }
            l2 = System.currentTimeMillis();
            System.out.println("done " + (l2 - l) + "ms");
            System.out.println("Creating frame");
            l = System.currentTimeMillis();
            Frame frame = new Frame();
            frame.setLayout(new BorderLayout());
            PCAPanel pCAPanel = new PCAPanel(frame, pCA, sequenceArray);
            frame.add("Center", pCAPanel);
            frame.resize(400, 400);
            AlignFrame alignFrame = new AlignFrame(pCAPanel, (DrawableSequence[])sequenceArray);
            alignFrame.resize(700, 300);
            alignFrame.show();
            frame.show();
            return;
        }
        catch (IOException iOException) {
            System.out.println("IOException : " + iOException);
            return;
        }
    }
}

