/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.internal.util.BundleUtility;
import org.osgi.framework.Bundle;

public final class LegacyResourceSupport {
    private static String[] resourceClassNames = new String[]{"org.eclipse.core.resources.IResource", "org.eclipse.core.resources.IContainer", "org.eclipse.core.resources.IFolder", "org.eclipse.core.resources.IProject", "org.eclipse.core.resources.IFile"};
    private static Class iresourceClass = null;
    private static Class ifileClass;
    private static Class icontributorResourceAdapterClass;
    private static Class defaultContributorResourceAdapterClass;
    private static boolean resourcesPossible;
    private static boolean resourceAdapterPossible;
    static /* synthetic */ Class class$0;

    static {
        icontributorResourceAdapterClass = null;
        defaultContributorResourceAdapterClass = null;
        resourcesPossible = true;
        resourceAdapterPossible = true;
    }

    public static Class getFileClass() {
        if (ifileClass != null) {
            return ifileClass;
        }
        if (!resourcesPossible) {
            return null;
        }
        Bundle bundle = Platform.getBundle((String)"org.eclipse.core.resources");
        if (bundle == null) {
            resourcesPossible = false;
            return null;
        }
        if (!BundleUtility.isActivated(bundle)) {
            resourcesPossible = true;
            return null;
        }
        try {
            Class c;
            iresourceClass = c = bundle.loadClass("org.eclipse.core.resources.IFile");
            return iresourceClass;
        }
        catch (ClassNotFoundException classNotFoundException) {
            resourcesPossible = false;
            return null;
        }
    }

    public static Class getResourceClass() {
        if (iresourceClass != null) {
            return iresourceClass;
        }
        if (!resourcesPossible) {
            return null;
        }
        Bundle bundle = Platform.getBundle((String)"org.eclipse.core.resources");
        if (bundle == null) {
            resourcesPossible = false;
            return null;
        }
        if (!BundleUtility.isActivated(bundle)) {
            resourcesPossible = true;
            return null;
        }
        try {
            Class c;
            iresourceClass = c = bundle.loadClass("org.eclipse.core.resources.IResource");
            return iresourceClass;
        }
        catch (ClassNotFoundException classNotFoundException) {
            resourcesPossible = false;
            return null;
        }
    }

    public static Class getIContributorResourceAdapterClass() {
        if (icontributorResourceAdapterClass != null) {
            return icontributorResourceAdapterClass;
        }
        if (!resourceAdapterPossible) {
            return null;
        }
        Bundle bundle = Platform.getBundle((String)"org.eclipse.ui.ide");
        if (bundle == null) {
            resourceAdapterPossible = false;
            return null;
        }
        if (!BundleUtility.isActivated(bundle)) {
            resourceAdapterPossible = true;
            return null;
        }
        try {
            Class c;
            icontributorResourceAdapterClass = c = bundle.loadClass("org.eclipse.ui.IContributorResourceAdapter");
            return icontributorResourceAdapterClass;
        }
        catch (ClassNotFoundException classNotFoundException) {
            resourceAdapterPossible = false;
            return null;
        }
    }

    public static Class getDefaultContributorResourceAdapterClass() {
        if (defaultContributorResourceAdapterClass != null) {
            return defaultContributorResourceAdapterClass;
        }
        if (!resourceAdapterPossible) {
            return null;
        }
        Bundle bundle = Platform.getBundle((String)"org.eclipse.ui.ide");
        if (bundle == null) {
            resourceAdapterPossible = false;
            return null;
        }
        if (!BundleUtility.isActivated(bundle)) {
            resourceAdapterPossible = true;
            return null;
        }
        try {
            Class c;
            defaultContributorResourceAdapterClass = c = bundle.loadClass("org.eclipse.ui.internal.ide.DefaultContributorResourceAdapter");
            return defaultContributorResourceAdapterClass;
        }
        catch (ClassNotFoundException classNotFoundException) {
            resourceAdapterPossible = false;
            return null;
        }
    }

    public static boolean isResourceType(String objectClassName) {
        int i = 0;
        while (i < resourceClassNames.length) {
            if (resourceClassNames[i].equals(objectClassName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean isInstanceOf(Class clazz, String type) {
        if (clazz.getName().equals(type)) {
            return true;
        }
        Class superClass = clazz.getSuperclass();
        if (superClass != null && LegacyResourceSupport.isInstanceOf(superClass, type)) {
            return true;
        }
        Class<?>[] interfaces = clazz.getInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            if (LegacyResourceSupport.isInstanceOf(interfaces[i], type)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static Object getAdaptedContributorResource(Object object) {
        Class resourceClass = LegacyResourceSupport.getResourceClass();
        if (resourceClass == null) {
            return null;
        }
        if (resourceClass.isInstance(object)) {
            return null;
        }
        if (object instanceof IAdaptable) {
            Object result;
            Method m;
            IAdaptable adaptable = (IAdaptable)object;
            Class contributorResourceAdapterClass = LegacyResourceSupport.getIContributorResourceAdapterClass();
            if (contributorResourceAdapterClass == null) {
                return null;
            }
            Object resourceAdapter = adaptable.getAdapter(contributorResourceAdapterClass);
            if (resourceAdapter == null) {
                try {
                    Class c = LegacyResourceSupport.getDefaultContributorResourceAdapterClass();
                    m = c.getDeclaredMethod("getDefault", new Class[0]);
                    resourceAdapter = m.invoke(null, new Object[0]);
                }
                catch (Exception exception) {
                    return null;
                }
            }
            try {
                Class[] classArray = new Class[1];
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.core.runtime.IAdaptable");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[0] = clazz;
                m = contributorResourceAdapterClass.getDeclaredMethod("getAdaptedResource", classArray);
                result = m.invoke(resourceAdapter, adaptable);
            }
            catch (Exception exception) {
                return null;
            }
            return result;
        }
        return null;
    }

    public static IStructuredSelection adaptSelection(IStructuredSelection selection, String objectClass) {
        ArrayList<Object> newSelection = new ArrayList<Object>(10);
        Iterator it = selection.iterator();
        while (it.hasNext()) {
            Object element = it.next();
            Object adaptedElement = LegacyResourceSupport.getAdapter(element, objectClass);
            if (adaptedElement == null) continue;
            newSelection.add(adaptedElement);
        }
        return new StructuredSelection(newSelection);
    }

    public static Object getAdapter(Object element, String objectClass) {
        Object adaptedElement = null;
        adaptedElement = LegacyResourceSupport.isInstanceOf(element.getClass(), objectClass) ? element : (LegacyResourceSupport.isResourceType(objectClass) ? LegacyResourceSupport.getAdaptedResource(element) : Platform.getAdapterManager().loadAdapter(element, objectClass));
        return adaptedElement;
    }

    public static Object getAdaptedResource(Object element) {
        Class resourceClass = LegacyResourceSupport.getResourceClass();
        Object adaptedValue = null;
        if (resourceClass != null) {
            adaptedValue = resourceClass.isInstance(element) ? element : LegacyResourceSupport.getAdaptedContributorResource(element);
        }
        return adaptedValue;
    }

    private LegacyResourceSupport() {
    }
}

