/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.activities.ws;

import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.ActivityManagerEvent;
import org.eclipse.ui.activities.IActivityManager;
import org.eclipse.ui.activities.IActivityManagerListener;
import org.eclipse.ui.activities.IMutableActivityManager;
import org.eclipse.ui.activities.IWorkbenchActivitySupport;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.activities.ActivityManagerFactory;
import org.eclipse.ui.internal.activities.ProxyActivityManager;
import org.eclipse.ui.internal.activities.ws.ActivityMessages;
import org.eclipse.ui.internal.activities.ws.WorkbenchActivitySupport;
import org.eclipse.ui.internal.misc.StatusUtil;

public class WorkbenchActivitySupport
implements IWorkbenchActivitySupport {
    private IMutableActivityManager mutableActivityManager = ActivityManagerFactory.getMutableActivityManager();
    private ProxyActivityManager proxyActivityManager = new ProxyActivityManager(this.mutableActivityManager);

    public WorkbenchActivitySupport() {
        this.mutableActivityManager.addActivityManagerListener(new IActivityManagerListener(){
            private Set lastEnabled;
            {
                this.lastEnabled = new HashSet(WorkbenchActivitySupport.this.mutableActivityManager.getEnabledActivityIds());
            }

            public void activityManagerChanged(ActivityManagerEvent activityManagerEvent) {
                Set activityIds = WorkbenchActivitySupport.this.mutableActivityManager.getEnabledActivityIds();
                if (!activityIds.equals(this.lastEnabled)) {
                    this.lastEnabled = new HashSet(activityIds);
                    if (!PlatformUI.isWorkbenchRunning()) {
                        return;
                    }
                    IWorkbench workbench = PlatformUI.getWorkbench();
                    IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
                    int i = 0;
                    while (i < windows.length) {
                        if (windows[i] instanceof WorkbenchWindow) {
                            WorkbenchWindow window = (WorkbenchWindow)windows[i];
                            ProgressMonitorDialog dialog = new ProgressMonitorDialog(window.getShell());
                            IRunnableWithProgress runnable = new IRunnableWithProgress(this, workbench, window, dialog){
                                private long openTime;
                                private boolean dialogOpened;
                                final /* synthetic */ 1 this$1;
                                private final /* synthetic */ IWorkbench val$workbench;
                                private final /* synthetic */ WorkbenchWindow val$window;
                                private final /* synthetic */ ProgressMonitorDialog val$dialog;
                                {
                                    this.this$1 = var1_1;
                                    this.val$workbench = iWorkbench;
                                    this.val$window = workbenchWindow;
                                    this.val$dialog = progressMonitorDialog;
                                    this.dialogOpened = false;
                                }

                                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                    this.openTime = System.currentTimeMillis() + (long)this.val$workbench.getProgressService().getLongOperationTime();
                                    monitor.beginTask(ActivityMessages.getString("ManagerTask"), 2);
                                    monitor.subTask(ActivityMessages.getString("ManagerWindowSubTask"));
                                    this.updateWindowBars(this.val$window);
                                    monitor.worked(1);
                                    monitor.subTask(ActivityMessages.getString("ManagerViewsSubTask"));
                                    IWorkbenchPage[] pages = this.val$window.getPages();
                                    int j = 0;
                                    while (j < pages.length) {
                                        IWorkbenchPage page = pages[j];
                                        IViewReference[] refs = page.getViewReferences();
                                        int k = 0;
                                        while (k < refs.length) {
                                            IViewPart part = refs[k].getView(false);
                                            if (part != null) {
                                                this.updateViewBars(part);
                                            }
                                            ++k;
                                        }
                                        ++j;
                                    }
                                    monitor.worked(1);
                                    monitor.done();
                                }

                                private void updateViewBars(IViewPart part) {
                                    IViewSite viewSite = part.getViewSite();
                                    if (viewSite == null) {
                                        return;
                                    }
                                    IActionBars bars = viewSite.getActionBars();
                                    IMenuManager manager = bars.getMenuManager();
                                    if (manager != null) {
                                        this.updateManager((IContributionManager)manager);
                                    }
                                    if ((manager = bars.getToolBarManager()) != null) {
                                        this.updateManager((IContributionManager)manager);
                                    }
                                    if ((manager = bars.getStatusLineManager()) != null) {
                                        this.updateManager((IContributionManager)manager);
                                    }
                                }

                                private void updateWindowBars(WorkbenchWindow window) {
                                    MenuManager manager = window.getMenuBarManager();
                                    if (manager != null) {
                                        this.updateManager((IContributionManager)manager);
                                    }
                                    if ((manager = window.getCoolBarManager()) != null) {
                                        this.updateManager((IContributionManager)manager);
                                    }
                                    if ((manager = window.getToolBarManager()) != null) {
                                        this.updateManager((IContributionManager)manager);
                                    }
                                    if ((manager = window.getStatusLineManager()) != null) {
                                        this.updateManager((IContributionManager)manager);
                                    }
                                }

                                private void updateManager(IContributionManager manager) {
                                    if (!this.dialogOpened && System.currentTimeMillis() > this.openTime) {
                                        this.val$dialog.open();
                                        this.dialogOpened = true;
                                    }
                                    manager.update(true);
                                }
                            };
                            dialog.setOpenOnRun(false);
                            workbench.getDisplay().asyncExec(new Runnable(this, workbench, dialog, runnable){
                                final /* synthetic */ 1 this$1;
                                private final /* synthetic */ IWorkbench val$workbench;
                                private final /* synthetic */ ProgressMonitorDialog val$dialog;
                                private final /* synthetic */ IRunnableWithProgress val$runnable;
                                {
                                    this.this$1 = var1_1;
                                    this.val$workbench = iWorkbench;
                                    this.val$dialog = progressMonitorDialog;
                                    this.val$runnable = iRunnableWithProgress;
                                }

                                public void run() {
                                    BusyIndicator.showWhile((Display)this.val$workbench.getDisplay(), (Runnable)new Runnable(this, this.val$dialog, this.val$runnable){
                                        final /* synthetic */ 3 this$2;
                                        private final /* synthetic */ ProgressMonitorDialog val$dialog;
                                        private final /* synthetic */ IRunnableWithProgress val$runnable;
                                        {
                                            this.this$2 = var1_1;
                                            this.val$dialog = progressMonitorDialog;
                                            this.val$runnable = iRunnableWithProgress;
                                        }

                                        public void run() {
                                            try {
                                                this.val$dialog.run(false, false, this.val$runnable);
                                            }
                                            catch (InvocationTargetException e) {
                                                1.access$0(3.access$0(this.this$2), e);
                                            }
                                            catch (InterruptedException e) {
                                                1.access$0(3.access$0(this.this$2), e);
                                            }
                                        }
                                    });
                                }

                                static /* synthetic */ 1 access$0(3 var0) {
                                    return var0.this$1;
                                }
                            });
                        }
                        ++i;
                    }
                }
            }

            private void log(Exception e) {
                StatusUtil.newStatus(4, "Could not update contribution managers", (Throwable)e);
            }

            static /* synthetic */ void access$0(1 var0, Exception exception) {
                var0.log(exception);
            }
        });
    }

    public IActivityManager getActivityManager() {
        return this.proxyActivityManager;
    }

    public void setEnabledActivityIds(Set enabledActivityIds) {
        this.mutableActivityManager.setEnabledActivityIds(enabledActivityIds);
    }
}

