/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.commands;

import java.io.IOException;
import java.text.Collator;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICategory;
import org.eclipse.ui.commands.ICommand;
import org.eclipse.ui.commands.IKeyConfiguration;
import org.eclipse.ui.contexts.IContext;
import org.eclipse.ui.contexts.IContextManager;
import org.eclipse.ui.contexts.IWorkbenchContextSupport;
import org.eclipse.ui.contexts.NotDefinedException;
import org.eclipse.ui.internal.commands.ActiveKeyConfigurationDefinition;
import org.eclipse.ui.internal.commands.ImageFactory;
import org.eclipse.ui.internal.commands.KeySequenceBindingDefinition;
import org.eclipse.ui.internal.commands.KeySequenceBindingNode;
import org.eclipse.ui.internal.commands.MutableCommandManager;
import org.eclipse.ui.internal.commands.PreferenceCommandRegistry;
import org.eclipse.ui.internal.keys.KeySequenceText;
import org.eclipse.ui.internal.util.Util;
import org.eclipse.ui.keys.KeySequence;
import org.eclipse.ui.keys.KeyStroke;

public class KeysPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final int DIFFERENCE_ADD = 0;
    private static final int DIFFERENCE_CHANGE = 1;
    private static final int DIFFERENCE_MINUS = 2;
    private static final int DIFFERENCE_NONE = 3;
    private static final Image IMAGE_BLANK = ImageFactory.getImage("blank");
    private static final Image IMAGE_CHANGE = ImageFactory.getImage("change");
    private static final Image IMAGE_MINUS = ImageFactory.getImage("minus");
    private static final Image IMAGE_PLUS = ImageFactory.getImage("plus");
    private static final ResourceBundle RESOURCE_BUNDLE;
    private static final int TAB_INDEX_MODIFY = 1;
    private static final int VIEW_CATEGORY_COLUMN_INDEX = 0;
    private static final int VIEW_COMMAND_COLUMN_INDEX = 1;
    private static final int VIEW_CONTEXT_COLUMN_INDEX = 3;
    private static final int VIEW_KEY_SEQUENCE_COLUMN_INDEX = 2;
    private static final int VIEW_TOTAL_COLUMNS = 4;
    private static final String[] UNSORTED_COLUMN_NAMES;
    private static final String[] SORTED_COLUMN_NAMES;
    private Map assignmentsByContextIdByKeySequence;
    private Button buttonAdd;
    private Button buttonAddKey;
    private Button buttonRemove;
    private Button buttonRestore;
    private Map categoryIdsByUniqueName;
    private Map categoryUniqueNamesById;
    private Combo comboCategory;
    private Combo comboCommand;
    private Combo comboContext;
    private Combo comboKeyConfiguration;
    private Set commandAssignments;
    private Map commandIdsByCategoryId;
    private Map commandIdsByUniqueName;
    private MutableCommandManager commandManager;
    private Map commandUniqueNamesById;
    private Map contextIdsByUniqueName;
    private IContextManager contextManager;
    private Map contextUniqueNamesById;
    private Group groupCommand;
    private Group groupKeySequence;
    private Map keyConfigurationIdsByUniqueName;
    private Map keyConfigurationUniqueNamesById;
    private Set keySequenceAssignments;
    private Label labelAssignmentsForCommand;
    private Label labelAssignmentsForKeySequence;
    private Label labelCategory;
    private Label labelCommand;
    private Label labelContext;
    private Label labelContextExtends;
    private Label labelKeyConfiguration;
    private Label labelKeyConfigurationExtends;
    private Label labelKeySequence;
    private Menu menuButtonAddKey;
    private Color minusColour;
    private int[] sortOrder;
    private TabFolder tabFolder;
    private Table tableAssignmentsForCommand;
    private Table tableAssignmentsForKeySequence;
    private Table tableKeyBindings;
    private Text textKeySequence;
    private KeySequenceText textKeySequenceManager;
    private SortedMap tree;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.internal.commands.KeysPreferencePage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        RESOURCE_BUNDLE = ResourceBundle.getBundle(clazz.getName());
        UNSORTED_COLUMN_NAMES = new String[4];
        SORTED_COLUMN_NAMES = new String[4];
        KeysPreferencePage.UNSORTED_COLUMN_NAMES[0] = Util.translateString(RESOURCE_BUNDLE, "tableColumnCategory");
        KeysPreferencePage.UNSORTED_COLUMN_NAMES[1] = Util.translateString(RESOURCE_BUNDLE, "tableColumnCommand");
        KeysPreferencePage.UNSORTED_COLUMN_NAMES[2] = Util.translateString(RESOURCE_BUNDLE, "tableColumnKeySequence");
        KeysPreferencePage.UNSORTED_COLUMN_NAMES[3] = Util.translateString(RESOURCE_BUNDLE, "tableColumnContext");
        KeysPreferencePage.SORTED_COLUMN_NAMES[0] = Util.translateString(RESOURCE_BUNDLE, "tableColumnCategorySorted");
        KeysPreferencePage.SORTED_COLUMN_NAMES[1] = Util.translateString(RESOURCE_BUNDLE, "tableColumnCommandSorted");
        KeysPreferencePage.SORTED_COLUMN_NAMES[2] = Util.translateString(RESOURCE_BUNDLE, "tableColumnKeySequenceSorted");
        KeysPreferencePage.SORTED_COLUMN_NAMES[3] = Util.translateString(RESOURCE_BUNDLE, "tableColumnContextSorted");
    }

    public KeysPreferencePage() {
        int[] nArray = new int[4];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        this.sortOrder = nArray;
    }

    private void buildCommandAssignmentsTable() {
        this.tableAssignmentsForCommand.removeAll();
        boolean matchFoundInFirstKeyConfiguration = false;
        Iterator iterator = this.commandAssignments.iterator();
        while (iterator.hasNext()) {
            boolean createTableItem = true;
            CommandAssignment commandAssignment = (CommandAssignment)iterator.next();
            KeySequenceBindingNode.Assignment assignment = commandAssignment.assignment;
            KeySequence keySequence = commandAssignment.keySequence;
            String commandString = null;
            int difference = 3;
            if (assignment.hasPreferenceCommandIdInFirstKeyConfiguration || assignment.hasPreferenceCommandIdInInheritedKeyConfiguration) {
                String preferenceCommandId = assignment.hasPreferenceCommandIdInFirstKeyConfiguration ? assignment.preferenceCommandIdInFirstKeyConfiguration : assignment.preferenceCommandIdInInheritedKeyConfiguration;
                if (assignment.hasPluginCommandIdInFirstKeyConfiguration || assignment.hasPluginCommandIdInInheritedKeyConfiguration) {
                    String pluginCommandId = assignment.hasPluginCommandIdInFirstKeyConfiguration ? assignment.pluginCommandIdInFirstKeyConfiguration : assignment.pluginCommandIdInInheritedKeyConfiguration;
                    if (preferenceCommandId != null) {
                        difference = 1;
                        commandString = String.valueOf(keySequence.format());
                    } else {
                        difference = 2;
                        commandString = keySequence.format();
                    }
                    commandString = pluginCommandId != null ? String.valueOf(commandString) + " (was: " + this.commandUniqueNamesById.get(pluginCommandId) + ")" : String.valueOf(commandString) + " (was: Unassigned)";
                } else if (preferenceCommandId != null) {
                    difference = 0;
                    commandString = String.valueOf(keySequence.format());
                } else {
                    difference = 2;
                    commandString = keySequence.format();
                }
            } else {
                String pluginCommandId = null;
                if (assignment.hasPluginCommandIdInFirstKeyConfiguration) {
                    pluginCommandId = assignment.pluginCommandIdInFirstKeyConfiguration;
                    if (pluginCommandId != null) {
                        matchFoundInFirstKeyConfiguration = true;
                    }
                } else if (!matchFoundInFirstKeyConfiguration) {
                    pluginCommandId = assignment.pluginCommandIdInInheritedKeyConfiguration;
                } else {
                    createTableItem = false;
                    iterator.remove();
                }
                if (pluginCommandId != null) {
                    difference = 3;
                    commandString = String.valueOf(keySequence.format());
                } else {
                    difference = 2;
                    commandString = keySequence.format();
                }
            }
            if (!createTableItem) continue;
            TableItem tableItem = new TableItem(this.tableAssignmentsForCommand, 0);
            switch (difference) {
                case 0: {
                    tableItem.setImage(0, IMAGE_PLUS);
                    break;
                }
                case 1: {
                    tableItem.setImage(0, IMAGE_CHANGE);
                    break;
                }
                case 2: {
                    tableItem.setImage(0, IMAGE_MINUS);
                    break;
                }
                case 3: {
                    tableItem.setImage(0, IMAGE_BLANK);
                }
            }
            String contextId = commandAssignment.contextId;
            if (contextId == null) {
                tableItem.setText(1, "");
            } else {
                tableItem.setText(1, (String)this.contextUniqueNamesById.get(contextId));
            }
            tableItem.setText(2, commandString);
            if (difference != 2) continue;
            tableItem.setForeground(this.minusColour);
        }
    }

    private void buildKeySequenceAssignmentsTable() {
        this.tableAssignmentsForKeySequence.removeAll();
        boolean matchFoundInFirstKeyConfiguration = false;
        Iterator iterator = this.keySequenceAssignments.iterator();
        while (iterator.hasNext()) {
            boolean createTableItem = true;
            KeySequenceAssignment keySequenceAssignment = (KeySequenceAssignment)iterator.next();
            KeySequenceBindingNode.Assignment assignment = keySequenceAssignment.assignment;
            String commandString = null;
            int difference = 3;
            if (assignment.hasPreferenceCommandIdInFirstKeyConfiguration || assignment.hasPreferenceCommandIdInInheritedKeyConfiguration) {
                String preferenceCommandId = assignment.hasPreferenceCommandIdInFirstKeyConfiguration ? assignment.preferenceCommandIdInFirstKeyConfiguration : assignment.preferenceCommandIdInInheritedKeyConfiguration;
                if (assignment.hasPluginCommandIdInFirstKeyConfiguration || assignment.hasPluginCommandIdInInheritedKeyConfiguration) {
                    String pluginCommandId = assignment.hasPluginCommandIdInFirstKeyConfiguration ? assignment.pluginCommandIdInFirstKeyConfiguration : assignment.pluginCommandIdInInheritedKeyConfiguration;
                    if (preferenceCommandId != null) {
                        difference = 1;
                        commandString = "" + this.commandUniqueNamesById.get(preferenceCommandId);
                    } else {
                        difference = 2;
                        commandString = "Unassigned";
                    }
                    commandString = pluginCommandId != null ? String.valueOf(commandString) + " (was: " + this.commandUniqueNamesById.get(pluginCommandId) + ")" : String.valueOf(commandString) + " (was: Unassigned)";
                } else if (preferenceCommandId != null) {
                    difference = 0;
                    commandString = "" + this.commandUniqueNamesById.get(preferenceCommandId);
                } else {
                    difference = 2;
                    commandString = "Unassigned";
                }
            } else {
                String pluginCommandId = null;
                if (assignment.hasPluginCommandIdInFirstKeyConfiguration) {
                    pluginCommandId = assignment.pluginCommandIdInFirstKeyConfiguration;
                    if (pluginCommandId != null) {
                        matchFoundInFirstKeyConfiguration = true;
                    }
                } else if (!matchFoundInFirstKeyConfiguration) {
                    pluginCommandId = assignment.pluginCommandIdInInheritedKeyConfiguration;
                } else {
                    createTableItem = false;
                    iterator.remove();
                }
                if (pluginCommandId != null) {
                    difference = 3;
                    commandString = "" + this.commandUniqueNamesById.get(pluginCommandId);
                } else {
                    difference = 2;
                    commandString = "Unassigned";
                }
            }
            if (!createTableItem) continue;
            TableItem tableItem = new TableItem(this.tableAssignmentsForKeySequence, 0);
            switch (difference) {
                case 0: {
                    tableItem.setImage(0, IMAGE_PLUS);
                    break;
                }
                case 1: {
                    tableItem.setImage(0, IMAGE_CHANGE);
                    break;
                }
                case 2: {
                    tableItem.setImage(0, IMAGE_MINUS);
                    break;
                }
                case 3: {
                    tableItem.setImage(0, IMAGE_BLANK);
                }
            }
            String contextId = keySequenceAssignment.contextId;
            if (contextId == null) {
                tableItem.setText(1, "");
            } else {
                tableItem.setText(1, (String)this.contextUniqueNamesById.get(contextId));
            }
            tableItem.setText(2, commandString);
            if (difference != 2) continue;
            tableItem.setForeground(this.minusColour);
        }
    }

    protected Control createContents(Composite parent) {
        this.minusColour = this.getShell().getDisplay().getSystemColor(18);
        this.tabFolder = new TabFolder(parent, 0);
        TabItem viewTab = new TabItem(this.tabFolder, 0);
        viewTab.setText(Util.translateString(RESOURCE_BUNDLE, "viewTab.Text"));
        viewTab.setControl((Control)this.createViewTab(this.tabFolder));
        TabItem modifyTab = new TabItem(this.tabFolder, 0);
        modifyTab.setText(Util.translateString(RESOURCE_BUNDLE, "modifyTab.Text"));
        modifyTab.setControl((Control)this.createModifyTab(this.tabFolder));
        this.applyDialogFont((Composite)this.tabFolder);
        IPreferenceStore store = this.getPreferenceStore();
        int selectedTab = store.getInt("KEYS_PREFERENCE_SELECTED_TAB");
        if (this.tabFolder.getItemCount() > selectedTab && selectedTab > 0) {
            this.tabFolder.setSelection(selectedTab);
        }
        return this.tabFolder;
    }

    private Composite createModifyTab(TabFolder parent) {
        Composite composite = new Composite((Composite)parent, 0);
        composite.setLayout((Layout)new GridLayout());
        GridData gridData = new GridData(1808);
        composite.setLayoutData((Object)gridData);
        Composite compositeKeyConfiguration = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        compositeKeyConfiguration.setLayout((Layout)gridLayout);
        gridData = new GridData(768);
        compositeKeyConfiguration.setLayoutData((Object)gridData);
        this.labelKeyConfiguration = new Label(compositeKeyConfiguration, 16384);
        this.labelKeyConfiguration.setText(Util.translateString(RESOURCE_BUNDLE, "labelKeyConfiguration"));
        this.comboKeyConfiguration = new Combo(compositeKeyConfiguration, 8);
        gridData = new GridData();
        gridData.widthHint = 200;
        this.comboKeyConfiguration.setLayoutData((Object)gridData);
        this.comboKeyConfiguration.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                KeysPreferencePage.this.selectedComboKeyConfiguration();
            }
        });
        this.labelKeyConfigurationExtends = new Label(compositeKeyConfiguration, 16384);
        gridData = new GridData(768);
        this.labelKeyConfigurationExtends.setLayoutData((Object)gridData);
        Composite spacer = new Composite(composite, 0);
        gridData = new GridData();
        gridData.heightHint = 10;
        gridData.widthHint = 10;
        spacer.setLayoutData((Object)gridData);
        this.groupCommand = new Group(composite, 32);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        this.groupCommand.setLayout((Layout)gridLayout);
        gridData = new GridData(1808);
        this.groupCommand.setLayoutData((Object)gridData);
        this.groupCommand.setText(Util.translateString(RESOURCE_BUNDLE, "groupCommand"));
        this.labelCategory = new Label((Composite)this.groupCommand, 16384);
        gridData = new GridData();
        this.labelCategory.setLayoutData((Object)gridData);
        this.labelCategory.setText(Util.translateString(RESOURCE_BUNDLE, "labelCategory"));
        this.comboCategory = new Combo((Composite)this.groupCommand, 8);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.widthHint = 200;
        this.comboCategory.setLayoutData((Object)gridData);
        this.comboCategory.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                KeysPreferencePage.this.selectedComboCategory();
            }
        });
        this.labelCommand = new Label((Composite)this.groupCommand, 16384);
        gridData = new GridData();
        this.labelCommand.setLayoutData((Object)gridData);
        this.labelCommand.setText(Util.translateString(RESOURCE_BUNDLE, "labelCommand"));
        this.comboCommand = new Combo((Composite)this.groupCommand, 8);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.widthHint = 300;
        this.comboCommand.setLayoutData((Object)gridData);
        this.comboCommand.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                KeysPreferencePage.this.selectedComboCommand();
            }
        });
        this.labelAssignmentsForCommand = new Label((Composite)this.groupCommand, 16384);
        gridData = new GridData(2);
        gridData.verticalAlignment = 1040;
        this.labelAssignmentsForCommand.setLayoutData((Object)gridData);
        this.labelAssignmentsForCommand.setText(Util.translateString(RESOURCE_BUNDLE, "labelAssignmentsForCommand"));
        this.tableAssignmentsForCommand = new Table((Composite)this.groupCommand, 68352);
        this.tableAssignmentsForCommand.setHeaderVisible(true);
        gridData = new GridData(1808);
        gridData.heightHint = 60;
        gridData.horizontalSpan = 2;
        gridData.widthHint = "carbon".equals(SWT.getPlatform()) ? 620 : 520;
        this.tableAssignmentsForCommand.setLayoutData((Object)gridData);
        TableColumn tableColumnDelta = new TableColumn(this.tableAssignmentsForCommand, 0, 0);
        tableColumnDelta.setResizable(false);
        tableColumnDelta.setText("");
        tableColumnDelta.setWidth(20);
        TableColumn tableColumnContext = new TableColumn(this.tableAssignmentsForCommand, 0, 1);
        tableColumnContext.setResizable(true);
        tableColumnContext.setText(Util.translateString(RESOURCE_BUNDLE, "tableColumnContext"));
        tableColumnContext.pack();
        tableColumnContext.setWidth(200);
        TableColumn tableColumnKeySequence = new TableColumn(this.tableAssignmentsForCommand, 0, 2);
        tableColumnKeySequence.setResizable(true);
        tableColumnKeySequence.setText(Util.translateString(RESOURCE_BUNDLE, "tableColumnKeySequence"));
        tableColumnKeySequence.pack();
        tableColumnKeySequence.setWidth(300);
        this.tableAssignmentsForCommand.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent mouseEvent) {
                KeysPreferencePage.this.doubleClickedAssignmentsForCommand();
            }
        });
        this.tableAssignmentsForCommand.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                KeysPreferencePage.this.selectedTableAssignmentsForCommand();
            }
        });
        this.groupKeySequence = new Group(composite, 32);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        this.groupKeySequence.setLayout((Layout)gridLayout);
        gridData = new GridData(1808);
        this.groupKeySequence.setLayoutData((Object)gridData);
        this.groupKeySequence.setText(Util.translateString(RESOURCE_BUNDLE, "groupKeySequence"));
        this.labelKeySequence = new Label((Composite)this.groupKeySequence, 16384);
        gridData = new GridData();
        this.labelKeySequence.setLayoutData((Object)gridData);
        this.labelKeySequence.setText(Util.translateString(RESOURCE_BUNDLE, "labelKeySequence"));
        this.textKeySequence = new Text((Composite)this.groupKeySequence, 2048);
        this.textKeySequence.setFont(this.groupKeySequence.getFont());
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.widthHint = 300;
        this.textKeySequence.setLayoutData((Object)gridData);
        this.textKeySequence.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                KeysPreferencePage.this.modifiedTextKeySequence();
            }
        });
        this.textKeySequence.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                PlatformUI.getWorkbench().getContextSupport().setKeyFilterEnabled(false);
            }

            public void focusLost(FocusEvent e) {
                PlatformUI.getWorkbench().getContextSupport().setKeyFilterEnabled(true);
            }
        });
        this.textKeySequenceManager = new KeySequenceText(this.textKeySequence);
        this.textKeySequenceManager.setKeyStrokeLimit(4);
        this.buttonAddKey = new Button((Composite)this.groupKeySequence, 16388);
        this.buttonAddKey.setToolTipText(Util.translateString(RESOURCE_BUNDLE, "buttonAddKey.ToolTipText"));
        gridData = new GridData();
        gridData.heightHint = this.comboCategory.getTextHeight();
        this.buttonAddKey.setLayoutData((Object)gridData);
        this.buttonAddKey.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Point buttonLocation = KeysPreferencePage.this.buttonAddKey.getLocation();
                buttonLocation = KeysPreferencePage.this.groupKeySequence.toDisplay(buttonLocation.x, buttonLocation.y);
                Point buttonSize = KeysPreferencePage.this.buttonAddKey.getSize();
                KeysPreferencePage.this.menuButtonAddKey.setLocation(buttonLocation.x, buttonLocation.y + buttonSize.y);
                KeysPreferencePage.this.menuButtonAddKey.setVisible(true);
            }
        });
        Control[] tabStops = this.groupKeySequence.getTabList();
        ArrayList<Object> newTabStops = new ArrayList<Object>();
        int i = 0;
        while (i < tabStops.length) {
            Control tabStop = tabStops[i];
            newTabStops.add(tabStop);
            if (this.textKeySequence.equals(tabStop)) {
                newTabStops.add(this.buttonAddKey);
            }
            ++i;
        }
        Control[] newTabStopArray = newTabStops.toArray(new Control[newTabStops.size()]);
        this.groupKeySequence.setTabList(newTabStopArray);
        this.menuButtonAddKey = new Menu((Control)this.buttonAddKey);
        Iterator trappedKeyItr = KeySequenceText.TRAPPED_KEYS.iterator();
        while (trappedKeyItr.hasNext()) {
            final KeyStroke trappedKey = (KeyStroke)trappedKeyItr.next();
            MenuItem menuItem = new MenuItem(this.menuButtonAddKey, 8);
            menuItem.setText(trappedKey.format());
            menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    KeysPreferencePage.this.textKeySequenceManager.insert(trappedKey);
                    KeysPreferencePage.this.textKeySequence.setFocus();
                    KeysPreferencePage.this.textKeySequence.setSelection(KeysPreferencePage.this.textKeySequence.getTextLimit());
                }
            });
        }
        this.labelAssignmentsForKeySequence = new Label((Composite)this.groupKeySequence, 16384);
        gridData = new GridData(2);
        gridData.verticalAlignment = 1040;
        this.labelAssignmentsForKeySequence.setLayoutData((Object)gridData);
        this.labelAssignmentsForKeySequence.setText(Util.translateString(RESOURCE_BUNDLE, "labelAssignmentsForKeySequence"));
        this.tableAssignmentsForKeySequence = new Table((Composite)this.groupKeySequence, 68352);
        this.tableAssignmentsForKeySequence.setHeaderVisible(true);
        gridData = new GridData(1808);
        gridData.heightHint = 60;
        gridData.horizontalSpan = 3;
        gridData.widthHint = "carbon".equals(SWT.getPlatform()) ? 620 : 520;
        this.tableAssignmentsForKeySequence.setLayoutData((Object)gridData);
        tableColumnDelta = new TableColumn(this.tableAssignmentsForKeySequence, 0, 0);
        tableColumnDelta.setResizable(false);
        tableColumnDelta.setText("");
        tableColumnDelta.setWidth(20);
        tableColumnContext = new TableColumn(this.tableAssignmentsForKeySequence, 0, 1);
        tableColumnContext.setResizable(true);
        tableColumnContext.setText(Util.translateString(RESOURCE_BUNDLE, "tableColumnContext"));
        tableColumnContext.pack();
        tableColumnContext.setWidth(200);
        TableColumn tableColumnCommand = new TableColumn(this.tableAssignmentsForKeySequence, 0, 2);
        tableColumnCommand.setResizable(true);
        tableColumnCommand.setText(Util.translateString(RESOURCE_BUNDLE, "tableColumnCommand"));
        tableColumnCommand.pack();
        tableColumnCommand.setWidth(300);
        this.tableAssignmentsForKeySequence.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent mouseEvent) {
                KeysPreferencePage.this.doubleClickedTableAssignmentsForKeySequence();
            }
        });
        this.tableAssignmentsForKeySequence.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                KeysPreferencePage.this.selectedTableAssignmentsForKeySequence();
            }
        });
        Composite compositeContext = new Composite(composite, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        compositeContext.setLayout((Layout)gridLayout);
        gridData = new GridData(768);
        compositeContext.setLayoutData((Object)gridData);
        this.labelContext = new Label(compositeContext, 16384);
        this.labelContext.setText(Util.translateString(RESOURCE_BUNDLE, "labelContext"));
        this.comboContext = new Combo(compositeContext, 8);
        gridData = new GridData();
        gridData.widthHint = 250;
        this.comboContext.setLayoutData((Object)gridData);
        this.comboContext.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                KeysPreferencePage.this.selectedComboContext();
            }
        });
        this.labelContextExtends = new Label(compositeContext, 16384);
        gridData = new GridData(768);
        this.labelContextExtends.setLayoutData((Object)gridData);
        Composite compositeButton = new Composite(composite, 0);
        gridLayout = new GridLayout();
        gridLayout.marginHeight = 20;
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 3;
        compositeButton.setLayout((Layout)gridLayout);
        gridData = new GridData();
        compositeButton.setLayoutData((Object)gridData);
        this.buttonAdd = new Button(compositeButton, 0x1000008);
        gridData = new GridData();
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        this.buttonAdd.setText(Util.translateString(RESOURCE_BUNDLE, "buttonAdd"));
        gridData.widthHint = Math.max(widthHint, this.buttonAdd.computeSize((int)-1, (int)-1, (boolean)true).x) + 5;
        this.buttonAdd.setLayoutData((Object)gridData);
        this.buttonAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                KeysPreferencePage.this.selectedButtonAdd();
            }
        });
        this.buttonRemove = new Button(compositeButton, 0x1000008);
        gridData = new GridData();
        widthHint = this.convertHorizontalDLUsToPixels(61);
        this.buttonRemove.setText(Util.translateString(RESOURCE_BUNDLE, "buttonRemove"));
        gridData.widthHint = Math.max(widthHint, this.buttonRemove.computeSize((int)-1, (int)-1, (boolean)true).x) + 5;
        this.buttonRemove.setLayoutData((Object)gridData);
        this.buttonRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                KeysPreferencePage.this.selectedButtonRemove();
            }
        });
        this.buttonRestore = new Button(compositeButton, 0x1000008);
        gridData = new GridData();
        widthHint = this.convertHorizontalDLUsToPixels(61);
        this.buttonRestore.setText(Util.translateString(RESOURCE_BUNDLE, "buttonRestore"));
        gridData.widthHint = Math.max(widthHint, this.buttonRestore.computeSize((int)-1, (int)-1, (boolean)true).x) + 5;
        this.buttonRestore.setLayoutData((Object)gridData);
        this.buttonRestore.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                KeysPreferencePage.this.selectedButtonRestore();
            }
        });
        return composite;
    }

    private final Composite createViewTab(TabFolder parent) {
        GridData gridData = null;
        Composite composite = new Composite((Composite)parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)new GridLayout());
        this.tableKeyBindings = new Table(composite, 68352);
        this.tableKeyBindings.setHeaderVisible(true);
        gridData = new GridData(1808);
        gridData.heightHint = 400;
        gridData.horizontalSpan = 2;
        this.tableKeyBindings.setLayoutData((Object)gridData);
        TableColumn tableColumnCategory = new TableColumn(this.tableKeyBindings, 0, 0);
        tableColumnCategory.setText(SORTED_COLUMN_NAMES[0]);
        tableColumnCategory.addSelectionListener((SelectionListener)new SortOrderSelectionListener(0));
        TableColumn tableColumnCommand = new TableColumn(this.tableKeyBindings, 0, 1);
        tableColumnCommand.setText(UNSORTED_COLUMN_NAMES[1]);
        tableColumnCommand.addSelectionListener((SelectionListener)new SortOrderSelectionListener(1));
        TableColumn tableColumnKeySequence = new TableColumn(this.tableKeyBindings, 0, 2);
        tableColumnKeySequence.setText(UNSORTED_COLUMN_NAMES[2]);
        tableColumnKeySequence.addSelectionListener((SelectionListener)new SortOrderSelectionListener(2));
        TableColumn tableColumnContext = new TableColumn(this.tableKeyBindings, 0, 3);
        tableColumnContext.setText(UNSORTED_COLUMN_NAMES[3]);
        tableColumnContext.addSelectionListener((SelectionListener)new SortOrderSelectionListener(3));
        this.tableKeyBindings.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public final void widgetDefaultSelected(SelectionEvent e) {
                KeysPreferencePage.this.selectedTableKeyBindings();
            }
        });
        Composite buttonBar = new Composite(composite, 0);
        buttonBar.setLayout((Layout)new GridLayout(2, false));
        gridData = new GridData();
        gridData.horizontalAlignment = 3;
        buttonBar.setLayoutData((Object)gridData);
        Button editButton = new Button(buttonBar, 8);
        gridData = new GridData();
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        gridData.widthHint = Math.max(widthHint, editButton.computeSize((int)-1, (int)-1, (boolean)true).x) + 5;
        editButton.setLayoutData((Object)gridData);
        editButton.setText(Util.translateString(RESOURCE_BUNDLE, "buttonEdit"));
        editButton.addSelectionListener(new SelectionListener(){

            public final void widgetDefaultSelected(SelectionEvent event) {
                KeysPreferencePage.this.selectedTableKeyBindings();
            }

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }
        });
        Button buttonExport = new Button(buttonBar, 8);
        gridData = new GridData();
        widthHint = this.convertHorizontalDLUsToPixels(61);
        gridData.widthHint = Math.max(widthHint, buttonExport.computeSize((int)-1, (int)-1, (boolean)true).x) + 5;
        buttonExport.setLayoutData((Object)gridData);
        buttonExport.setText(Util.translateString(RESOURCE_BUNDLE, "buttonExport"));
        buttonExport.addSelectionListener(new SelectionListener(){

            public final void widgetDefaultSelected(SelectionEvent event) {
                KeysPreferencePage.this.selectedButtonExport();
            }

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }
        });
        return composite;
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return PlatformUI.getWorkbench().getPreferenceStore();
    }

    private void doubleClickedAssignmentsForCommand() {
        this.update();
    }

    private void doubleClickedTableAssignmentsForKeySequence() {
        this.update();
    }

    public final void editCommand(String commandName, String keySequence) {
        String commandId = (String)this.commandIdsByUniqueName.get(commandName);
        String categoryId = null;
        if (commandId != null) {
            ICommand command = this.commandManager.getCommand(commandId);
            try {
                categoryId = command.getCategoryId();
            }
            catch (org.eclipse.ui.commands.NotDefinedException notDefinedException) {}
        }
        String categoryName = (String)this.categoryUniqueNamesById.get(categoryId);
        this.editCommand(categoryName, commandName, keySequence);
    }

    public final void editCommand(String categoryName, String commandName, String keySequence) {
        this.tabFolder.setSelection(1);
        if (commandName == null || categoryName == null || keySequence == null) {
            return;
        }
        String[] categoryNames = this.comboCategory.getItems();
        int i = 0;
        while (i < categoryNames.length) {
            if (categoryName.equals(categoryNames[i])) break;
            ++i;
        }
        if (i >= this.comboCategory.getItemCount()) {
            return;
        }
        this.comboCategory.select(i);
        this.setCommandsForCategory();
        String[] commandNames = this.comboCommand.getItems();
        int j = 0;
        while (j < commandNames.length) {
            if (commandName.equals(commandNames[j])) break;
            ++j;
        }
        if (j >= this.comboCommand.getItemCount()) {
            this.comboCommand.select(0);
            this.update();
            return;
        }
        this.comboCommand.select(j);
        this.update();
        TableItem[] items = this.tableAssignmentsForCommand.getItems();
        int k = 0;
        while (k < items.length) {
            String currentKeySequence = items[k].getText(2);
            if (keySequence.equals(currentKeySequence)) break;
            ++k;
        }
        if (k < this.tableAssignmentsForCommand.getItemCount()) {
            this.tableAssignmentsForCommand.select(k);
            this.tableAssignmentsForCommand.notifyListeners(13, null);
            this.textKeySequence.setFocus();
        }
    }

    private String getCategoryId() {
        return !this.commandIdsByCategoryId.containsKey(null) || this.comboCategory.getSelectionIndex() > 0 ? (String)this.categoryIdsByUniqueName.get(this.comboCategory.getText()) : null;
    }

    private String getCommandId() {
        return (String)this.commandIdsByUniqueName.get(this.comboCommand.getText());
    }

    private String getContextId() {
        return this.comboContext.getSelectionIndex() >= 0 ? (String)this.contextIdsByUniqueName.get(this.comboContext.getText()) : null;
    }

    private String getKeyConfigurationId() {
        return this.comboKeyConfiguration.getSelectionIndex() >= 0 ? (String)this.keyConfigurationIdsByUniqueName.get(this.comboKeyConfiguration.getText()) : null;
    }

    private KeySequence getKeySequence() {
        return this.textKeySequenceManager.getKeySequence();
    }

    public void init(IWorkbench workbench) {
        IWorkbenchContextSupport workbenchContextSupport = workbench.getContextSupport();
        this.contextManager = workbenchContextSupport.getContextManager();
        this.commandManager = (MutableCommandManager)workbench.getCommandSupport().getCommandManager();
        this.commandAssignments = new TreeSet();
        this.keySequenceAssignments = new TreeSet();
    }

    private void modifiedTextKeySequence() {
        this.update();
    }

    public final boolean performCancel() {
        IPreferenceStore store = this.getPreferenceStore();
        store.setValue("KEYS_PREFERENCE_SELECTED_TAB", this.tabFolder.getSelectionIndex());
        return super.performCancel();
    }

    protected void performDefaults() {
        String activeKeyConfigurationId = this.getKeyConfigurationId();
        ArrayList preferenceKeySequenceBindingDefinitions = new ArrayList();
        KeySequenceBindingNode.getKeySequenceBindingDefinitions(this.tree, KeySequence.getInstance(), 0, preferenceKeySequenceBindingDefinitions);
        if (activeKeyConfigurationId != null || !preferenceKeySequenceBindingDefinitions.isEmpty()) {
            String title = Util.translateString(RESOURCE_BUNDLE, "restoreDefaultsMessageBoxText");
            String message = Util.translateString(RESOURCE_BUNDLE, "restoreDefaultsMessageBoxMessage");
            boolean confirmed = MessageDialog.openConfirm((Shell)this.getShell(), (String)title, (String)message);
            if (confirmed) {
                this.setKeyConfigurationId("org.eclipse.ui.defaultAcceleratorConfiguration");
                Iterator iterator = preferenceKeySequenceBindingDefinitions.iterator();
                while (iterator.hasNext()) {
                    KeySequenceBindingDefinition keySequenceBindingDefinition = (KeySequenceBindingDefinition)iterator.next();
                    KeySequenceBindingNode.remove(this.tree, keySequenceBindingDefinition.getKeySequence(), keySequenceBindingDefinition.getContextId(), keySequenceBindingDefinition.getKeyConfigurationId(), 0, keySequenceBindingDefinition.getPlatform(), keySequenceBindingDefinition.getLocale(), keySequenceBindingDefinition.getCommandId());
                }
            }
        }
        this.update();
    }

    public boolean performOk() {
        ArrayList<ActiveKeyConfigurationDefinition> preferenceActiveKeyConfigurationDefinitions = new ArrayList<ActiveKeyConfigurationDefinition>();
        preferenceActiveKeyConfigurationDefinitions.add(new ActiveKeyConfigurationDefinition(this.getKeyConfigurationId(), null));
        PreferenceCommandRegistry preferenceCommandRegistry = (PreferenceCommandRegistry)this.commandManager.getMutableCommandRegistry();
        preferenceCommandRegistry.setActiveKeyConfigurationDefinitions(preferenceActiveKeyConfigurationDefinitions);
        ArrayList preferenceKeySequenceBindingDefinitions = new ArrayList();
        KeySequenceBindingNode.getKeySequenceBindingDefinitions(this.tree, KeySequence.getInstance(), 0, preferenceKeySequenceBindingDefinitions);
        preferenceCommandRegistry.setKeySequenceBindingDefinitions(preferenceKeySequenceBindingDefinitions);
        try {
            preferenceCommandRegistry.save();
        }
        catch (IOException iOException) {}
        IPreferenceStore store = this.getPreferenceStore();
        store.setValue("KEYS_PREFERENCE_SELECTED_TAB", this.tabFolder.getSelectionIndex());
        return super.performOk();
    }

    private void selectAssignmentForCommand(String contextId) {
        if (this.tableAssignmentsForCommand.getSelectionCount() > 1) {
            this.tableAssignmentsForCommand.deselectAll();
        }
        int i = 0;
        int selection = -1;
        KeySequence keySequence = this.getKeySequence();
        Iterator iterator = this.commandAssignments.iterator();
        while (iterator.hasNext()) {
            CommandAssignment commandAssignment = (CommandAssignment)iterator.next();
            if (Util.equals(contextId, commandAssignment.contextId) && Util.equals(keySequence, commandAssignment.keySequence)) {
                selection = i;
                break;
            }
            ++i;
        }
        if (selection != this.tableAssignmentsForCommand.getSelectionIndex()) {
            if (selection == -1 || selection >= this.tableAssignmentsForCommand.getItemCount()) {
                this.tableAssignmentsForCommand.deselectAll();
            } else {
                this.tableAssignmentsForCommand.select(selection);
            }
        }
    }

    private void selectAssignmentForKeySequence(String contextId) {
        if (this.tableAssignmentsForKeySequence.getSelectionCount() > 1) {
            this.tableAssignmentsForKeySequence.deselectAll();
        }
        int i = 0;
        int selection = -1;
        Iterator iterator = this.keySequenceAssignments.iterator();
        while (iterator.hasNext()) {
            KeySequenceAssignment keySequenceAssignment = (KeySequenceAssignment)iterator.next();
            if (Util.equals(contextId, keySequenceAssignment.contextId)) {
                selection = i;
                break;
            }
            ++i;
        }
        if (selection != this.tableAssignmentsForKeySequence.getSelectionIndex()) {
            if (selection == -1 || selection >= this.tableAssignmentsForKeySequence.getItemCount()) {
                this.tableAssignmentsForKeySequence.deselectAll();
            } else {
                this.tableAssignmentsForKeySequence.select(selection);
            }
        }
    }

    private void selectedButtonAdd() {
        String commandId = this.getCommandId();
        String contextId = this.getContextId();
        String keyConfigurationId = this.getKeyConfigurationId();
        KeySequence keySequence = this.getKeySequence();
        KeySequenceBindingNode.remove(this.tree, keySequence, contextId, keyConfigurationId, 0, null, null);
        KeySequenceBindingNode.add(this.tree, keySequence, contextId, keyConfigurationId, 0, null, null, commandId);
        ArrayList preferenceKeySequenceBindingDefinitions = new ArrayList();
        KeySequenceBindingNode.getKeySequenceBindingDefinitions(this.tree, KeySequence.getInstance(), 0, preferenceKeySequenceBindingDefinitions);
        this.update();
    }

    private final void selectedButtonExport() {
        FileDialog fileDialog = new FileDialog(this.getShell());
        fileDialog.setFilterExtensions(new String[]{"*.csv"});
        fileDialog.setFilterNames(new String[]{Util.translateString(RESOURCE_BUNDLE, "csvFilterName")});
        final String filePath = fileDialog.open();
        if (filePath == null) {
            return;
        }
        SafeRunnable runnable = new SafeRunnable(){

            /*
             * Exception decompiling
             */
            public final void run() throws IOException {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [1 : 141->145)] java.lang.Throwable
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        };
        Platform.run((ISafeRunnable)runnable);
    }

    private void selectedButtonRemove() {
        String contextId = this.getContextId();
        String keyConfigurationId = this.getKeyConfigurationId();
        KeySequence keySequence = this.getKeySequence();
        KeySequenceBindingNode.remove(this.tree, keySequence, contextId, keyConfigurationId, 0, null, null);
        KeySequenceBindingNode.add(this.tree, keySequence, contextId, keyConfigurationId, 0, null, null, null);
        ArrayList preferenceKeySequenceBindingDefinitions = new ArrayList();
        KeySequenceBindingNode.getKeySequenceBindingDefinitions(this.tree, KeySequence.getInstance(), 0, preferenceKeySequenceBindingDefinitions);
        this.update();
    }

    private void selectedButtonRestore() {
        String contextId = this.getContextId();
        String keyConfigurationId = this.getKeyConfigurationId();
        KeySequence keySequence = this.getKeySequence();
        KeySequenceBindingNode.remove(this.tree, keySequence, contextId, keyConfigurationId, 0, null, null);
        ArrayList preferenceKeySequenceBindingDefinitions = new ArrayList();
        KeySequenceBindingNode.getKeySequenceBindingDefinitions(this.tree, KeySequence.getInstance(), 0, preferenceKeySequenceBindingDefinitions);
        this.update();
    }

    private void selectedComboCategory() {
        this.update();
    }

    private void selectedComboCommand() {
        this.update();
    }

    private void selectedComboContext() {
        this.update();
    }

    private void selectedComboKeyConfiguration() {
        this.update();
    }

    private void selectedTableAssignmentsForCommand() {
        int selection = this.tableAssignmentsForCommand.getSelectionIndex();
        ArrayList commandAssignmentsAsList = new ArrayList(this.commandAssignments);
        if (selection >= 0 && selection < commandAssignmentsAsList.size() && this.tableAssignmentsForCommand.getSelectionCount() == 1) {
            CommandAssignment commandAssignment = (CommandAssignment)commandAssignmentsAsList.get(selection);
            String contextId = commandAssignment.contextId;
            KeySequence keySequence = commandAssignment.keySequence;
            this.setContextId(contextId);
            this.setKeySequence(keySequence);
        }
        this.update();
    }

    private void selectedTableAssignmentsForKeySequence() {
        int selection = this.tableAssignmentsForKeySequence.getSelectionIndex();
        ArrayList keySequenceAssignmentsAsList = new ArrayList(this.keySequenceAssignments);
        if (selection >= 0 && selection < keySequenceAssignmentsAsList.size() && this.tableAssignmentsForKeySequence.getSelectionCount() == 1) {
            KeySequenceAssignment keySequenceAssignment = (KeySequenceAssignment)keySequenceAssignmentsAsList.get(selection);
            String contextId = keySequenceAssignment.contextId;
            this.setContextId(contextId);
        }
        this.update();
    }

    private final void selectedTableKeyBindings() {
        int selectionIndex = this.tableKeyBindings.getSelectionIndex();
        if (selectionIndex != -1) {
            TableItem item = this.tableKeyBindings.getItem(selectionIndex);
            String categoryName = item.getText(0);
            String commandName = item.getText(1);
            String keySequence = item.getText(2);
            this.editCommand(categoryName, commandName, keySequence);
        } else {
            this.editCommand(null, null, null);
        }
    }

    private void setAssignmentsForCommand() {
        this.commandAssignments.clear();
        String commandId = this.getCommandId();
        Iterator iterator = this.assignmentsByContextIdByKeySequence.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            KeySequence keySequence = (KeySequence)entry.getKey();
            Map assignmentsByContextId = (Map)entry.getValue();
            if (assignmentsByContextId == null) continue;
            Iterator iterator2 = assignmentsByContextId.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry entry2 = iterator2.next();
                CommandAssignment commandAssignment = new CommandAssignment();
                commandAssignment.assignment = (KeySequenceBindingNode.Assignment)entry2.getValue();
                commandAssignment.contextId = (String)entry2.getKey();
                commandAssignment.keySequence = keySequence;
                if (!commandAssignment.assignment.contains(commandId)) continue;
                this.commandAssignments.add(commandAssignment);
            }
        }
        this.buildCommandAssignmentsTable();
    }

    private void setAssignmentsForKeySequence() {
        this.keySequenceAssignments.clear();
        KeySequence keySequence = this.getKeySequence();
        Map assignmentsByContextId = (Map)this.assignmentsByContextIdByKeySequence.get(keySequence);
        if (assignmentsByContextId != null) {
            Iterator iterator = assignmentsByContextId.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                KeySequenceAssignment keySequenceAssignment = new KeySequenceAssignment();
                keySequenceAssignment.assignment = (KeySequenceBindingNode.Assignment)entry.getValue();
                keySequenceAssignment.contextId = (String)entry.getKey();
                this.keySequenceAssignments.add(keySequenceAssignment);
            }
        }
        this.buildKeySequenceAssignmentsTable();
    }

    private void setCommandId(String commandId) {
        this.comboCommand.clearSelection();
        this.comboCommand.deselectAll();
        String commandUniqueName = (String)this.commandUniqueNamesById.get(commandId);
        if (commandUniqueName != null) {
            String[] items = this.comboCommand.getItems();
            int i = 0;
            while (i < items.length) {
                if (commandUniqueName.equals(items[i])) {
                    this.comboCommand.select(i);
                    break;
                }
                ++i;
            }
        }
    }

    private void setCommandsForCategory() {
        String categoryId = this.getCategoryId();
        String commandId = this.getCommandId();
        Set commandIds = (Set)this.commandIdsByCategoryId.get(categoryId);
        HashMap commandIdsByName = new HashMap(this.commandIdsByUniqueName);
        if (commandIds == null) {
            commandIdsByName = new HashMap();
        } else {
            commandIdsByName.values().retainAll(commandIds);
        }
        ArrayList commandNames = new ArrayList(commandIdsByName.keySet());
        Collections.sort(commandNames, Collator.getInstance());
        this.comboCommand.setItems(commandNames.toArray(new String[commandNames.size()]));
        this.setCommandId(commandId);
        if (this.comboCommand.getSelectionIndex() == -1 && !commandNames.isEmpty()) {
            this.comboCommand.select(0);
        }
    }

    private void setContextId(String contextId) {
        this.comboContext.clearSelection();
        this.comboContext.deselectAll();
        String contextName = (String)this.contextUniqueNamesById.get(contextId);
        if (contextName == null) {
            contextName = (String)this.contextUniqueNamesById.get("org.eclipse.ui.contexts.window");
        }
        if (contextName == null) {
            contextName = "";
        }
        String[] items = this.comboContext.getItems();
        boolean found = false;
        int i = 0;
        while (i < items.length) {
            if (contextName.equals(items[i])) {
                this.comboContext.select(i);
                found = true;
                break;
            }
            ++i;
        }
        if (!found && items.length > 0) {
            this.comboContext.select(0);
        }
    }

    private void setContextsForCommand() {
        this.getCommandId();
        String contextId = this.getContextId();
        HashMap contextIdsByName = new HashMap(this.contextIdsByUniqueName);
        ArrayList contextNames = new ArrayList(contextIdsByName.keySet());
        Collections.sort(contextNames, Collator.getInstance());
        this.comboContext.setItems(contextNames.toArray(new String[contextNames.size()]));
        this.setContextId(contextId);
        if (this.comboContext.getSelectionIndex() == -1 && !contextNames.isEmpty()) {
            this.comboContext.select(0);
        }
    }

    private void setKeyConfigurationId(String keyConfigurationId) {
        this.comboKeyConfiguration.clearSelection();
        this.comboKeyConfiguration.deselectAll();
        String keyConfigurationUniqueName = (String)this.keyConfigurationUniqueNamesById.get(keyConfigurationId);
        if (keyConfigurationUniqueName != null) {
            String[] items = this.comboKeyConfiguration.getItems();
            int i = 0;
            while (i < items.length) {
                if (keyConfigurationUniqueName.equals(items[i])) {
                    this.comboKeyConfiguration.select(i);
                    break;
                }
                ++i;
            }
        }
    }

    private void setKeySequence(KeySequence keySequence) {
        this.textKeySequenceManager.setKeySequence(keySequence);
    }

    /*
     * Unable to fully structure code
     */
    public void setVisible(boolean visible) {
        block34: {
            if (!visible) break block34;
            contextsByName = new HashMap<String, HashSet<IContext>>();
            iterator = this.contextManager.getDefinedContextIds().iterator();
            while (iterator.hasNext()) {
                context = this.contextManager.getContext((String)iterator.next());
                try {
                    name = context.getName();
                    contexts = (HashSet<IContext>)contextsByName.get(name);
                    if (contexts == null) {
                        contexts = new HashSet<IContext>();
                        contextsByName.put(name, contexts);
                    }
                    contexts.add(context);
                }
                catch (NotDefinedException v0) {}
            }
            categoriesByName = new HashMap<String, HashSet<ICategory>>();
            iterator = this.commandManager.getDefinedCategoryIds().iterator();
            while (iterator.hasNext()) {
                category = this.commandManager.getCategory((String)iterator.next());
                try {
                    name = category.getName();
                    categories = (HashSet<ICategory>)categoriesByName.get(name);
                    if (categories == null) {
                        categories = new HashSet<ICategory>();
                        categoriesByName.put(name, categories);
                    }
                    categories.add(category);
                }
                catch (org.eclipse.ui.commands.NotDefinedException v1) {}
            }
            commandsByName = new HashMap<String, HashSet<ICommand>>();
            iterator = this.commandManager.getDefinedCommandIds().iterator();
            while (iterator.hasNext()) {
                command = this.commandManager.getCommand((String)iterator.next());
                try {
                    name = command.getName();
                    commands = (HashSet<ICommand>)commandsByName.get(name);
                    if (commands == null) {
                        commands = new HashSet<ICommand>();
                        commandsByName.put(name, commands);
                    }
                    commands.add(command);
                }
                catch (org.eclipse.ui.commands.NotDefinedException v2) {}
            }
            keyConfigurationsByName = new HashMap<String, HashSet<IKeyConfiguration>>();
            iterator = this.commandManager.getDefinedKeyConfigurationIds().iterator();
            while (iterator.hasNext()) {
                keyConfiguration = this.commandManager.getKeyConfiguration((String)iterator.next());
                try {
                    name = keyConfiguration.getName();
                    keyConfigurations = (HashSet<IKeyConfiguration>)keyConfigurationsByName.get(name);
                    if (keyConfigurations == null) {
                        keyConfigurations = new HashSet<IKeyConfiguration>();
                        keyConfigurationsByName.put(name, (HashSet<IKeyConfiguration>)keyConfigurations);
                    }
                    keyConfigurations.add(keyConfiguration);
                }
                catch (org.eclipse.ui.commands.NotDefinedException v3) {}
            }
            this.contextIdsByUniqueName = new HashMap<K, V>();
            this.contextUniqueNamesById = new HashMap<K, V>();
            iterator = contextsByName.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = (Map.Entry)iterator.next();
                name = (String)entry.getKey();
                contexts = (Set)entry.getValue();
                iterator2 = contexts.iterator();
                if (contexts.size() != 1) ** GOTO lbl87
                context = (IContext)iterator2.next();
                this.contextIdsByUniqueName.put(name, context.getId());
                this.contextUniqueNamesById.put(context.getId(), name);
                continue;
lbl-1000:
                // 1 sources

                {
                    context = (IContext)iterator2.next();
                    uniqueName = MessageFormat.format(Util.translateString(KeysPreferencePage.RESOURCE_BUNDLE, "uniqueName"), new Object[]{name, context.getId()});
                    this.contextIdsByUniqueName.put(uniqueName, context.getId());
                    this.contextUniqueNamesById.put(context.getId(), uniqueName);
lbl87:
                    // 2 sources

                    ** while (iterator2.hasNext())
                }
lbl88:
                // 1 sources

            }
            this.categoryIdsByUniqueName = new HashMap<K, V>();
            this.categoryUniqueNamesById = new HashMap<K, V>();
            iterator = categoriesByName.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = (Map.Entry)iterator.next();
                name = (String)entry.getKey();
                categories = (Set)entry.getValue();
                iterator2 = categories.iterator();
                if (categories.size() != 1) ** GOTO lbl110
                category = (ICategory)iterator2.next();
                this.categoryIdsByUniqueName.put(name, category.getId());
                this.categoryUniqueNamesById.put(category.getId(), name);
                continue;
lbl-1000:
                // 1 sources

                {
                    category = (ICategory)iterator2.next();
                    uniqueName = MessageFormat.format(Util.translateString(KeysPreferencePage.RESOURCE_BUNDLE, "uniqueName"), new Object[]{name, category.getId()});
                    this.categoryIdsByUniqueName.put(uniqueName, category.getId());
                    this.categoryUniqueNamesById.put(category.getId(), uniqueName);
lbl110:
                    // 2 sources

                    ** while (iterator2.hasNext())
                }
lbl111:
                // 1 sources

            }
            this.commandIdsByUniqueName = new HashMap<K, V>();
            this.commandUniqueNamesById = new HashMap<K, V>();
            iterator = commandsByName.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = (Map.Entry)iterator.next();
                name = (String)entry.getKey();
                commands = (Set)entry.getValue();
                iterator2 = commands.iterator();
                if (commands.size() != 1) ** GOTO lbl133
                command = (ICommand)iterator2.next();
                this.commandIdsByUniqueName.put(name, command.getId());
                this.commandUniqueNamesById.put(command.getId(), name);
                continue;
lbl-1000:
                // 1 sources

                {
                    command = (ICommand)iterator2.next();
                    uniqueName = MessageFormat.format(Util.translateString(KeysPreferencePage.RESOURCE_BUNDLE, "uniqueName"), new Object[]{name, command.getId()});
                    this.commandIdsByUniqueName.put(uniqueName, command.getId());
                    this.commandUniqueNamesById.put(command.getId(), uniqueName);
lbl133:
                    // 2 sources

                    ** while (iterator2.hasNext())
                }
lbl134:
                // 1 sources

            }
            this.keyConfigurationIdsByUniqueName = new HashMap<K, V>();
            this.keyConfigurationUniqueNamesById = new HashMap<K, V>();
            iterator = keyConfigurationsByName.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = (Map.Entry)iterator.next();
                name = (String)entry.getKey();
                keyConfigurations = (Set)entry.getValue();
                iterator2 = keyConfigurations.iterator();
                if (keyConfigurations.size() != 1) ** GOTO lbl156
                keyConfiguration = (IKeyConfiguration)iterator2.next();
                this.keyConfigurationIdsByUniqueName.put(name, keyConfiguration.getId());
                this.keyConfigurationUniqueNamesById.put(keyConfiguration.getId(), name);
                continue;
lbl-1000:
                // 1 sources

                {
                    keyConfiguration = (IKeyConfiguration)iterator2.next();
                    uniqueName = MessageFormat.format(Util.translateString(KeysPreferencePage.RESOURCE_BUNDLE, "uniqueName"), new Object[]{name, keyConfiguration.getId()});
                    this.keyConfigurationIdsByUniqueName.put(uniqueName, keyConfiguration.getId());
                    this.keyConfigurationUniqueNamesById.put(keyConfiguration.getId(), uniqueName);
lbl156:
                    // 2 sources

                    ** while (iterator2.hasNext())
                }
lbl157:
                // 1 sources

            }
            activeKeyConfigurationId = this.commandManager.getActiveKeyConfigurationId();
            this.commandIdsByCategoryId = new HashMap<K, V>();
            iterator = this.commandManager.getDefinedCommandIds().iterator();
            while (iterator.hasNext()) {
                command = this.commandManager.getCommand((String)iterator.next());
                try {
                    categoryId = command.getCategoryId();
                    commandIds = (HashSet<String>)this.commandIdsByCategoryId.get(categoryId);
                    if (commandIds == null) {
                        commandIds = new HashSet<String>();
                        this.commandIdsByCategoryId.put(categoryId, commandIds);
                    }
                    commandIds.add(command.getId());
                }
                catch (org.eclipse.ui.commands.NotDefinedException v4) {}
            }
            commandRegistry = this.commandManager.getCommandRegistry();
            mutableCommandRegistry = this.commandManager.getMutableCommandRegistry();
            pluginKeySequenceBindingDefinitions = new ArrayList<E>(commandRegistry.getKeySequenceBindingDefinitions());
            iterator = pluginKeySequenceBindingDefinitions.iterator();
            while (iterator.hasNext()) {
                keySequenceBindingDefinition = (KeySequenceBindingDefinition)iterator.next();
                keySequence = keySequenceBindingDefinition.getKeySequence();
                commandId = keySequenceBindingDefinition.getCommandId();
                contextId = keySequenceBindingDefinition.getContextId();
                keyConfigurationId = keySequenceBindingDefinition.getKeyConfigurationId();
                validKeySequence = keySequence != null && MutableCommandManager.validateKeySequence(keySequence) != false;
                validContextId = contextId == null || this.contextManager.getDefinedContextIds().contains(contextId) != false;
                validCommandId = commandId == null || this.commandManager.getDefinedCommandIds().contains(commandId) != false;
                v5 = validKeyConfigurationId = keyConfigurationId == null || this.commandManager.getDefinedKeyConfigurationIds().contains(keyConfigurationId) != false;
                if (validKeySequence && validCommandId && validContextId && validKeyConfigurationId) continue;
                iterator.remove();
            }
            preferenceKeySequenceBindingDefinitions = new ArrayList<E>(mutableCommandRegistry.getKeySequenceBindingDefinitions());
            iterator = preferenceKeySequenceBindingDefinitions.iterator();
            while (iterator.hasNext()) {
                keySequenceBindingDefinition = (KeySequenceBindingDefinition)iterator.next();
                keySequence = keySequenceBindingDefinition.getKeySequence();
                commandId = keySequenceBindingDefinition.getCommandId();
                contextId = keySequenceBindingDefinition.getContextId();
                keyConfigurationId = keySequenceBindingDefinition.getKeyConfigurationId();
                validKeySequence = keySequence != null && MutableCommandManager.validateKeySequence(keySequence) != false;
                validContextId = contextId == null || this.contextManager.getDefinedContextIds().contains(contextId) != false;
                validCommandId = commandId == null || this.commandManager.getDefinedCommandIds().contains(commandId) != false;
                v6 = validKeyConfigurationId = keyConfigurationId == null || this.commandManager.getDefinedKeyConfigurationIds().contains(keyConfigurationId) != false;
                if (validKeySequence && validCommandId && validContextId && validKeyConfigurationId) continue;
                iterator.remove();
            }
            this.tree = new TreeMap<K, V>();
            iterator = pluginKeySequenceBindingDefinitions.iterator();
            while (iterator.hasNext()) {
                keySequenceBindingDefinition = (KeySequenceBindingDefinition)iterator.next();
                KeySequenceBindingNode.add(this.tree, keySequenceBindingDefinition.getKeySequence(), keySequenceBindingDefinition.getContextId(), keySequenceBindingDefinition.getKeyConfigurationId(), 1, keySequenceBindingDefinition.getPlatform(), keySequenceBindingDefinition.getLocale(), keySequenceBindingDefinition.getCommandId());
            }
            iterator = preferenceKeySequenceBindingDefinitions.iterator();
            while (iterator.hasNext()) {
                keySequenceBindingDefinition = (KeySequenceBindingDefinition)iterator.next();
                KeySequenceBindingNode.add(this.tree, keySequenceBindingDefinition.getKeySequence(), keySequenceBindingDefinition.getContextId(), keySequenceBindingDefinition.getKeyConfigurationId(), 0, keySequenceBindingDefinition.getPlatform(), keySequenceBindingDefinition.getLocale(), keySequenceBindingDefinition.getCommandId());
            }
            categoryNames = new ArrayList<K>(this.categoryIdsByUniqueName.keySet());
            Collections.sort(categoryNames, Collator.getInstance());
            if (this.commandIdsByCategoryId.containsKey(null)) {
                categoryNames.add(0, Util.translateString(KeysPreferencePage.RESOURCE_BUNDLE, "other"));
            }
            this.comboCategory.setItems(categoryNames.toArray(new String[categoryNames.size()]));
            this.comboCategory.clearSelection();
            this.comboCategory.deselectAll();
            if (this.commandIdsByCategoryId.containsKey(null) || !categoryNames.isEmpty()) {
                this.comboCategory.select(0);
            }
            keyConfigurationNames = new ArrayList<K>(this.keyConfigurationIdsByUniqueName.keySet());
            Collections.sort(keyConfigurationNames, Collator.getInstance());
            this.comboKeyConfiguration.setItems(keyConfigurationNames.toArray(new String[keyConfigurationNames.size()]));
            this.setKeyConfigurationId(activeKeyConfigurationId);
            this.update();
        }
        super.setVisible(visible);
    }

    private void update() {
        boolean buttonsEnabled;
        this.updateViewTab();
        this.setCommandsForCategory();
        this.setContextsForCommand();
        String keyConfigurationId = this.getKeyConfigurationId();
        KeySequence keySequence = this.getKeySequence();
        String[] activeKeyConfigurationIds = MutableCommandManager.extend(this.commandManager.getKeyConfigurationIds(keyConfigurationId));
        String[] activeLocales = MutableCommandManager.extend(MutableCommandManager.getPath(this.commandManager.getActiveLocale(), "_"));
        String[] activePlatforms = MutableCommandManager.extend(MutableCommandManager.getPath(this.commandManager.getActivePlatform(), "_"));
        KeySequenceBindingNode.solve(this.tree, activeKeyConfigurationIds, activePlatforms, activeLocales);
        this.assignmentsByContextIdByKeySequence = KeySequenceBindingNode.getAssignmentsByContextIdKeySequence(this.tree, KeySequence.getInstance());
        this.setAssignmentsForKeySequence();
        this.setAssignmentsForCommand();
        String commandId = this.getCommandId();
        String contextId = this.getContextId();
        this.selectAssignmentForKeySequence(contextId);
        this.selectAssignmentForCommand(contextId);
        this.updateLabelKeyConfigurationExtends();
        this.updateLabelContextExtends();
        this.labelAssignmentsForKeySequence.setEnabled(keySequence != null && !keySequence.getKeyStrokes().isEmpty());
        this.tableAssignmentsForKeySequence.setEnabled(keySequence != null && !keySequence.getKeyStrokes().isEmpty());
        this.labelAssignmentsForCommand.setEnabled(commandId != null);
        this.tableAssignmentsForCommand.setEnabled(commandId != null);
        boolean buttonAddEnabled = buttonsEnabled = commandId != null && keySequence != null && !keySequence.getKeyStrokes().isEmpty();
        boolean buttonRemoveEnabled = buttonsEnabled;
        boolean buttonRestoreEnabled = buttonsEnabled;
        this.buttonAdd.setEnabled(buttonAddEnabled);
        this.buttonRemove.setEnabled(buttonRemoveEnabled);
        this.buttonRestore.setEnabled(buttonRestoreEnabled);
    }

    private void updateLabelContextExtends() {
        IContext context;
        String contextId = this.getContextId();
        if (contextId != null && (context = this.contextManager.getContext(this.getContextId())).isDefined()) {
            try {
                String name;
                String parentId = context.getParentId();
                if (parentId != null && (name = (String)this.contextUniqueNamesById.get(parentId)) != null) {
                    this.labelContextExtends.setText(MessageFormat.format(Util.translateString(RESOURCE_BUNDLE, "extends"), name));
                    return;
                }
            }
            catch (NotDefinedException notDefinedException) {}
        }
        this.labelContextExtends.setText("");
    }

    private void updateLabelKeyConfigurationExtends() {
        String keyConfigurationId = this.getKeyConfigurationId();
        if (keyConfigurationId != null) {
            IKeyConfiguration keyConfiguration = this.commandManager.getKeyConfiguration(keyConfigurationId);
            try {
                String name = (String)this.keyConfigurationUniqueNamesById.get(keyConfiguration.getParentId());
                if (name != null) {
                    this.labelKeyConfigurationExtends.setText(MessageFormat.format(Util.translateString(RESOURCE_BUNDLE, "extends"), name));
                    return;
                }
            }
            catch (org.eclipse.ui.commands.NotDefinedException notDefinedException) {}
        }
        this.labelKeyConfigurationExtends.setText("");
    }

    private final void updateViewTab() {
        this.tableKeyBindings.removeAll();
        ArrayList bindings = new ArrayList(this.commandManager.getKeyBindings());
        Collections.sort(bindings, new Comparator(){

            public final int compare(Object object1, Object object2) {
                KeySequenceBindingDefinition binding1 = (KeySequenceBindingDefinition)object1;
                KeySequenceBindingDefinition binding2 = (KeySequenceBindingDefinition)object2;
                String commandId1 = binding1.getCommandId();
                String categoryName1 = "";
                String commandName1 = "";
                if (commandId1 != null) {
                    ICommand command = KeysPreferencePage.this.commandManager.getCommand(commandId1);
                    try {
                        commandName1 = command.getName();
                        String categoryId = command.getCategoryId();
                        if (categoryId != null) {
                            categoryName1 = KeysPreferencePage.this.commandManager.getCategory(categoryId).getName();
                        }
                    }
                    catch (org.eclipse.ui.commands.NotDefinedException notDefinedException) {}
                }
                String keySequence1 = binding1.getKeySequence().format();
                String contextId1 = binding1.getContextId();
                String contextName1 = "";
                if (contextId1 != null) {
                    IContext context = KeysPreferencePage.this.contextManager.getContext(contextId1);
                    try {
                        contextName1 = context.getName();
                    }
                    catch (NotDefinedException notDefinedException) {}
                }
                String commandId2 = binding2.getCommandId();
                String categoryName2 = "";
                String commandName2 = "";
                if (commandId2 != null) {
                    ICommand command = KeysPreferencePage.this.commandManager.getCommand(commandId2);
                    try {
                        commandName2 = command.getName();
                        String categoryId = command.getCategoryId();
                        if (categoryId != null) {
                            categoryName2 = KeysPreferencePage.this.commandManager.getCategory(categoryId).getName();
                        }
                    }
                    catch (org.eclipse.ui.commands.NotDefinedException notDefinedException) {}
                }
                String keySequence2 = binding2.getKeySequence().format();
                String contextId2 = binding2.getContextId();
                String contextName2 = "";
                if (contextId2 != null) {
                    IContext context = KeysPreferencePage.this.contextManager.getContext(contextId2);
                    try {
                        contextName2 = context.getName();
                    }
                    catch (NotDefinedException notDefinedException) {}
                }
                int compare = 0;
                int i = 0;
                while (i < KeysPreferencePage.this.sortOrder.length) {
                    switch (KeysPreferencePage.this.sortOrder[i]) {
                        case 0: {
                            compare = Util.compare((Comparable)((Object)categoryName1), (Comparable)((Object)categoryName2));
                            if (compare == 0) break;
                            return compare;
                        }
                        case 1: {
                            compare = Util.compare((Comparable)((Object)commandName1), (Comparable)((Object)commandName2));
                            if (compare == 0) break;
                            return compare;
                        }
                        case 2: {
                            compare = Util.compare((Comparable)((Object)keySequence1), (Comparable)((Object)keySequence2));
                            if (compare == 0) break;
                            return compare;
                        }
                        case 3: {
                            compare = Util.compare((Comparable)((Object)contextName1), (Comparable)((Object)contextName2));
                            if (compare == 0) break;
                            return compare;
                        }
                        default: {
                            throw new Error("Programmer error: added another sort column without modifying the comparator.");
                        }
                    }
                    ++i;
                }
                return compare;
            }

            public final boolean equals(Object object) {
                return super.equals(object);
            }
        });
        Iterator keyBindingItr = bindings.iterator();
        while (keyBindingItr.hasNext()) {
            KeySequenceBindingDefinition keyBinding = (KeySequenceBindingDefinition)keyBindingItr.next();
            String commandId = keyBinding.getCommandId();
            String commandName = "";
            String categoryName = "";
            if (commandId != null) {
                ICommand command = this.commandManager.getCommand(commandId);
                try {
                    commandName = command.getName();
                    String categoryId = command.getCategoryId();
                    if (categoryId != null) {
                        categoryName = this.commandManager.getCategory(categoryId).getName();
                    }
                }
                catch (org.eclipse.ui.commands.NotDefinedException notDefinedException) {}
            }
            if (commandName == null || commandName.length() == 0) continue;
            String contextId = keyBinding.getContextId();
            String contextName = "";
            if (contextId != null) {
                IContext context = this.contextManager.getContext(contextId);
                try {
                    contextName = context.getName();
                }
                catch (NotDefinedException notDefinedException) {}
            }
            TableItem item = new TableItem(this.tableKeyBindings, 0);
            item.setText(0, categoryName);
            item.setText(1, commandName);
            item.setText(2, keyBinding.getKeySequence().format());
            item.setText(3, contextName);
        }
        int i = 0;
        while (i < this.tableKeyBindings.getColumnCount()) {
            this.tableKeyBindings.getColumn(i).pack();
            ++i;
        }
    }

    private static final class CommandAssignment
    implements Comparable {
        private KeySequenceBindingNode.Assignment assignment;
        private String contextId;
        private KeySequence keySequence;

        CommandAssignment() {
        }

        public int compareTo(Object object) {
            CommandAssignment castedObject = (CommandAssignment)object;
            int compareTo = Util.compare((Comparable)((Object)this.contextId), (Comparable)((Object)castedObject.contextId));
            if (compareTo == 0 && (compareTo = Util.compare(this.keySequence, castedObject.keySequence)) == 0) {
                compareTo = Util.compare(this.assignment, castedObject.assignment);
            }
            return compareTo;
        }

        public boolean equals(Object object) {
            if (!(object instanceof CommandAssignment)) {
                return false;
            }
            CommandAssignment castedObject = (CommandAssignment)object;
            boolean equals = true;
            equals &= Util.equals(this.assignment, castedObject.assignment);
            equals &= Util.equals(this.contextId, castedObject.contextId);
            return equals &= Util.equals(this.keySequence, castedObject.keySequence);
        }
    }

    private static final class KeySequenceAssignment
    implements Comparable {
        private KeySequenceBindingNode.Assignment assignment;
        private String contextId;

        KeySequenceAssignment() {
        }

        public int compareTo(Object object) {
            KeySequenceAssignment castedObject = (KeySequenceAssignment)object;
            int compareTo = Util.compare((Comparable)((Object)this.contextId), (Comparable)((Object)castedObject.contextId));
            if (compareTo == 0) {
                compareTo = Util.compare(this.assignment, castedObject.assignment);
            }
            return compareTo;
        }

        public boolean equals(Object object) {
            if (!(object instanceof CommandAssignment)) {
                return false;
            }
            KeySequenceAssignment castedObject = (KeySequenceAssignment)object;
            boolean equals = true;
            equals &= Util.equals(this.assignment, castedObject.assignment);
            return equals &= Util.equals(this.contextId, castedObject.contextId);
        }
    }

    private class SortOrderSelectionListener
    extends SelectionAdapter {
        private final int columnSelected;

        SortOrderSelectionListener(int columnSelected) {
            this.columnSelected = columnSelected;
        }

        public void widgetSelected(SelectionEvent e) {
            int oldSortIndex = KeysPreferencePage.this.sortOrder[0];
            TableColumn oldSortColumn = KeysPreferencePage.this.tableKeyBindings.getColumn(oldSortIndex);
            oldSortColumn.setText(UNSORTED_COLUMN_NAMES[oldSortIndex]);
            TableColumn newSortColumn = KeysPreferencePage.this.tableKeyBindings.getColumn(this.columnSelected);
            newSortColumn.setText(SORTED_COLUMN_NAMES[this.columnSelected]);
            boolean columnPlaced = false;
            boolean enoughRoom = false;
            int bumpedColumn = -1;
            int i = 0;
            while (i < KeysPreferencePage.this.sortOrder.length) {
                if (KeysPreferencePage.this.sortOrder[i] == this.columnSelected) {
                    enoughRoom = true;
                    if (bumpedColumn != -1) {
                        ((KeysPreferencePage)KeysPreferencePage.this).sortOrder[i] = bumpedColumn;
                        break;
                    }
                    columnPlaced = true;
                    break;
                }
                if (columnPlaced) {
                    int temp = KeysPreferencePage.this.sortOrder[i];
                    ((KeysPreferencePage)KeysPreferencePage.this).sortOrder[i] = bumpedColumn;
                    bumpedColumn = temp;
                } else {
                    bumpedColumn = KeysPreferencePage.this.sortOrder[i];
                    ((KeysPreferencePage)KeysPreferencePage.this).sortOrder[i] = this.columnSelected;
                    columnPlaced = true;
                }
                ++i;
            }
            if (!enoughRoom) {
                int[] newSortOrder = new int[KeysPreferencePage.this.sortOrder.length + 1];
                System.arraycopy(KeysPreferencePage.this.sortOrder, 0, newSortOrder, 0, KeysPreferencePage.this.sortOrder.length);
                newSortOrder[((KeysPreferencePage)KeysPreferencePage.this).sortOrder.length] = bumpedColumn;
                KeysPreferencePage.this.sortOrder = newSortOrder;
            }
            KeysPreferencePage.this.updateViewTab();
        }
    }
}

