/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.registry.PerspectiveDescriptor;
import org.eclipse.ui.internal.registry.PerspectiveRegistry;
import org.eclipse.ui.internal.util.PrefUtil;
import org.eclipse.ui.internal.util.Util;

public class PerspectivesPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private IWorkbench workbench;
    private PerspectiveRegistry perspectiveRegistry;
    private ArrayList perspectives;
    private String defaultPerspectiveId;
    private ArrayList perspToDelete = new ArrayList();
    private ArrayList perspToRevert = new ArrayList();
    private List list;
    private Button revertButton;
    private Button deleteButton;
    private Button setDefaultButton;
    private Button openSameWindowButton;
    private Button openNewWindowButton;
    private int openPerspMode;
    private int openViewMode;
    private Button openEmbedButton;
    private Button openFastButton;
    private final String OVM_TITLE = WorkbenchMessages.getString("OpenViewMode.title");
    private final String OVM_EMBED = WorkbenchMessages.getString("OpenViewMode.embed");
    private final String OVM_FAST = WorkbenchMessages.getString("OpenViewMode.fast");
    private final String OPM_TITLE = WorkbenchMessages.getString("OpenPerspectiveMode.optionsTitle");
    private final String OPM_SAME_WINDOW = WorkbenchMessages.getString("OpenPerspectiveMode.sameWindow");
    private final String OPM_NEW_WINDOW = WorkbenchMessages.getString("OpenPerspectiveMode.newWindow");
    private Comparator comparator = new Comparator(){
        private Collator collator = Collator.getInstance();

        public int compare(Object ob1, Object ob2) {
            IPerspectiveDescriptor d1 = (IPerspectiveDescriptor)ob1;
            IPerspectiveDescriptor d2 = (IPerspectiveDescriptor)ob2;
            return this.collator.compare(d1.getLabel(), d2.getLabel());
        }
    };

    protected Control createContents(Composite parent) {
        WorkbenchHelp.setHelp((Control)parent, "org.eclipse.ui.perspectives_preference_page_context");
        Composite composite = this.createComposite(parent);
        this.createOpenPerspButtonGroup(composite);
        this.createOpenViewButtonGroup(composite);
        this.createCustomizePerspective(composite);
        return composite;
    }

    protected Composite createComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData data = new GridData(1808);
        composite.setLayoutData((Object)data);
        composite.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 10;
        composite.setLayout((Layout)layout);
        return composite;
    }

    protected void createOpenPerspButtonGroup(Composite composite) {
        Font font = composite.getFont();
        Group buttonComposite = new Group(composite, 16384);
        buttonComposite.setText(this.OPM_TITLE);
        buttonComposite.setLayoutData((Object)new GridData(768));
        buttonComposite.setFont(composite.getFont());
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        buttonComposite.setLayout((Layout)layout);
        this.openSameWindowButton = new Button((Composite)buttonComposite, 16);
        this.openSameWindowButton.setText(this.OPM_SAME_WINDOW);
        this.openSameWindowButton.setSelection(this.openPerspMode == 0);
        this.openSameWindowButton.setFont(font);
        this.openSameWindowButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PerspectivesPreferencePage.this.openPerspMode = 0;
            }
        });
        this.openNewWindowButton = new Button((Composite)buttonComposite, 16);
        this.openNewWindowButton.setText(this.OPM_NEW_WINDOW);
        this.openNewWindowButton.setSelection(2 == this.openPerspMode);
        this.openNewWindowButton.setFont(font);
        this.openNewWindowButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PerspectivesPreferencePage.this.openPerspMode = 2;
            }
        });
    }

    protected void createOpenViewButtonGroup(Composite composite) {
        Font font = composite.getFont();
        Group buttonComposite = new Group(composite, 16384);
        buttonComposite.setText(this.OVM_TITLE);
        buttonComposite.setLayoutData((Object)new GridData(768));
        buttonComposite.setFont(composite.getFont());
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        buttonComposite.setLayout((Layout)layout);
        this.openEmbedButton = new Button((Composite)buttonComposite, 16);
        this.openEmbedButton.setText(this.OVM_EMBED);
        this.openEmbedButton.setSelection(this.openViewMode == 0);
        this.openEmbedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PerspectivesPreferencePage.this.openViewMode = 0;
            }
        });
        this.openEmbedButton.setFont(font);
        if (this.openViewMode == 2) {
            this.openViewMode = 1;
        }
        this.openFastButton = new Button((Composite)buttonComposite, 16);
        this.openFastButton.setText(this.OVM_FAST);
        this.openFastButton.setSelection(this.openViewMode == 1);
        this.openFastButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PerspectivesPreferencePage.this.openViewMode = 1;
            }
        });
        this.openFastButton.setFont(font);
    }

    protected Composite createCustomizePerspective(Composite parent) {
        Font font = parent.getFont();
        Composite perspectivesComponent = new Composite(parent, 0);
        perspectivesComponent.setLayoutData((Object)new GridData(1808));
        perspectivesComponent.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        perspectivesComponent.setLayout((Layout)layout);
        Label label = new Label(perspectivesComponent, 16384);
        label.setText(WorkbenchMessages.getString("PerspectivesPreference.available"));
        GridData data = new GridData();
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        label.setFont(font);
        this.list = new List(perspectivesComponent, 2816);
        this.list.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PerspectivesPreferencePage.this.updateButtons();
            }
        });
        this.list.setFont(font);
        data = new GridData(1808);
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        this.list.setLayoutData((Object)data);
        IPerspectiveDescriptor[] persps = this.perspectiveRegistry.getPerspectives();
        this.perspectives = new ArrayList(persps.length);
        int i = 0;
        while (i < persps.length) {
            this.perspectives.add(i, persps[i]);
            ++i;
        }
        Collections.sort(this.perspectives, this.comparator);
        this.defaultPerspectiveId = this.perspectiveRegistry.getDefaultPerspective();
        this.updateList();
        Composite buttonBar = (Composite)this.createVerticalButtonBar(perspectivesComponent);
        data = new GridData(1040);
        buttonBar.setLayoutData((Object)data);
        return perspectivesComponent;
    }

    protected Button createVerticalButton(Composite parent, String label, boolean defaultButton) {
        Shell shell;
        Button button = new Button(parent, 8);
        button.setText(label);
        GridData data = this.setButtonLayoutData(button);
        data.horizontalAlignment = 4;
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                PerspectivesPreferencePage.this.verticalButtonPressed(event.widget);
            }
        });
        button.setToolTipText(label);
        if (defaultButton && (shell = parent.getShell()) != null) {
            shell.setDefaultButton(button);
        }
        button.setFont(parent.getFont());
        return button;
    }

    protected Control createVerticalButtonBar(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth = 5;
        layout.marginHeight = 0;
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        composite.setFont(parent.getFont());
        this.setDefaultButton = this.createVerticalButton(composite, WorkbenchMessages.getString("PerspectivesPreference.MakeDefault"), false);
        this.setDefaultButton.setToolTipText(WorkbenchMessages.getString("PerspectivesPreference.MakeDefaultTip"));
        this.revertButton = this.createVerticalButton(composite, WorkbenchMessages.getString("PerspectivesPreference.Reset"), false);
        this.revertButton.setToolTipText(WorkbenchMessages.getString("PerspectivesPreference.ResetTip"));
        this.deleteButton = this.createVerticalButton(composite, WorkbenchMessages.getString("PerspectivesPreference.Delete"), false);
        this.deleteButton.setToolTipText(WorkbenchMessages.getString("PerspectivesPreference.DeleteTip"));
        this.updateButtons();
        return composite;
    }

    public void init(IWorkbench aWorkbench) {
        this.workbench = aWorkbench;
        this.perspectiveRegistry = (PerspectiveRegistry)this.workbench.getPerspectiveRegistry();
        IPreferenceStore store = WorkbenchPlugin.getDefault().getPreferenceStore();
        this.setPreferenceStore(store);
        this.openViewMode = store.getInt("OPEN_VIEW_MODE");
        this.openPerspMode = store.getInt("OPEN_PERSPECTIVE_MODE");
    }

    protected void performDefaults() {
        IPreferenceStore store = WorkbenchPlugin.getDefault().getPreferenceStore();
        this.openViewMode = store.getDefaultInt("OPEN_VIEW_MODE");
        if (this.openViewMode == 2) {
            this.openViewMode = 1;
        }
        this.openEmbedButton.setSelection(this.openViewMode == 0);
        this.openFastButton.setSelection(this.openViewMode == 1);
        this.openPerspMode = store.getDefaultInt("OPEN_PERSPECTIVE_MODE");
        this.openSameWindowButton.setSelection(this.openPerspMode == 0);
        this.openNewWindowButton.setSelection(2 == this.openPerspMode);
        String currentDefault = this.perspectiveRegistry.getDefaultPerspective();
        int index = this.indexOf(currentDefault);
        if (index >= 0) {
            this.defaultPerspectiveId = currentDefault;
            this.updateList();
            this.list.setSelection(index);
        }
        String newDefault = PrefUtil.getAPIPreferenceStore().getDefaultString("defaultPerspectiveId");
        IPerspectiveDescriptor desc = null;
        if (newDefault != null) {
            desc = this.workbench.getPerspectiveRegistry().findPerspectiveWithId(newDefault);
        }
        if (desc == null) {
            newDefault = this.workbench.getPerspectiveRegistry().getDefaultPerspective();
        }
        this.defaultPerspectiveId = newDefault;
        this.updateList();
    }

    private int indexOf(String perspectiveId) {
        if (perspectiveId == null) {
            return -1;
        }
        PerspectiveDescriptor[] descriptors = new PerspectiveDescriptor[this.perspectives.size()];
        this.perspectives.toArray(descriptors);
        int i = 0;
        while (i < descriptors.length) {
            PerspectiveDescriptor descriptor = descriptors[i];
            if (descriptor.getId().equals(perspectiveId)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private boolean deletePerspectives() {
        IWorkbenchWindow[] windows = this.workbench.getWorkbenchWindows();
        int i = 0;
        while (i < windows.length) {
            IWorkbenchPage[] pages = windows[i].getPages();
            int j = 0;
            while (j < pages.length) {
                WorkbenchPage page = (WorkbenchPage)pages[j];
                int k = 0;
                while (k < this.perspToDelete.size()) {
                    IPerspectiveDescriptor desc = (IPerspectiveDescriptor)this.perspToDelete.get(k);
                    if (page.findPerspective(desc) != null) {
                        MessageDialog.openInformation((Shell)this.getShell(), (String)WorkbenchMessages.getString("PerspectivesPreference.cannotdelete.title"), (String)WorkbenchMessages.format("PerspectivesPreference.cannotdelete.message", new String[]{desc.getLabel()}));
                        return false;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        this.perspectiveRegistry.deletePerspectives(this.perspToDelete);
        return true;
    }

    public boolean performOk() {
        if (!Util.equals(this.defaultPerspectiveId, this.perspectiveRegistry.getDefaultPerspective())) {
            this.perspectiveRegistry.setDefaultPerspective(this.defaultPerspectiveId);
        }
        if (!this.deletePerspectives()) {
            return false;
        }
        this.perspectiveRegistry.revertPerspectives(this.perspToRevert);
        IPreferenceStore store = this.getPreferenceStore();
        store.setValue("OPEN_VIEW_MODE", this.openViewMode);
        store.setValue("OPEN_PERSPECTIVE_MODE", this.openPerspMode);
        PrefUtil.savePrefs();
        return true;
    }

    protected void updateButtons() {
        int index = this.list.getSelectionIndex();
        PerspectiveDescriptor desc = null;
        if (index > -1) {
            desc = (PerspectiveDescriptor)this.perspectives.get(index);
        }
        if (desc != null) {
            this.revertButton.setEnabled(desc.isPredefined() && desc.hasCustomDefinition() && !this.perspToRevert.contains(desc));
            this.deleteButton.setEnabled(!desc.isPredefined());
            this.setDefaultButton.setEnabled(true);
        } else {
            this.revertButton.setEnabled(false);
            this.deleteButton.setEnabled(false);
            this.setDefaultButton.setEnabled(false);
        }
    }

    protected void updateList() {
        this.list.removeAll();
        int i = 0;
        while (i < this.perspectives.size()) {
            IPerspectiveDescriptor desc = (IPerspectiveDescriptor)this.perspectives.get(i);
            String label = desc.getLabel();
            if (desc.getId().equals(this.defaultPerspectiveId)) {
                label = WorkbenchMessages.format("PerspectivesPreference.defaultLabel", new Object[]{label});
            }
            this.list.add(label, i);
            ++i;
        }
    }

    protected void verticalButtonPressed(Widget button) {
        int index = this.list.getSelectionIndex();
        PerspectiveDescriptor desc = null;
        if (index <= -1) {
            return;
        }
        desc = (PerspectiveDescriptor)this.perspectives.get(index);
        if (button == this.revertButton) {
            if (desc.isPredefined() && !this.perspToRevert.contains(desc)) {
                this.perspToRevert.add(desc);
            }
        } else if (button == this.deleteButton) {
            if (!desc.isPredefined() && !this.perspToDelete.contains(desc)) {
                this.perspToDelete.add(desc);
                this.perspToRevert.remove(desc);
                this.perspectives.remove(desc);
                this.updateList();
            }
        } else if (button == this.setDefaultButton) {
            this.defaultPerspectiveId = desc.getId();
            this.updateList();
            this.list.setSelection(index);
        }
        this.updateButtons();
    }
}

