/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import org.eclipse.jface.dialogs.DialogMessageArea;
import org.eclipse.jface.dialogs.IMessageProvider;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.IPreferencePageContainer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.internal.dialogs.FilteredPreferenceDialog;

public class PreferenceAreaEntry
implements IPreferencePageContainer {
    private IPreferenceNode node;
    private FilteredPreferenceDialog dialog;
    private Composite titleArea;
    private Label titleImage;
    private DialogMessageArea messageArea;
    private boolean showingError = true;
    private final String ellipsis = "...";

    public PreferenceAreaEntry(IPreferenceNode pageNode, FilteredPreferenceDialog preferenceDialog) {
        this.node = pageNode;
        this.dialog = preferenceDialog;
    }

    public IPreferenceStore getPreferenceStore() {
        return this.dialog.getPreferenceStore();
    }

    public void updateButtons() {
        this.dialog.updateButtons();
    }

    public void updateMessage() {
        String errorMessage;
        IPreferencePage currentPage = this.node.getPage();
        String message = currentPage.getMessage();
        int messageType = 0;
        if (message != null && currentPage instanceof IMessageProvider) {
            messageType = ((IMessageProvider)currentPage).getMessageType();
        }
        if ((errorMessage = currentPage.getErrorMessage()) != null) {
            message = errorMessage;
            messageType = 3;
            if (!this.showingError) {
                this.showingError = true;
                this.titleImage.setImage(null);
                this.titleImage.setBackground(JFaceColors.getErrorBackground((Display)this.titleImage.getDisplay()));
                this.titleImage.setSize(0, 0);
                this.titleImage.getParent().layout();
            }
        } else if (this.showingError) {
            this.showingError = false;
            this.titleImage.setImage(JFaceResources.getImage((String)"preference_dialog_title_image"));
            this.titleImage.computeSize(0, 0);
            this.titleImage.getParent().layout();
        }
        this.messageArea.updateText(this.getShortenedString(message), messageType);
    }

    public void updateTitle() {
        IPreferencePage currentPage = this.node.getPage();
        this.messageArea.showTitle(currentPage.getTitle(), currentPage.getImage());
    }

    public void createContents(Composite control) {
        Composite mainContainer = new Composite(control, 2048);
        GridLayout layout = new GridLayout();
        mainContainer.setLayout((Layout)layout);
        mainContainer.setLayoutData((Object)new GridData(768));
        this.createTitleArea(mainContainer);
        this.titleArea.setLayoutData((Object)new GridData(768));
        this.node.createPage();
        this.node.getPage().createControl(mainContainer);
        this.node.getPage().getControl().setLayoutData((Object)new GridData(768));
        mainContainer.layout();
        this.updateTitle();
        control.pack();
    }

    private void createTitleArea(Composite parent) {
        int margins = 2;
        this.titleArea = new Composite(parent, 0);
        FormLayout layout = new FormLayout();
        layout.marginHeight = margins;
        layout.marginWidth = margins;
        this.titleArea.setLayout((Layout)layout);
        Display display = parent.getDisplay();
        Color background = JFaceColors.getBannerBackground((Display)display);
        GridData layoutData = new GridData(768);
        layoutData.heightHint = JFaceResources.getImage((String)"preference_dialog_title_image").getBounds().height + margins * 3;
        this.titleArea.setLayoutData((Object)layoutData);
        this.titleArea.setBackground(background);
        this.titleArea.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                e.gc.setForeground(PreferenceAreaEntry.this.titleArea.getDisplay().getSystemColor(18));
                Rectangle bounds = PreferenceAreaEntry.this.titleArea.getClientArea();
                bounds.height -= 2;
                --bounds.width;
                e.gc.drawRectangle(bounds);
            }
        });
        this.messageArea = new DialogMessageArea();
        this.messageArea.createContents(this.titleArea);
        this.titleArea.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                PreferenceAreaEntry.this.updateMessage();
            }
        });
        final IPropertyChangeListener fontListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("org.eclipse.jface.bannerfont".equals(event.getProperty())) {
                    PreferenceAreaEntry.this.updateMessage();
                }
            }
        };
        this.titleArea.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                JFaceResources.getFontRegistry().removeListener(fontListener);
            }
        });
        JFaceResources.getFontRegistry().addListener(fontListener);
        this.titleImage = new Label(this.titleArea, 16384);
        this.titleImage.setBackground(background);
        this.titleImage.setImage(JFaceResources.getImage((String)"preference_dialog_title_image"));
        FormData imageData = new FormData();
        imageData.right = new FormAttachment(100);
        imageData.top = new FormAttachment(0);
        imageData.bottom = new FormAttachment(100);
        this.titleImage.setLayoutData((Object)imageData);
        this.messageArea.setTitleLayoutData((Object)this.createMessageAreaData());
        this.messageArea.setMessageLayoutData((Object)this.createMessageAreaData());
    }

    private FormData createMessageAreaData() {
        FormData messageData = new FormData();
        messageData.top = new FormAttachment(0);
        messageData.bottom = new FormAttachment((Control)this.titleImage, 0, 1024);
        messageData.right = new FormAttachment((Control)this.titleImage, 0);
        messageData.left = new FormAttachment(0);
        return messageData;
    }

    private String getShortenedString(String textValue) {
        int pivot;
        if (textValue == null) {
            return null;
        }
        Display display = this.titleArea.getDisplay();
        GC gc = new GC((Drawable)display);
        int maxWidth = this.titleArea.getBounds().width - 28;
        if (gc.textExtent((String)textValue).x < maxWidth) {
            gc.dispose();
            return textValue;
        }
        int length = textValue.length();
        int ellipsisWidth = gc.textExtent((String)"...").x;
        int start = pivot = length / 2;
        int end = pivot + 1;
        while (start >= 0 && end < length) {
            String s1 = textValue.substring(0, start);
            String s2 = textValue.substring(end, length);
            int l1 = gc.textExtent((String)s1).x;
            int l2 = gc.textExtent((String)s2).x;
            if (l1 + ellipsisWidth + l2 < maxWidth) {
                gc.dispose();
                return String.valueOf(s1) + "..." + s2;
            }
            --start;
            ++end;
        }
        gc.dispose();
        return textValue;
    }
}

