/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.dialogs.AbstractPreferenceImportExportPage;

class PreferenceImportExportSettingsSelectionPage
extends AbstractPreferenceImportExportPage {
    private static final String EXPORT_MESSAGE = WorkbenchMessages.getString("ImportExportPages.exportSettingsSelect");
    private static final String IMPORT_MESSAGE = WorkbenchMessages.getString("ImportExportPages.importSettingsSelect");
    private static final String NAME = "org.eclipse.ui.preferences.importExportSettingsSelectionPage";
    private Table settingsTable;

    PreferenceImportExportSettingsSelectionPage(boolean exportWizard) {
        super(NAME, exportWizard);
    }

    boolean canFinish() {
        return true;
    }

    public boolean canFlipToNextPage() {
        return false;
    }

    public void createControl(Composite parent) {
        Font parentFont = parent.getFont();
        Composite page = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        page.setLayout((Layout)layout);
        this.initializeDialogUnits((Control)page);
        if (this.export) {
            this.setTitle(AbstractPreferenceImportExportPage.EXPORT_TITLE);
            this.setMessage(EXPORT_MESSAGE);
            this.setImageDescriptor(AbstractPreferenceImportExportPage.getImageDescriptor("wizban/export_wiz.gif"));
        } else {
            this.setTitle(AbstractPreferenceImportExportPage.IMPORT_TITLE);
            this.setMessage(IMPORT_MESSAGE);
            this.setImageDescriptor(AbstractPreferenceImportExportPage.getImageDescriptor("wizban/import_wiz.gif"));
        }
        this.settingsTable = new Table(page, 2080);
        this.settingsTable.setFont(parentFont);
        GridData layoutData = new GridData(1808);
        layoutData.verticalSpan = 3;
        this.settingsTable.setLayoutData((Object)layoutData);
        this.settingsTable.setLinesVisible(true);
        this.settingsTable.setHeaderVisible(true);
        TableColumn columnChecked = new TableColumn(this.settingsTable, 16384, 0);
        TableColumn columnName = new TableColumn(this.settingsTable, 16384, 1);
        TableColumn columnValue = new TableColumn(this.settingsTable, 16384, 2);
        int i = 0;
        while (i < 50) {
            TableItem item = new TableItem(this.settingsTable, 0);
            item.setText(new String[]{"", "org.eclipse.sample.preference", "Sample value (ignore)"});
            item.setChecked(true);
            ++i;
        }
        columnName.setText(WorkbenchMessages.getString("ImportExportPages.name"));
        columnValue.setText(WorkbenchMessages.getString("ImportExportPages.value"));
        columnChecked.pack();
        columnName.pack();
        columnValue.pack();
        Button selectAllButton = new Button(page, 8);
        selectAllButton.setFont(parentFont);
        layoutData = new GridData();
        selectAllButton.setText(WorkbenchMessages.getString("ImportExportPages.selectAll"));
        layoutData.widthHint = this.computePushButtonWidthHint(selectAllButton);
        layoutData.verticalAlignment = 1;
        selectAllButton.setLayoutData((Object)layoutData);
        selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public final void widgetSelected(SelectionEvent event) {
                PreferenceImportExportSettingsSelectionPage.this.setCheckAll(true);
            }
        });
        Button deselectAllButton = new Button(page, 8);
        deselectAllButton.setFont(parentFont);
        layoutData = new GridData();
        deselectAllButton.setText(WorkbenchMessages.getString("ImportExportPages.deselectAll"));
        layoutData.widthHint = this.computePushButtonWidthHint(deselectAllButton);
        layoutData.verticalAlignment = 1;
        deselectAllButton.setLayoutData((Object)layoutData);
        deselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public final void widgetSelected(SelectionEvent event) {
                PreferenceImportExportSettingsSelectionPage.this.setCheckAll(false);
            }
        });
        Button invertSelectionButton = new Button(page, 8);
        invertSelectionButton.setFont(parentFont);
        layoutData = new GridData();
        invertSelectionButton.setText(WorkbenchMessages.getString("ImportExportPages.invertSelection"));
        layoutData.widthHint = this.computePushButtonWidthHint(invertSelectionButton);
        layoutData.verticalAlignment = 1;
        invertSelectionButton.setLayoutData((Object)layoutData);
        invertSelectionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public final void widgetSelected(SelectionEvent event) {
                PreferenceImportExportSettingsSelectionPage.this.invertSelection();
            }
        });
        this.setControl((Control)page);
        this.init();
    }

    private void init() {
        this.setCheckAll(true);
    }

    private void invertSelection() {
        TableItem[] items = this.settingsTable.getItems();
        int i = 0;
        while (i < items.length) {
            TableItem item;
            item.setChecked(!(item = items[i]).getChecked());
            ++i;
        }
    }

    private void setCheckAll(boolean checked) {
        TableItem[] items = this.settingsTable.getItems();
        int i = 0;
        while (i < items.length) {
            items[i].setChecked(checked);
            ++i;
        }
    }

    boolean validate() {
        return true;
    }
}

