/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.security.InvalidParameterException;
import java.text.MessageFormat;
import java.util.Iterator;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.dialogs.LinkArea;
import org.eclipse.ui.internal.dialogs.WorkbenchPreferenceDialog;

public class PreferenceLinkArea
extends LinkArea {
    public PreferenceLinkArea(Composite parent, int style, String pageId, String message) {
        super(parent, style);
        IPreferenceNode node = this.getPreferenceNode(pageId);
        if (node == null) {
            throw new InvalidParameterException("Node not found");
        }
        this.setRunnable(this.getRunnable(node));
        new MessageFormat(message);
        String result = MessageFormat.format(message, node.getLabelText());
        this.setText(result);
    }

    private IRunnableContext getRunnable(final IPreferenceNode node) {
        return new IRunnableContext(){

            public void run(boolean fork, boolean cancelable, IRunnableWithProgress runnable) throws InterruptedException {
                WorkbenchPreferenceDialog.createDialogOn(node.getId());
            }
        };
    }

    private IPreferenceNode getPreferenceNode(String pageId) {
        Iterator iterator = PlatformUI.getWorkbench().getPreferenceManager().getElements(0).iterator();
        while (iterator.hasNext()) {
            IPreferenceNode next = (IPreferenceNode)iterator.next();
            if (!next.getId().equals(pageId)) continue;
            return next;
        }
        return null;
    }
}

