/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.keys;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.activities.IActivityManager;
import org.eclipse.ui.commands.CommandException;
import org.eclipse.ui.commands.ICommand;
import org.eclipse.ui.commands.ICommandManager;
import org.eclipse.ui.commands.IKeySequenceBinding;
import org.eclipse.ui.commands.NotDefinedException;
import org.eclipse.ui.contexts.IWorkbenchContextSupport;
import org.eclipse.ui.internal.commands.KeysPreferencePage;
import org.eclipse.ui.internal.dialogs.WorkbenchPreferenceDialog;
import org.eclipse.ui.internal.keys.KeyBindingState;
import org.eclipse.ui.internal.keys.WorkbenchKeyboard;
import org.eclipse.ui.internal.util.Util;
import org.eclipse.ui.keys.KeySequence;

final class KeyAssistDialog
extends Dialog {
    private static final ResourceBundle RESOURCE_BUNDLE;
    private final IActivityManager activityManager;
    private final ICommandManager commandManager;
    private String commandName = null;
    private final List commands = new ArrayList();
    private Table completionsTable = null;
    private final KeyBindingState keyBindingState;
    private String keySequence = null;
    private int previousWidth = -1;
    private final WorkbenchKeyboard workbenchKeyboard;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.internal.keys.KeyAssistDialog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        RESOURCE_BUNDLE = ResourceBundle.getBundle(clazz.getName());
    }

    KeyAssistDialog(IWorkbench workbench, WorkbenchKeyboard associatedKeyboard, KeyBindingState associatedState) {
        super(null);
        this.setShellStyle(8);
        this.setBlockOnOpen(false);
        this.activityManager = workbench.getActivitySupport().getActivityManager();
        this.commandManager = workbench.getCommandSupport().getCommandManager();
        this.keyBindingState = associatedState;
        this.workbenchKeyboard = associatedKeyboard;
    }

    final void clearRememberedState() {
        this.previousWidth = -1;
        this.commandName = null;
        this.keySequence = null;
    }

    public final boolean close() {
        return this.close(false);
    }

    public final boolean close(boolean rememberState) {
        Shell shell = this.getShell();
        if (rememberState) {
            if (shell != null && !shell.isDisposed()) {
                this.previousWidth = this.getShell().getSize().x;
            }
            if (this.completionsTable != null && !this.completionsTable.isDisposed()) {
                int selectedIndex = this.completionsTable.getSelectionIndex();
                if (selectedIndex != -1) {
                    TableItem selectedItem = this.completionsTable.getItem(selectedIndex);
                    this.commandName = selectedItem.getText(0);
                    this.keySequence = selectedItem.getText(1);
                } else {
                    this.commandName = "";
                    this.keySequence = "";
                }
            }
            this.completionsTable = null;
        }
        this.keyBindingState.reset();
        return super.close();
    }

    private final void configureLocation(Point size) {
        int yCoord;
        int xCoord;
        Shell shell = this.getShell();
        Display display = shell.getDisplay();
        Shell workbenchWindowShell = this.keyBindingState.getAssociatedWindow().getShell();
        if (workbenchWindowShell != null) {
            Rectangle workbenchWindowBounds = workbenchWindowShell.getBounds();
            xCoord = workbenchWindowBounds.x + workbenchWindowBounds.width - size.x - 10;
            yCoord = workbenchWindowBounds.y + workbenchWindowBounds.height - size.y - 10;
        } else {
            xCoord = 0;
            yCoord = 0;
        }
        Point location = new Point(xCoord, yCoord);
        Rectangle displayBounds = display.getClientArea();
        int displayRightEdge = displayBounds.x + displayBounds.width;
        if (location.x < displayBounds.x) {
            location.x = displayBounds.x;
        } else if (location.x + size.x > displayRightEdge) {
            location.x = displayRightEdge - size.x;
        }
        int displayBottomEdge = displayBounds.y + displayBounds.height;
        if (location.y < displayBounds.y) {
            location.y = displayBounds.y;
        } else if (location.y + size.y > displayBottomEdge) {
            location.y = displayBottomEdge - size.y;
        }
        shell.setLocation(location);
    }

    private final Point configureSize() {
        Shell workbenchWindowShell;
        Shell shell = this.getShell();
        shell.pack();
        Point size = shell.getSize();
        if (this.previousWidth != -1 && this.previousWidth > size.x) {
            size.x = this.previousWidth;
        }
        if ((workbenchWindowShell = this.keyBindingState.getAssociatedWindow().getShell()) != null) {
            Point workbenchWindowSize = workbenchWindowShell.getSize();
            int maxWidth = workbenchWindowSize.x * 2 / 5;
            int maxHeight = workbenchWindowSize.y / 2;
            if (size.x > maxWidth) {
                size.x = maxWidth;
            }
            if (size.y > maxHeight) {
                size.y = maxHeight;
            }
        }
        shell.setSize(size);
        return size;
    }

    protected Control createButtonBar(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(768));
        composite.setBackground(parent.getBackground());
        ICommand command = this.commandManager.getCommand("org.eclipse.ui.window.showKeyAssist");
        KeySequence keyBinding = null;
        if (command.isDefined()) {
            List keyBindings = command.getKeySequenceBindings();
            Iterator keyBindingItr = keyBindings.iterator();
            KeySequence currentState = this.keyBindingState.getCurrentSequence();
            int prefixSize = currentState.getKeyStrokes().size();
            while (keyBindingItr.hasNext()) {
                keyBinding = ((IKeySequenceBinding)keyBindingItr.next()).getKeySequence();
                if (prefixSize <= 0) break;
                if (keyBinding.startsWith(currentState, false)) {
                    ArrayList newKeyStrokes = new ArrayList(keyBinding.getKeyStrokes());
                    int i = 0;
                    while (i < prefixSize) {
                        newKeyStrokes.remove(0);
                        ++i;
                    }
                    keyBinding = KeySequence.getInstance(newKeyStrokes);
                    break;
                }
                keyBinding = null;
            }
        }
        if (keyBinding == null) {
            return composite;
        }
        Label text = new Label(composite, 0);
        text.setLayoutData((Object)new GridData(0x1000008, 0x1000000, true, false));
        text.setBackground(composite.getBackground());
        text.setText(MessageFormat.format(Util.translateString(RESOURCE_BUNDLE, "openPreferencePage"), keyBinding.format()));
        return composite;
    }

    protected final Control createContents(Composite parent) {
        Display display = parent.getDisplay();
        parent.setBackground(display.getSystemColor(2));
        GridLayout shellLayout = new GridLayout(1, false);
        shellLayout.marginHeight = 1;
        shellLayout.marginWidth = 1;
        parent.setLayout((Layout)shellLayout);
        this.registerListeners();
        this.registerShellType();
        Composite contents = new Composite(parent, 0);
        contents.setBackground(display.getSystemColor(29));
        GridLayout contentLayout = new GridLayout();
        contentLayout.marginHeight = 1;
        contentLayout.marginWidth = 1;
        contents.setLayout((Layout)contentLayout);
        contents.setLayoutData((Object)new GridData(1808));
        this.initializeDialogUnits((Control)contents);
        this.dialogArea = this.createDialogArea(contents);
        this.buttonBar = this.createButtonBar(contents);
        Dialog.applyDialogFont((Control)contents);
        return contents;
    }

    protected final Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout compositeLayout = new GridLayout();
        compositeLayout.marginHeight = 0;
        compositeLayout.marginWidth = 0;
        composite.setLayout((Layout)compositeLayout);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setBackground(parent.getBackground());
        SortedMap partialMatches = this.getPartialMatches();
        if (partialMatches.isEmpty()) {
            this.createEmptyDialogArea(composite);
        } else {
            this.createTableDialogArea(composite, partialMatches);
        }
        return composite;
    }

    private final void createEmptyDialogArea(Composite parent) {
        Label noMatchesLabel = new Label(parent, 0);
        noMatchesLabel.setText(Util.translateString(RESOURCE_BUNDLE, "NoMatches.Message"));
        noMatchesLabel.setLayoutData((Object)new GridData(1808));
        noMatchesLabel.setBackground(parent.getBackground());
    }

    private final void createTableDialogArea(Composite parent, SortedMap partialMatches) {
        this.completionsTable = new Table(parent, 67588);
        GridData gridData = new GridData(1808);
        this.completionsTable.setLayoutData((Object)gridData);
        this.completionsTable.setBackground(parent.getBackground());
        this.completionsTable.setLinesVisible(true);
        this.commands.clear();
        TableColumn columnCommandName = new TableColumn(this.completionsTable, 16384, 0);
        TableColumn columnKeySequence = new TableColumn(this.completionsTable, 16384, 1);
        Iterator itemsItr = partialMatches.entrySet().iterator();
        while (itemsItr.hasNext()) {
            Map.Entry entry = itemsItr.next();
            KeySequence sequence = (KeySequence)entry.getValue();
            ICommand command = (ICommand)entry.getKey();
            try {
                String[] text = new String[]{command.getName(), sequence.format()};
                TableItem item = new TableItem(this.completionsTable, 0);
                item.setText(text);
                this.commands.add(command);
            }
            catch (NotDefinedException notDefinedException) {}
        }
        columnKeySequence.pack();
        if (this.previousWidth != -1) {
            columnKeySequence.setWidth(this.previousWidth);
        }
        columnCommandName.pack();
        this.completionsTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public final void widgetDefaultSelected(SelectionEvent event) {
                KeyAssistDialog.this.executeKeyBinding();
            }
        });
    }

    private final void editKeyBinding() {
        String[] highlights = new String[]{"org.eclipse.ui.preferencePages.Keys", "org.eclipse.ui.preferencePages.Perspectives"};
        WorkbenchPreferenceDialog dialog = WorkbenchPreferenceDialog.createDialogOn("org.eclipse.ui.preferencePages.Keys", highlights);
        IPreferencePage page = dialog.getCurrentPage();
        if (page instanceof KeysPreferencePage) {
            KeysPreferencePage keysPreferencePage = (KeysPreferencePage)page;
            keysPreferencePage.editCommand(this.commandName, this.keySequence);
        }
        this.clearRememberedState();
        dialog.open();
    }

    private final void executeKeyBinding() {
        int selectionIndex = this.completionsTable.getSelectionIndex();
        if (selectionIndex >= 0) {
            ICommand command = (ICommand)this.commands.get(selectionIndex);
            try {
                this.workbenchKeyboard.executeCommand(command.getId());
            }
            catch (CommandException e) {
                this.workbenchKeyboard.logException(e);
            }
        }
    }

    private final SortedMap getPartialMatches() {
        Map partialMatches = this.commandManager.getPartialMatches(this.keyBindingState.getCurrentSequence());
        TreeMap sortedMatches = new TreeMap(new Comparator(){

            public final int compare(Object a, Object b) {
                ICommand commandA = (ICommand)a;
                ICommand commandB = (ICommand)b;
                try {
                    return commandA.getName().compareTo(commandB.getName());
                }
                catch (NotDefinedException e) {
                    throw new AssertionError((Object)e);
                }
            }
        });
        Iterator partialMatchItr = partialMatches.entrySet().iterator();
        while (partialMatchItr.hasNext()) {
            Map.Entry entry = partialMatchItr.next();
            String commandId = (String)entry.getValue();
            ICommand command = this.commandManager.getCommand(commandId);
            if (!command.isDefined() || !this.activityManager.getIdentifier(command.getId()).isEnabled()) continue;
            sortedMatches.put(command, entry.getKey());
        }
        return sortedMatches;
    }

    public final int open() {
        if (this.commandName != null && this.keySequence != null) {
            this.editKeyBinding();
            this.clearRememberedState();
            return 0;
        }
        Shell shell = this.getShell();
        if (shell != null) {
            this.close();
        }
        this.create();
        Point size = this.configureSize();
        this.configureLocation(size);
        return super.open();
    }

    private final void registerListeners() {
        Shell shell = this.getShell();
        shell.addListener(27, new Listener(){

            public void handleEvent(Event event) {
                KeyAssistDialog.this.close();
            }
        });
    }

    private final void registerShellType() {
        Shell shell = this.getShell();
        IWorkbenchContextSupport contextSupport = this.keyBindingState.getAssociatedWindow().getWorkbench().getContextSupport();
        contextSupport.registerShell(shell, contextSupport.getShellType((Shell)shell.getParent()));
    }

    protected final void setParentShell(Shell newParentShell) {
        super.setParentShell(newParentShell);
    }
}

