/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.keys;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.commands.CommandException;
import org.eclipse.ui.commands.ICommand;
import org.eclipse.ui.commands.ICommandManager;
import org.eclipse.ui.commands.NotHandledException;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.commands.ws.WorkbenchCommandSupport;
import org.eclipse.ui.internal.contexts.ws.WorkbenchContextSupport;
import org.eclipse.ui.internal.keys.KeyAssistDialog;
import org.eclipse.ui.internal.keys.KeyBindingState;
import org.eclipse.ui.internal.keys.OutOfOrderListener;
import org.eclipse.ui.internal.keys.OutOfOrderVerifyListener;
import org.eclipse.ui.internal.misc.Policy;
import org.eclipse.ui.internal.util.Util;
import org.eclipse.ui.keys.KeySequence;
import org.eclipse.ui.keys.KeyStroke;
import org.eclipse.ui.keys.ParseException;
import org.eclipse.ui.keys.SWTKeySupport;

public final class WorkbenchKeyboard {
    private static final boolean DEBUG = Policy.DEBUG_KEY_BINDINGS;
    private static final boolean DEBUG_VERBOSE = Policy.DEBUG_KEY_BINDINGS_VERBOSE;
    private static final int DELAY = 1000;
    static KeySequence outOfOrderKeys;
    private static final ResourceBundle RESOURCE_BUNDLE;
    private final ICommandManager commandManager;
    private final Listener keyDownFilter = new Listener(){

        public void handleEvent(Event event) {
            if (DEBUG && DEBUG_VERBOSE) {
                System.out.print("KEYS >>> Listener.handleEvent(type = ");
                switch (event.type) {
                    case 1: {
                        System.out.print("KeyDown");
                        break;
                    }
                    case 31: {
                        System.out.print("Traverse");
                        break;
                    }
                    default: {
                        System.out.print(event.type);
                    }
                }
                System.out.println(", stateMask = 0x" + Integer.toHexString(event.stateMask) + ", keyCode = 0x" + Integer.toHexString(event.keyCode) + ", time = " + Integer.toHexString(event.time) + ", character = 0x" + Integer.toHexString(event.character) + ")");
            }
            WorkbenchKeyboard.this.filterKeySequenceBindings(event);
        }
    };
    private KeyAssistDialog keyAssistDialog = null;
    private final OutOfOrderListener outOfOrderListener = new OutOfOrderListener(this);
    private final OutOfOrderVerifyListener outOfOrderVerifyListener = new OutOfOrderVerifyListener(this.outOfOrderListener);
    private long startTime = Long.MAX_VALUE;
    private final KeyBindingState state;
    private final IWindowListener windowListener = new IWindowListener(){

        public void windowActivated(IWorkbenchWindow window) {
            WorkbenchKeyboard.this.checkActiveWindow(window);
        }

        public void windowClosed(IWorkbenchWindow window) {
        }

        public void windowDeactivated(IWorkbenchWindow window) {
        }

        public void windowOpened(IWorkbenchWindow window) {
        }
    };
    private final IWorkbench workbench;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.internal.keys.WorkbenchKeyboard");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        RESOURCE_BUNDLE = ResourceBundle.getBundle(clazz.getName());
        try {
            outOfOrderKeys = KeySequence.getInstance("ESC DEL");
        }
        catch (ParseException e) {
            outOfOrderKeys = KeySequence.getInstance();
            String message = "Could not parse out-of-order keys definition: 'ESC DEL'.  Continuing with no out-of-order keys.";
            WorkbenchPlugin.log(message, (IStatus)new Status(4, WorkbenchPlugin.PI_WORKBENCH, 0, message, (Throwable)e));
        }
    }

    public static List generatePossibleKeyStrokes(Event event) {
        int thirdAccelerator;
        ArrayList<KeyStroke> keyStrokes = new ArrayList<KeyStroke>(3);
        if (event.stateMask == 0 && event.keyCode == 0 && event.character == '\u0000') {
            return keyStrokes;
        }
        int firstAccelerator = SWTKeySupport.convertEventToUnmodifiedAccelerator(event);
        keyStrokes.add(SWTKeySupport.convertAcceleratorToKeyStroke(firstAccelerator));
        if (event.character == '\u007f') {
            return keyStrokes;
        }
        int secondAccelerator = SWTKeySupport.convertEventToUnshiftedModifiedAccelerator(event);
        if (secondAccelerator != firstAccelerator) {
            keyStrokes.add(SWTKeySupport.convertAcceleratorToKeyStroke(secondAccelerator));
        }
        if ((thirdAccelerator = SWTKeySupport.convertEventToModifiedAccelerator(event)) != secondAccelerator && thirdAccelerator != firstAccelerator) {
            keyStrokes.add(SWTKeySupport.convertAcceleratorToKeyStroke(thirdAccelerator));
        }
        return keyStrokes;
    }

    private static boolean isOutOfOrderKey(List keyStrokes) {
        Iterator keyStrokeItr = keyStrokes.iterator();
        List outOfOrderKeyStrokes = outOfOrderKeys.getKeyStrokes();
        while (keyStrokeItr.hasNext()) {
            if (!outOfOrderKeyStrokes.contains(keyStrokeItr.next())) continue;
            return true;
        }
        return false;
    }

    public WorkbenchKeyboard(Workbench associatedWorkbench) {
        this.workbench = associatedWorkbench;
        this.state = new KeyBindingState(associatedWorkbench);
        this.commandManager = this.workbench.getCommandSupport().getCommandManager();
        this.workbench.addWindowListener(this.windowListener);
    }

    private void checkActiveWindow(IWorkbenchWindow window) {
        if (!window.equals(this.state.getAssociatedWindow())) {
            this.resetState(true);
            this.state.setAssociatedWindow(window);
        }
    }

    private void closeMultiKeyAssistShell() {
        Shell shell;
        if (this.keyAssistDialog != null && (shell = this.keyAssistDialog.getShell()) != null && !shell.isDisposed() && shell.isVisible()) {
            this.keyAssistDialog.close(true);
        }
    }

    private static boolean isEnabled(ICommand command) {
        try {
            Map attributeValuesByName = command.getAttributeValuesByName();
            return !attributeValuesByName.containsKey("enabled") || Boolean.TRUE.equals(attributeValuesByName.get("enabled"));
        }
        catch (NotHandledException notHandledException) {
            return false;
        }
    }

    final boolean executeCommand(String commandId) throws CommandException {
        if (DEBUG) {
            System.out.println("KEYS >>> WorkbenchKeyboard.executeCommand(commandId = '" + commandId + "')");
        }
        this.resetState(false);
        ICommand command = this.commandManager.getCommand(commandId);
        if (DEBUG && DEBUG_VERBOSE) {
            if (!command.isDefined()) {
                System.out.println("KEYS >>>     not defined");
            } else if (!command.isHandled()) {
                System.out.println("KEYS >>>     not handled");
            } else if (!WorkbenchKeyboard.isEnabled(command)) {
                System.out.println("KEYS >>>     not enabled");
            } else {
                try {
                    Map attributeValuesByName = command.getAttributeValuesByName();
                    System.out.println("KEYS >>>     value for 'id' attribute = " + attributeValuesByName.get("id"));
                    System.out.println("KEYS >>>     value for 'enabled' attribute = " + attributeValuesByName.get("enabled"));
                }
                catch (NotHandledException eNotHandled) {
                    System.out.println(eNotHandled);
                }
            }
        }
        boolean commandDefined = command.isDefined();
        boolean commandHandled = command.isHandled();
        if (commandDefined && commandHandled && WorkbenchKeyboard.isEnabled(command)) {
            command.execute(null);
        }
        if (this.keyAssistDialog != null) {
            this.keyAssistDialog.clearRememberedState();
        }
        return commandDefined && commandHandled;
    }

    private void filterKeySequenceBindings(Event event) {
        if ((event.keyCode & SWT.MODIFIER_MASK) != 0) {
            return;
        }
        List keyStrokes = WorkbenchKeyboard.generatePossibleKeyStrokes(event);
        if (WorkbenchKeyboard.isOutOfOrderKey(keyStrokes)) {
            Widget widget = event.widget;
            if (event.character == '\u007f' && (event.stateMask & SWT.MODIFIER_MASK) == 0 && (widget instanceof Text || widget instanceof Combo)) {
                return;
            }
            if (widget instanceof StyledText) {
                if (event.type == 1 && !this.outOfOrderVerifyListener.isActive(event.time)) {
                    ((StyledText)widget).addVerifyKeyListener((VerifyKeyListener)this.outOfOrderVerifyListener);
                    this.outOfOrderVerifyListener.setActive(event.time);
                }
            } else if (!this.outOfOrderListener.isActive(event.time)) {
                widget.addListener(1, (Listener)this.outOfOrderListener);
                this.outOfOrderListener.setActive(event.time);
            }
        } else {
            this.processKeyEvent(keyStrokes, event);
        }
    }

    public Listener getKeyDownFilter() {
        return this.keyDownFilter;
    }

    private String getPerfectMatch(KeySequence keySequence) {
        return this.commandManager.getPerfectMatch(keySequence);
    }

    private void incrementState(KeySequence sequence) {
        final long myStartTime = this.startTime = System.currentTimeMillis();
        this.state.setCurrentSequence(sequence);
        this.state.setAssociatedWindow(this.workbench.getActiveWorkbenchWindow());
        Display display = this.workbench.getDisplay();
        display.timerExec(1000, new Runnable(){

            public void run() {
                if (System.currentTimeMillis() > myStartTime - 1000L && WorkbenchKeyboard.this.startTime == myStartTime) {
                    WorkbenchKeyboard.this.openMultiKeyAssistShell();
                }
            }
        });
    }

    private boolean isPartialMatch(KeySequence keySequence) {
        return this.commandManager.isPartialMatch(keySequence);
    }

    private boolean isPerfectMatch(KeySequence keySequence) {
        return this.commandManager.isPerfectMatch(keySequence);
    }

    final void logException(CommandException e) {
        Throwable nestedException = e.getCause();
        Throwable exception = nestedException == null ? e : nestedException;
        String message = Util.translateString(RESOURCE_BUNDLE, "ExecutionError.Message");
        String title = Util.translateString(RESOURCE_BUNDLE, "ExecutionError.Title");
        String exceptionMessage = exception.getMessage();
        if (exceptionMessage == null) {
            exceptionMessage = message;
        }
        Status status = new Status(4, WorkbenchPlugin.PI_WORKBENCH, 0, exceptionMessage, exception);
        WorkbenchPlugin.log(message, (IStatus)status);
        ErrorDialog.openError((Shell)this.workbench.getActiveWorkbenchWindow().getShell(), (String)title, (String)message, (IStatus)status);
    }

    public final void openMultiKeyAssistShell() {
        if (this.keyAssistDialog == null) {
            this.keyAssistDialog = new KeyAssistDialog(this.workbench, this, this.state);
        }
        if (this.keyAssistDialog.getShell() == null) {
            Shell parentShell = this.workbench.getDisplay().getActiveShell();
            this.keyAssistDialog.setParentShell(parentShell);
        }
        this.keyAssistDialog.open();
    }

    public boolean press(List potentialKeyStrokes, Event event) throws CommandException {
        if (DEBUG && DEBUG_VERBOSE) {
            System.out.println("KEYS >>> WorkbenchKeyboard.press(potentialKeyStrokes = " + potentialKeyStrokes + ")");
        }
        if ("gtk".equals(SWT.getPlatform())) {
            Widget widget = event.widget;
            Shell shell = widget instanceof Control && !widget.isDisposed() ? ((Control)widget).getShell() : Display.getCurrent().getActiveShell();
            ((WorkbenchCommandSupport)this.workbench.getCommandSupport()).processHandlerSubmissions(false, shell);
            ((WorkbenchContextSupport)this.workbench.getContextSupport()).processEnabledSubmissions(false, shell);
        }
        KeySequence sequenceBeforeKeyStroke = this.state.getCurrentSequence();
        Iterator iterator = potentialKeyStrokes.iterator();
        while (iterator.hasNext()) {
            KeySequence sequenceAfterKeyStroke = KeySequence.getInstance(sequenceBeforeKeyStroke, (KeyStroke)iterator.next());
            if (this.isPartialMatch(sequenceAfterKeyStroke)) {
                this.incrementState(sequenceAfterKeyStroke);
                return true;
            }
            if (this.isPerfectMatch(sequenceAfterKeyStroke)) {
                String commandId = this.getPerfectMatch(sequenceAfterKeyStroke);
                return this.executeCommand(commandId) || !sequenceBeforeKeyStroke.isEmpty();
            }
            if (this.keyAssistDialog == null || event.keyCode != 0x1000002 && event.keyCode != 0x1000001 && event.keyCode != 0x1000003 && event.keyCode != 0x1000004 && event.keyCode != 13 && event.keyCode != 0x1000005 && event.keyCode != 0x1000006) continue;
            return false;
        }
        this.resetState(true);
        return false;
    }

    void processKeyEvent(List keyStrokes, Event event) {
        boolean eatKey = false;
        if (!keyStrokes.isEmpty()) {
            try {
                eatKey = this.press(keyStrokes, event);
            }
            catch (CommandException e) {
                this.logException(e);
                eatKey = true;
            }
        }
        if (eatKey) {
            switch (event.type) {
                case 1: {
                    event.doit = false;
                    break;
                }
                case 31: {
                    event.detail = 0;
                    event.doit = true;
                }
            }
            event.type = 0;
        }
    }

    private final void resetState(boolean clearRememberedState) {
        this.startTime = Long.MAX_VALUE;
        this.state.reset();
        this.closeMultiKeyAssistShell();
        if (this.keyAssistDialog != null && clearRememberedState) {
            this.keyAssistDialog.clearRememberedState();
        }
    }
}

