/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.registry;

import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.commands.AbstractHandler;
import org.eclipse.ui.internal.WorkbenchMessages;

public class OpenPerspectiveHandler
extends AbstractHandler {
    private String perspectiveId;

    public OpenPerspectiveHandler(String perspectiveId) {
        this.perspectiveId = perspectiveId;
    }

    public Object execute(Map parameterValuesByName) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow activeWorkbenchWindow = workbench.getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            return null;
        }
        IAdaptable input = null;
        IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
        if (activePage != null) {
            input = activePage.getInput();
        }
        try {
            workbench.showPerspective(this.perspectiveId, activeWorkbenchWindow, input);
        }
        catch (WorkbenchException e) {
            ErrorDialog.openError((Shell)activeWorkbenchWindow.getShell(), (String)WorkbenchMessages.getString("ChangeToPerspectiveMenu.errorTitle"), (String)e.getMessage(), (IStatus)e.getStatus());
        }
        return null;
    }
}

