/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.registry;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.internal.registry.IStickyViewDescriptor;

public class StickyViewDescriptor
implements IStickyViewDescriptor {
    private static final String ATT_ID = "id";
    private static final String ATT_LOCATION = "location";
    private static final String ATT_CLOSEABLE = "closeable";
    private static final String ATT_MOVEABLE = "moveable";
    private IConfigurationElement configurationElement;
    private String id;

    public StickyViewDescriptor(IConfigurationElement singleton) throws CoreException {
        this.configurationElement = singleton;
        this.id = this.configurationElement.getAttribute(ATT_ID);
        if (this.id == null) {
            throw new CoreException((IStatus)new Status(4, singleton.getDeclaringExtension().getNamespace(), 0, "Invalid extension (missing id) ", null));
        }
    }

    public IConfigurationElement getConfigurationElement() {
        return this.configurationElement;
    }

    public int getLocation() {
        int direction = 2;
        String location = this.configurationElement.getAttribute(ATT_LOCATION);
        if (location != null) {
            if (location.equalsIgnoreCase("left")) {
                direction = 1;
            } else if (location.equalsIgnoreCase("top")) {
                direction = 3;
            } else if (location.equalsIgnoreCase("bottom")) {
                direction = 4;
            }
        }
        return direction;
    }

    public String getId() {
        return this.id;
    }

    public String getNamespace() {
        return this.configurationElement.getNamespace();
    }

    public boolean isCloseable() {
        boolean closeable = true;
        String closeableString = this.configurationElement.getAttribute(ATT_CLOSEABLE);
        if (closeableString != null) {
            closeable = !closeableString.equals("false");
        }
        return closeable;
    }

    public boolean isMoveable() {
        boolean moveable = true;
        String moveableString = this.configurationElement.getAttribute(ATT_MOVEABLE);
        if (moveableString != null) {
            moveable = !moveableString.equals("false");
        }
        return moveable;
    }
}

