/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.registry.experimental;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.registry.experimental.IConfigurationElementAdditionHandler;
import org.eclipse.ui.internal.registry.experimental.IConfigurationElementRemovalHandler;
import org.eclipse.ui.internal.registry.experimental.IConfigurationElementTracker;

public class ConfigurationElementTracker
implements IConfigurationElementTracker,
IRegistryChangeListener {
    private Map configElementToObjectSetMap = new HashMap();
    private Set removalHandlerSet = new HashSet();
    private Set additionHandlerSet = new HashSet();

    public ConfigurationElementTracker() {
        Platform.getExtensionRegistry().addRegistryChangeListener((IRegistryChangeListener)this);
    }

    public void registerAdditionHandler(IConfigurationElementAdditionHandler handler) {
        this.additionHandlerSet.add(handler);
    }

    public void unregisterAdditionHandler(IConfigurationElementAdditionHandler handler) {
        this.additionHandlerSet.remove(handler);
    }

    public void registerRemovalHandler(IConfigurationElementRemovalHandler handler) {
        this.removalHandlerSet.add(handler);
    }

    public void unregisterRemovalHandler(IConfigurationElementRemovalHandler handler) {
        this.removalHandlerSet.remove(handler);
    }

    public void registerObject(IConfigurationElement element, Object object) {
        if (element == null || object == null) {
            return;
        }
        HashSet<WeakReference<Object>> objectSet = (HashSet<WeakReference<Object>>)this.configElementToObjectSetMap.get(element);
        if (objectSet == null) {
            objectSet = new HashSet<WeakReference<Object>>();
            this.configElementToObjectSetMap.put(element, objectSet);
        }
        objectSet.add(new WeakReference<Object>(object));
    }

    /*
     * Exception decompiling
     */
    public void registryChanged(IRegistryChangeEvent event) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 137->141)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void doRemove(Display display, IExtensionDelta delta) {
        IConfigurationElement[] elements = delta.getExtension().getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            final IConfigurationElement element = elements[i];
            Set objectSet = (Set)this.configElementToObjectSetMap.get(element);
            if (objectSet != null) {
                Iterator j = objectSet.iterator();
                while (j.hasNext()) {
                    WeakReference reference = (WeakReference)j.next();
                    final Object object = reference.get();
                    if (object == null) {
                        j.remove();
                        continue;
                    }
                    Iterator k = this.removalHandlerSet.iterator();
                    while (k.hasNext()) {
                        final IConfigurationElementRemovalHandler handler = (IConfigurationElementRemovalHandler)k.next();
                        display.syncExec(new Runnable(){

                            public void run() {
                                try {
                                    handler.removeInstance(element, object);
                                }
                                catch (Exception e) {
                                    WorkbenchPlugin.log(this.getClass(), "doRemove", e);
                                }
                            }
                        });
                    }
                }
                if (objectSet.isEmpty()) {
                    this.configElementToObjectSetMap.remove(elements[i]);
                }
            }
            ++i;
        }
    }

    private void doAdd(Display display, IExtensionDelta delta) {
        IConfigurationElement[] elements = delta.getExtension().getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            final IConfigurationElement element = elements[i];
            Iterator j = this.additionHandlerSet.iterator();
            while (j.hasNext()) {
                final IConfigurationElementAdditionHandler handler = (IConfigurationElementAdditionHandler)j.next();
                display.syncExec(new Runnable(){

                    public void run() {
                        try {
                            handler.addInstance(ConfigurationElementTracker.this, element);
                        }
                        catch (Exception e) {
                            WorkbenchPlugin.log(this.getClass(), "doAdd", e);
                        }
                    }
                });
            }
            ++i;
        }
    }
}

