/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.jcon;

import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import javax.naming.NamingException;
import org.apache.log4j.Category;
import uk.ac.sanger.jcon.JobControl;
import uk.ac.sanger.jcon.dao.JobDAO;
import uk.ac.sanger.jcon.dao.StatusDAO;
import uk.ac.sanger.jcon.dao.TaskDAO;
import uk.ac.sanger.jcon.dao.TaskStatisticDAO;
import uk.ac.sanger.jcon.job.Job;
import uk.ac.sanger.jcon.job.Status;
import uk.ac.sanger.jcon.run.Coordinator;
import uk.ac.sanger.jcon.run.CoordinatorLSFImpl;
import uk.ac.sanger.jcon.run.PolicyRoundRobinImpl;
import uk.ac.sanger.jcon.run.ProcessorLSFImpl;
import uk.ac.sanger.jcon.run.TaskScheduler;
import uk.ac.sanger.jcon.run.TaskSchedulerDefaultImpl;
import uk.ac.sanger.util.CommandLineDoc;

public class JobControlApp {
    static Category cat = Category.getInstance((String)(class$uk$ac$sanger$jcon$JobControlApp == null ? (class$uk$ac$sanger$jcon$JobControlApp = JobControlApp.class$("uk.ac.sanger.jcon.JobControlApp")) : class$uk$ac$sanger$jcon$JobControlApp).getName());
    private static CommandLineDoc docs;
    private JobControl jobControl;
    private File pidFile;
    private Coordinator coordinator;
    private TaskScheduler scheduler;
    static /* synthetic */ Class class$uk$ac$sanger$jcon$JobControlApp;

    public static void main(String[] argv) throws Exception {
        docs = new CommandLineDoc();
        JobControlApp jcApp = new JobControlApp("jobcontrol.pid");
        jcApp.startUpLSFSQL();
    }

    JobControlApp(String pidFileName) throws NamingException {
        this.pidFile = new File(pidFileName);
        this.jobControl = new JobControl();
    }

    private void startUpLSFSQL() throws Exception {
        JobDAO jobDAO = this.jobControl.createJobDAO();
        StatusDAO statusDAO = this.jobControl.createStatusDAO();
        TaskDAO taskDAO = this.jobControl.createTaskDAO();
        TaskStatisticDAO taskStatDAO = this.jobControl.createTaskStatisticDAO();
        this.coordinator = new CoordinatorLSFImpl(ProcessorLSFImpl.FACTORY, jobDAO, statusDAO);
        this.scheduler = new TaskSchedulerDefaultImpl(taskDAO, this.coordinator);
        this.scheduler.setSendMail(false);
        this.scheduler.setPolicy(new PolicyRoundRobinImpl(taskStatDAO));
        this.cleanUp(taskStatDAO, statusDAO, jobDAO);
        PIDFileWatcher watcher = new PIDFileWatcher(this.pidFile);
        watcher.start();
        this.scheduler.startScheduling();
        this.coordinator.startCoordinating();
    }

    private void cleanUp(TaskStatisticDAO taskStatDAO, StatusDAO statusDAO, JobDAO jobDAO) {
        try {
            Status started = statusDAO.readStatusById(3);
            int[] submittedTaskIds = taskStatDAO.readSubmittedTaskId();
            cat.info((Object)("Found " + submittedTaskIds.length + " submitted Tasks on startup"));
            int i = 0;
            while (i < submittedTaskIds.length) {
                cat.info((Object)("Checking state of Task [" + submittedTaskIds[i] + "]"));
                Collection startedJobs = jobDAO.readJobsByStatusAndTaskId(started, submittedTaskIds[i]);
                cat.info((Object)("Found " + startedJobs.size() + " started Jobs whose current state is unknown"));
                Iterator ji = startedJobs.iterator();
                while (ji.hasNext()) {
                    Job j = (Job)ji.next();
                    cat.warn((Object)("Cleaning up " + j));
                    jobDAO.updateJobReady(j);
                }
                ++i;
            }
        }
        catch (Exception e) {
            cat.error((Object)"Failed to clean up Jobs on restart", (Throwable)e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class PIDFileWatcher
    implements Runnable {
        private Thread thread;
        private File pidFile;

        PIDFileWatcher(File pidFile) {
            this.pidFile = pidFile;
            this.thread = new Thread(this);
            this.thread.setDaemon(true);
        }

        public void start() {
            this.thread.start();
        }

        public void run() {
            while (this.checkPIDFile()) {
                this.waitFor(60000);
            }
        }

        private boolean checkPIDFile() {
            if (!this.pidFile.exists() || !this.pidFile.isFile()) {
                cat.info((Object)("PID file " + this.pidFile + " indicates halt required."));
                JobControlApp.this.scheduler.stopScheduling();
                JobControlApp.this.coordinator.stopCoordinating();
                return false;
            }
            return true;
        }

        private synchronized void waitFor(int milliSeconds) {
            try {
                cat.info((Object)("Waiting for " + milliSeconds + " ms"));
                this.wait(milliSeconds);
            }
            catch (InterruptedException ie) {
                cat.error((Object)"Caught an Exception", (Throwable)ie);
            }
        }
    }
}

