/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.jcon.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ResourceBundle;
import javax.sql.DataSource;
import org.apache.log4j.Category;
import uk.ac.sanger.jcon.JobControlException;
import uk.ac.sanger.jcon.dao.OwnerDAO;
import uk.ac.sanger.jcon.dao.SQLDAOBaseImpl;
import uk.ac.sanger.jcon.job.Owner;
import uk.ac.sanger.jcon.job.OwnerDefaultImpl;

public class OwnerSQLDAO
extends SQLDAOBaseImpl
implements OwnerDAO {
    static Category cat = Category.getInstance((String)(class$uk$ac$sanger$jcon$dao$OwnerSQLDAO == null ? (class$uk$ac$sanger$jcon$dao$OwnerSQLDAO = OwnerSQLDAO.class$("uk.ac.sanger.jcon.dao.OwnerSQLDAO")) : class$uk$ac$sanger$jcon$dao$OwnerSQLDAO).getName());
    static ResourceBundle sqlStatements = ResourceBundle.getBundle((class$uk$ac$sanger$jcon$dao$OwnerSQLDAO == null ? (class$uk$ac$sanger$jcon$dao$OwnerSQLDAO = OwnerSQLDAO.class$("uk.ac.sanger.jcon.dao.OwnerSQLDAO")) : class$uk$ac$sanger$jcon$dao$OwnerSQLDAO).getName());
    private HashMap canonical = new HashMap(50);
    static /* synthetic */ Class class$uk$ac$sanger$jcon$dao$OwnerSQLDAO;

    public OwnerSQLDAO() {
    }

    public OwnerSQLDAO(DataSource datasource) {
        super(datasource);
    }

    public synchronized void createOwner(Owner owner) throws Exception {
        String sql = sqlStatements.getString("createOwner");
        Connection c = this.getManagedConnection();
        PreparedStatement ps = null;
        boolean rollback = false;
        try {
            int newId = this.createNewOwnerId();
            this.setObjectIntField(owner, "id", newId);
            cat.debug((Object)("Preparing SQL: " + sql));
            ps = c.prepareStatement(sql);
            ps.setInt(1, owner.getId());
            ps.setString(2, owner.getUserName());
            ps.setString(3, owner.getFirstName());
            ps.setString(4, owner.getLastName());
            ps.setString(5, owner.getEMail());
            ps.setString(6, owner.getTelephone());
            cat.debug((Object)("Executing SQL: " + ps));
            ps.executeUpdate();
        }
        catch (Exception e) {
            try {
                cat.error((Object)"Caught an Exception; rolling back transaction", (Throwable)e);
                rollback = true;
                throw e;
            }
            catch (Throwable throwable) {
                this.cSupport.close(ps);
                if (rollback) {
                    this.cSupport.rollback(c);
                } else {
                    this.cSupport.commit(c);
                }
                if (this.isManagingConnections()) {
                    this.cSupport.close(c);
                }
                throw throwable;
            }
        }
        this.cSupport.close((Statement)ps);
        if (rollback) {
            this.cSupport.rollback(c);
        } else {
            this.cSupport.commit(c);
        }
        if (this.isManagingConnections()) {
            this.cSupport.close(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Collection readAllOwners() throws SQLException {
        String sql = sqlStatements.getString("readAllOwners");
        Connection c = this.getManagedConnection();
        Statement s = null;
        ResultSet r = null;
        ArrayList<Owner> owners = new ArrayList<Owner>();
        try {
            cat.debug((Object)("Preparing SQL: " + sql));
            s = c.createStatement();
            cat.debug((Object)("Executing SQL: " + s));
            r = s.executeQuery(sql);
            while (r.next()) {
                owners.add(this.populateOwner(r));
            }
        }
        catch (Throwable throwable) {
            this.cSupport.close(r);
            this.cSupport.close(s);
            if (this.isManagingConnections()) {
                this.cSupport.close(c);
            }
            throw throwable;
        }
        this.cSupport.close(r);
        this.cSupport.close(s);
        if (this.isManagingConnections()) {
            this.cSupport.close(c);
        }
        return owners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Owner readOwnerById(int ownerId) throws SQLException, JobControlException {
        Integer canonKey = new Integer(ownerId);
        if (this.canonical.containsKey(canonKey)) {
            cat.debug((Object)("Fetching canonical Owner [" + canonKey + "] from cache"));
            return (Owner)this.canonical.get(canonKey);
        }
        String sql = sqlStatements.getString("readOwnerById");
        Connection c = this.getManagedConnection();
        PreparedStatement ps = null;
        ResultSet r = null;
        Owner owner = null;
        try {
            cat.debug((Object)("Preparing SQL: " + sql));
            ps = c.prepareStatement(sql);
            ps.setInt(1, ownerId);
            cat.debug((Object)("Executing SQL: " + ps));
            r = ps.executeQuery();
            if (!r.next()) {
                throw new JobControlException("Requested a non-existent Owner with ID '" + ownerId + "'");
            }
            owner = this.populateOwner(r);
            this.canonical.put(canonKey, owner);
        }
        catch (Throwable throwable) {
            this.cSupport.close(r);
            this.cSupport.close(ps);
            if (this.isManagingConnections()) {
                this.cSupport.close(c);
            }
            throw throwable;
        }
        this.cSupport.close(r);
        this.cSupport.close((Statement)ps);
        if (this.isManagingConnections()) {
            this.cSupport.close(c);
        }
        return owner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Owner readOwnerByUserName(String userName) throws SQLException, JobControlException {
        Owner owner;
        ResultSet r;
        PreparedStatement ps;
        Connection c;
        block6: {
            Iterator oi = this.canonical.values().iterator();
            while (oi.hasNext()) {
                Owner owner2 = (Owner)oi.next();
                if (!userName.equals(owner2.getUserName())) continue;
                cat.debug((Object)("Fetching canonical Owner [" + owner2.getId() + "] from cache"));
                return owner2;
            }
            String sql = sqlStatements.getString("readOwnerByUserName");
            c = this.getManagedConnection();
            ps = null;
            r = null;
            owner = null;
            try {
                cat.debug((Object)("Preparing SQL: " + sql));
                ps = c.prepareStatement(sql);
                ps.setString(1, userName);
                cat.debug((Object)("Executing SQL: " + ps));
                r = ps.executeQuery();
                if (r.next()) {
                    owner = this.populateOwner(r);
                    this.canonical.put(new Integer(owner.getId()), owner);
                    break block6;
                }
                throw new JobControlException("Requested a non-existent Owner with user name '" + userName + "'");
            }
            catch (Throwable throwable) {
                this.cSupport.close(r);
                this.cSupport.close(ps);
                if (this.isManagingConnections()) {
                    this.cSupport.close(c);
                }
                throw throwable;
            }
        }
        this.cSupport.close(r);
        this.cSupport.close((Statement)ps);
        if (this.isManagingConnections()) {
            this.cSupport.close(c);
        }
        return owner;
    }

    public synchronized void deleteOwner(Owner owner) throws SQLException {
        String sql = sqlStatements.getString("deleteOwner");
        Connection c = this.getManagedConnection();
        PreparedStatement ps = null;
        boolean rollback = false;
        int ownerId = owner.getId();
        try {
            cat.debug((Object)("Preparing SQL: " + sql));
            ps = c.prepareStatement(sql);
            ps.setInt(1, ownerId);
            cat.debug((Object)("Executing SQL: " + ps));
            ps.executeUpdate();
        }
        catch (SQLException se) {
            try {
                cat.error((Object)"Caught an Exception; rolling back transaction", (Throwable)se);
                rollback = true;
                throw se;
            }
            catch (Throwable throwable) {
                this.cSupport.close(ps);
                if (rollback) {
                    this.cSupport.rollback(c);
                } else {
                    this.cSupport.commit(c);
                    this.canonical.remove(new Integer(ownerId));
                }
                if (this.isManagingConnections()) {
                    this.cSupport.close(c);
                }
                throw throwable;
            }
        }
        this.cSupport.close((Statement)ps);
        if (rollback) {
            this.cSupport.rollback(c);
        } else {
            this.cSupport.commit(c);
            this.canonical.remove(new Integer(ownerId));
        }
        if (this.isManagingConnections()) {
            this.cSupport.close(c);
        }
    }

    private Owner populateOwner(ResultSet r) throws SQLException {
        OwnerDefaultImpl owner = new OwnerDefaultImpl(r.getString("first_name"), r.getString("last_name"), r.getString("user_name"), r.getString("email"), r.getString("telephone"));
        this.setObjectIntField(owner, "id", r.getInt("owner_id"));
        return owner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int createNewOwnerId() throws Exception {
        String sql = sqlStatements.getString("createNewOwnerId");
        Connection c = this.getConnection();
        Statement s = null;
        ResultSet r = null;
        int id = 0;
        try {
            cat.debug((Object)("Preparing SQL: " + sql));
            s = c.createStatement();
            cat.debug((Object)("Executing SQL: " + s));
            r = s.executeQuery(sql);
            if (!r.next()) {
                throw new Exception("Failed to retrieve a new Owner ID");
            }
            id = r.getInt("owner_id");
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.cSupport.close(r);
            this.cSupport.close(s);
            throw throwable;
        }
        this.cSupport.close(r);
        this.cSupport.close(s);
        return id;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

