/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.jcon.job;

import uk.ac.sanger.jcon.job.Executable;

public class ExecutableDefaultImpl
implements Executable {
    private int id;
    protected String name;
    protected String version;
    protected String description;

    public ExecutableDefaultImpl() {
    }

    public ExecutableDefaultImpl(String name, String version, String description) {
        if (name == null) {
            throw new IllegalArgumentException("Failed to set name as it was null");
        }
        if (description == null) {
            throw new IllegalArgumentException("Failed to set description as it was null");
        }
        this.checkFieldLength(name, 64);
        this.checkFieldLength(description, 128);
        if (version != null) {
            this.checkFieldLength(version, 32);
        }
        this.name = name;
        this.version = version;
        this.description = description;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Failed to set name as it was null");
        }
        this.checkFieldLength(name, 64);
        this.name = name;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        if (version != null) {
            this.checkFieldLength(version, 32);
        }
        this.version = version;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        if (description == null) {
            throw new IllegalArgumentException("Failed to set description as it was null");
        }
        this.checkFieldLength(description, 128);
        this.description = description;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Executable [");
        sb.append(this.id);
        sb.append("]");
        sb.append(" Name: ");
        sb.append(this.name);
        sb.append(" Version: ");
        sb.append(this.version);
        return sb.substring(0);
    }

    protected void checkFieldLength(String field, int maxLength) {
        if (field.length() > maxLength) {
            throw new IllegalArgumentException("Field " + field + " is longer than the permitted maximum of " + maxLength + " characters");
        }
    }
}

