/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.jcon.run;

import java.util.ArrayList;
import java.util.StringTokenizer;
import uk.ac.sanger.jcon.JobControlException;
import uk.ac.sanger.jcon.dao.StatusDAO;
import uk.ac.sanger.jcon.job.Job;
import uk.ac.sanger.jcon.run.CommandLineFactory;
import uk.ac.sanger.jcon.run.Processor;

public abstract class AbstractProcessor
implements Processor,
Runnable {
    protected CommandLineFactory clFactory;
    protected StatusDAO statusDAO;
    protected Thread thread;
    protected boolean isFree;
    protected Job job;

    public AbstractProcessor(CommandLineFactory clFactory, StatusDAO statusDAO) {
        this.clFactory = clFactory;
        this.statusDAO = statusDAO;
        this.isFree = true;
    }

    public Job getJob() {
        return this.job;
    }

    public boolean getFree() {
        return this.isFree;
    }

    public void setFree(boolean isFree) {
        this.isFree = isFree;
        if (isFree) {
            this.job = null;
        }
    }

    public void process(Job job) throws Exception {
        if (!this.getFree()) {
            throw new JobControlException("Failed to process Job as Processor is not free");
        }
        this.setFree(false);
        this.job = job;
        this.thread = new Thread(this);
        this.thread.start();
    }

    public abstract void run();

    protected String[] stringTokenise(String string) {
        StringTokenizer st = new StringTokenizer(string);
        ArrayList<String> tokens = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            tokens.add(st.nextToken());
        }
        return tokens.toArray(new String[0]);
    }
}

