/*
 * Decompiled with CFR 0.152.
 */
package Freeze;

import Freeze.ConnectionI;
import Freeze.DatabaseException;
import Freeze.DeadlockException;
import Freeze.Transaction;
import Ice.LocalObjectImpl;
import com.sleepycat.db.DbDeadlockException;
import com.sleepycat.db.DbException;
import com.sleepycat.db.DbTxn;

class TransactionI
extends LocalObjectImpl
implements Transaction {
    private ConnectionI _connection;
    private DbTxn _txn;
    private String _errorPrefix;

    public void commit() {
        try {
            try {
                this._connection.closeAllIterators();
                this._txn.commit(0);
            }
            catch (DbDeadlockException e) {
                DeadlockException ex = new DeadlockException();
                ex.initCause(e);
                ex.message = this._errorPrefix + "DbTxn.commit: " + e.getMessage();
                throw ex;
            }
            catch (DbException e) {
                DatabaseException ex = new DatabaseException();
                ex.initCause(e);
                ex.message = this._errorPrefix + "DbTxn.commit: " + e.getMessage();
                throw ex;
            }
            Object var4_1 = null;
            this._connection.clearTransaction();
            this._connection = null;
            this._txn = null;
        }
        catch (Throwable throwable) {
            Object var4_2 = null;
            this._connection.clearTransaction();
            this._connection = null;
            this._txn = null;
            throw throwable;
        }
    }

    public void rollback() {
        try {
            try {
                this._connection.closeAllIterators();
                this._txn.abort();
            }
            catch (DbDeadlockException e) {
                DeadlockException ex = new DeadlockException();
                ex.initCause(e);
                ex.message = this._errorPrefix + "DbTxn.abort: " + e.getMessage();
                throw ex;
            }
            catch (DbException e) {
                DatabaseException ex = new DatabaseException();
                ex.initCause(e);
                ex.message = this._errorPrefix + "DbTxn.abort: " + e.getMessage();
                throw ex;
            }
            Object var4_1 = null;
            this._connection.clearTransaction();
            this._connection = null;
            this._txn = null;
        }
        catch (Throwable throwable) {
            Object var4_2 = null;
            this._connection.clearTransaction();
            this._connection = null;
            this._txn = null;
            throw throwable;
        }
    }

    TransactionI(ConnectionI connection) {
        this._connection = connection;
        this._errorPrefix = "Freeze DB DbEnv(\"" + this._connection.envName() + "\") :";
        try {
            this._txn = this._connection.dbEnv().txn_begin(null, 0);
        }
        catch (DbException e) {
            DatabaseException ex = new DatabaseException();
            ex.initCause(e);
            ex.message = this._errorPrefix + "txn_begin: " + e.getMessage();
            throw ex;
        }
    }

    DbTxn dbTxn() {
        return this._txn;
    }
}

