/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.Current;
import Ice.FacetNotExistException;
import Ice.LocalObjectHolder;
import Ice.Object;
import Ice.ObjectAdapterI;
import Ice.ObjectNotExistException;
import Ice.ServantLocator;
import IceInternal.ServantManager;

public final class Direct {
    private final Current _current;
    private Object _servant;
    private ServantLocator _locator;
    private LocalObjectHolder _cookie;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Direct(Current current) {
        this._current = current;
        ObjectAdapterI adapter = (ObjectAdapterI)this._current.adapter;
        if (!$assertionsDisabled && adapter == null) {
            throw new AssertionError();
        }
        adapter.incDirectCount();
        ServantManager servantManager = adapter.getServantManager();
        if (!$assertionsDisabled && servantManager == null) {
            throw new AssertionError();
        }
        try {
            this._servant = servantManager.findServant(this._current.id, this._current.facet);
            if (this._servant == null && this._current.id.category.length() > 0) {
                this._locator = servantManager.findServantLocator(this._current.id.category);
                if (this._locator != null) {
                    this._cookie = new LocalObjectHolder();
                    this._servant = this._locator.locate(this._current, this._cookie);
                }
            }
            if (this._servant == null) {
                this._locator = servantManager.findServantLocator("");
                if (this._locator != null) {
                    this._cookie = new LocalObjectHolder();
                    this._servant = this._locator.locate(this._current, this._cookie);
                }
            }
            if (this._servant == null) {
                if (servantManager != null && servantManager.hasServant(this._current.id)) {
                    FacetNotExistException ex = new FacetNotExistException();
                    ex.id = this._current.id;
                    ex.facet = this._current.facet;
                    ex.operation = this._current.operation;
                    throw ex;
                }
                ObjectNotExistException ex = new ObjectNotExistException();
                ex.id = this._current.id;
                ex.facet = this._current.facet;
                ex.operation = this._current.operation;
                throw ex;
            }
        }
        catch (RuntimeException ex) {
            try {
                if (this._locator != null && this._servant != null) {
                    this._locator.finished(this._current, this._servant, this._cookie.value);
                }
                throw ex;
            }
            catch (Throwable throwable) {
                adapter.decDirectCount();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        ObjectAdapterI adapter = (ObjectAdapterI)this._current.adapter;
        if (!$assertionsDisabled && adapter == null) {
            throw new AssertionError();
        }
        try {
            if (this._locator != null && this._servant != null) {
                this._locator.finished(this._current, this._servant, this._cookie.value);
            }
        }
        finally {
            adapter.decDirectCount();
        }
    }

    public Object servant() {
        return this._servant;
    }

    static {
        $assertionsDisabled = !Direct.class.desiredAssertionStatus();
    }
}

