/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.AdapterNotFoundException;
import Ice.BooleanHolder;
import Ice.LocalException;
import Ice.LocatorPrx;
import Ice.LocatorRegistryPrx;
import Ice.LocatorRegistryPrxHelper;
import Ice.NotRegisteredException;
import Ice.ObjectNotFoundException;
import Ice.ObjectPrx;
import Ice.ObjectPrxHelperBase;
import Ice.Util;
import IceInternal.Endpoint;
import IceInternal.LocatorTable;
import IceInternal.Reference;

public final class LocatorInfo {
    private final LocatorPrx _locator;
    private LocatorRegistryPrx _locatorRegistry;
    private final LocatorTable _table;
    static final /* synthetic */ boolean $assertionsDisabled;

    LocatorInfo(LocatorPrx locator, LocatorTable table) {
        this._locator = locator;
        this._table = table;
    }

    public synchronized void destroy() {
        this._locatorRegistry = null;
        this._table.clear();
    }

    public boolean equals(Object obj) {
        LocatorInfo rhs = null;
        try {
            rhs = (LocatorInfo)obj;
        }
        catch (ClassCastException ex) {
            return false;
        }
        return this._locator.equals(rhs._locator);
    }

    public LocatorPrx getLocator() {
        return this._locator;
    }

    public synchronized LocatorRegistryPrx getLocatorRegistry() {
        if (this._locatorRegistry == null) {
            this._locatorRegistry = this._locator.getRegistry();
            this._locatorRegistry = LocatorRegistryPrxHelper.uncheckedCast(this._locatorRegistry.ice_locator(null));
        }
        return this._locatorRegistry;
    }

    public Endpoint[] getEndpoints(Reference ref, BooleanHolder cached) {
        Endpoint[] endpoints;
        block21: {
            if (!$assertionsDisabled && ref.endpoints.length != 0) {
                throw new AssertionError();
            }
            endpoints = null;
            ObjectPrx object = null;
            cached.value = true;
            try {
                if (ref.adapterId.length() > 0) {
                    endpoints = this._table.getAdapterEndpoints(ref.adapterId);
                    if (endpoints == null) {
                        cached.value = false;
                        object = this._locator.findAdapterById(ref.adapterId);
                        if (object != null && (endpoints = ((ObjectPrxHelperBase)object).__reference().endpoints) != null && endpoints.length > 0) {
                            this._table.addAdapterEndpoints(ref.adapterId, endpoints);
                        }
                    }
                } else {
                    object = this._table.getProxy(ref.identity);
                    if (object == null) {
                        cached.value = false;
                        object = this._locator.findObjectById(ref.identity);
                    }
                    if (object != null) {
                        if (((ObjectPrxHelperBase)object).__reference().endpoints.length > 0) {
                            endpoints = ((ObjectPrxHelperBase)object).__reference().endpoints;
                        } else if (((ObjectPrxHelperBase)object).__reference().adapterId.length() > 0) {
                            endpoints = this.getEndpoints(((ObjectPrxHelperBase)object).__reference(), cached);
                        }
                    }
                    if (!cached.value && endpoints != null && endpoints.length > 0) {
                        this._table.addProxy(ref.identity, object);
                    }
                }
            }
            catch (AdapterNotFoundException ex) {
                NotRegisteredException e = new NotRegisteredException();
                e.kindOfObject = "object adapter";
                e.id = ref.adapterId;
                throw e;
            }
            catch (ObjectNotFoundException ex) {
                NotRegisteredException e = new NotRegisteredException();
                e.kindOfObject = "object";
                e.id = Util.identityToString(ref.identity);
                throw e;
            }
            catch (NotRegisteredException ex) {
                throw ex;
            }
            catch (LocalException ex) {
                if (ref.instance.traceLevels().location < 1) break block21;
                StringBuffer s = new StringBuffer();
                s.append("couldn't contact the locator to retrieve adapter endpoints\n");
                if (ref.adapterId.length() > 0) {
                    s.append("adapter = " + ref.adapterId + "\n");
                } else {
                    s.append("object = " + Util.identityToString(ref.identity) + "\n");
                }
                s.append("reason = " + ex);
                ref.instance.logger().trace(ref.instance.traceLevels().locationCat, s.toString());
            }
        }
        if (ref.instance.traceLevels().location >= 1 && endpoints != null && endpoints.length > 0) {
            if (cached.value) {
                this.trace("found endpoints in locator table", ref, endpoints);
            } else {
                this.trace("retrieved endpoints from locator, adding to locator table", ref, endpoints);
            }
        }
        return endpoints == null ? new Endpoint[]{} : endpoints;
    }

    public void clearObjectCache(Reference ref) {
        ObjectPrx object;
        if (ref.adapterId.length() == 0 && ref.endpoints.length == 0 && (object = this._table.removeProxy(ref.identity)) != null && ref.instance.traceLevels().location >= 2) {
            Reference r = ((ObjectPrxHelperBase)object).__reference();
            if (r.endpoints.length > 0) {
                this.trace("removed endpoints from locator table", ref, r.endpoints);
            }
        }
    }

    public void clearCache(Reference ref) {
        ObjectPrx object;
        if (ref.adapterId.length() > 0) {
            Endpoint[] endpoints = this._table.removeAdapterEndpoints(ref.adapterId);
            if (endpoints != null && ref.instance.traceLevels().location >= 2) {
                this.trace("removed endpoints from locator table\n", ref, endpoints);
            }
        } else if (ref.endpoints.length == 0 && (object = this._table.removeProxy(ref.identity)) != null) {
            Reference r = ((ObjectPrxHelperBase)object).__reference();
            if (r.adapterId.length() > 0) {
                this.clearCache(r);
            } else if (r.endpoints.length > 0 && ref.instance.traceLevels().location >= 2) {
                this.trace("removed endpoints from locator table", ref, r.endpoints);
            }
        }
    }

    private void trace(String msg, Reference ref, Endpoint[] endpoints) {
        StringBuffer s = new StringBuffer();
        s.append(msg + "\n");
        if (ref.adapterId.length() > 0) {
            s.append("adapter = " + ref.adapterId + "\n");
        } else {
            s.append("object = " + Util.identityToString(ref.identity) + "\n");
        }
        s.append("endpoints = ");
        int sz = endpoints.length;
        for (int i = 0; i < sz; ++i) {
            s.append(((Object)endpoints[i]).toString());
            if (i + 1 >= sz) continue;
            s.append(":");
        }
        ref.instance.logger().trace(ref.instance.traceLevels().locationCat, s.toString());
    }

    static {
        $assertionsDisabled = !LocatorInfo.class.desiredAssertionStatus();
    }
}

