/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.AlreadyRegisteredException;
import Ice.NotRegisteredException;
import Ice.ObjectFactory;
import java.util.HashMap;
import java.util.Iterator;

public final class ObjectFactoryManager {
    private HashMap _factoryMap = new HashMap();

    public synchronized void add(ObjectFactory factory, String id) {
        Object o = this._factoryMap.get(id);
        if (o != null) {
            AlreadyRegisteredException ex = new AlreadyRegisteredException();
            ex.id = id;
            ex.kindOfObject = "object factory";
            throw ex;
        }
        this._factoryMap.put(id, factory);
    }

    public synchronized void remove(String id) {
        Object o = this._factoryMap.get(id);
        if (o == null) {
            NotRegisteredException ex = new NotRegisteredException();
            ex.id = id;
            ex.kindOfObject = "object factory";
            throw ex;
        }
        ((ObjectFactory)o).destroy();
        this._factoryMap.remove(id);
    }

    public synchronized ObjectFactory find(String id) {
        return (ObjectFactory)this._factoryMap.get(id);
    }

    ObjectFactoryManager() {
    }

    synchronized void destroy() {
        Iterator i = this._factoryMap.values().iterator();
        while (i.hasNext()) {
            ObjectFactory factory = (ObjectFactory)i.next();
            factory.destroy();
        }
        this._factoryMap.clear();
    }
}

