/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.DatagramLimitException;
import Ice.LocalException;
import Ice.Logger;
import Ice.SocketException;
import Ice.Stats;
import IceInternal.BasicStream;
import IceInternal.Instance;
import IceInternal.Network;
import IceInternal.TraceLevels;
import IceInternal.Transceiver;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectableChannel;

final class UdpTransceiver
implements Transceiver {
    private TraceLevels _traceLevels;
    private Logger _logger;
    private Stats _stats;
    private boolean _incoming;
    private boolean _connect;
    private final boolean _warn;
    private int _rcvSize;
    private int _sndSize;
    private DatagramChannel _fd;
    private InetSocketAddress _addr;
    private static final int _udpOverhead = 28;
    private static final int _maxPacketSize = 65507;
    static final /* synthetic */ boolean $assertionsDisabled;

    public SelectableChannel fd() {
        if (!$assertionsDisabled && this._fd == null) {
            throw new AssertionError();
        }
        return this._fd;
    }

    public void close() {
        if (this._traceLevels.network >= 1) {
            String s = "closing udp connection\n" + this.toString();
            this._logger.trace(this._traceLevels.networkCat, s);
        }
        if (!$assertionsDisabled && this._fd == null) {
            throw new AssertionError();
        }
        try {
            this._fd.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this._fd = null;
    }

    public void shutdown() {
    }

    public void write(BasicStream stream, int timeout) {
        ByteBuffer buf = stream.prepareWrite();
        if (!$assertionsDisabled && buf.position() != 0) {
            throw new AssertionError();
        }
        int packetSize = Math.min(65507, this._sndSize - 28);
        if (packetSize < buf.limit()) {
            throw new DatagramLimitException();
        }
        while (buf.hasRemaining()) {
            try {
                if (!$assertionsDisabled && this._fd == null) {
                    throw new AssertionError();
                }
                int ret = this._fd.write(buf);
                if (this._traceLevels.network >= 3) {
                    String s = "sent " + ret + " bytes via udp\n" + this.toString();
                    this._logger.trace(this._traceLevels.networkCat, s);
                }
                if (this._stats != null) {
                    this._stats.bytesSent("udp", ret);
                }
                if (!$assertionsDisabled && ret != buf.limit()) {
                    throw new AssertionError();
                }
                break;
            }
            catch (InterruptedIOException ex) {
            }
            catch (IOException ex) {
                SocketException se = new SocketException();
                se.initCause(ex);
                throw se;
            }
        }
    }

    public void read(BasicStream stream, int timeout) {
        if (!$assertionsDisabled && stream.pos() != 0) {
            throw new AssertionError();
        }
        int packetSize = Math.min(65507, this._rcvSize - 28);
        if (packetSize < stream.size()) {
            if (this._warn) {
                this._logger.warning("DatagramLimitException: maximum size of " + packetSize + " exceeded");
            }
            throw new DatagramLimitException();
        }
        stream.resize(packetSize, true);
        ByteBuffer buf = stream.prepareRead();
        buf.position(0);
        int ret = 0;
        while (true) {
            if (this._connect) {
                try {
                    if (!$assertionsDisabled && this._fd == null) {
                        throw new AssertionError();
                    }
                    InetSocketAddress peerAddr = (InetSocketAddress)this._fd.receive(buf);
                    ret = buf.position();
                    Network.doConnect(this._fd, peerAddr, -1);
                    this._connect = false;
                    if (this._traceLevels.network < 1) break;
                    String s = "connected udp socket\n" + this.toString();
                    this._logger.trace(this._traceLevels.networkCat, s);
                    break;
                }
                catch (InterruptedIOException ex) {
                    continue;
                }
                catch (IOException ex) {
                    SocketException se = new SocketException();
                    se.initCause(ex);
                    throw se;
                }
            }
            try {
                if (!$assertionsDisabled && this._fd == null) {
                    throw new AssertionError();
                }
                this._fd.receive(buf);
                ret = buf.position();
            }
            catch (InterruptedIOException ex) {
                continue;
            }
            catch (IOException ex) {
                SocketException se = new SocketException();
                se.initCause(ex);
                throw se;
            }
            break;
        }
        if (this._traceLevels.network >= 3) {
            String s = "received " + ret + " bytes via udp\n" + this.toString();
            this._logger.trace(this._traceLevels.networkCat, s);
        }
        if (this._stats != null) {
            this._stats.bytesReceived("udp", ret);
        }
        stream.resize(ret, true);
        stream.pos(ret);
    }

    public String toString() {
        return Network.fdToString(this._fd);
    }

    public final boolean equivalent(String host, int port) {
        InetSocketAddress addr = Network.getAddress(host, port);
        return addr.equals(this._addr);
    }

    public final int effectivePort() {
        return this._addr.getPort();
    }

    UdpTransceiver(Instance instance, String host, int port) {
        this._traceLevels = instance.traceLevels();
        this._logger = instance.logger();
        this._stats = instance.stats();
        this._incoming = false;
        this._connect = true;
        this._warn = instance.properties().getPropertyAsInt("Ice.Warn.Datagrams") > 0;
        try {
            this._fd = Network.createUdpSocket();
            this.setBufSize(instance);
            Network.setBlock(this._fd, false);
            this._addr = Network.getAddress(host, port);
            Network.doConnect(this._fd, this._addr, -1);
            this._connect = false;
            if (this._traceLevels.network >= 1) {
                String s = "starting to send udp packets\n" + this.toString();
                this._logger.trace(this._traceLevels.networkCat, s);
            }
        }
        catch (LocalException ex) {
            this._fd = null;
            throw ex;
        }
    }

    UdpTransceiver(Instance instance, String host, int port, boolean connect) {
        this._traceLevels = instance.traceLevels();
        this._logger = instance.logger();
        this._stats = instance.stats();
        this._incoming = true;
        this._connect = connect;
        this._warn = instance.properties().getPropertyAsInt("Ice.Warn.Datagrams") > 0;
        try {
            String s;
            this._fd = Network.createUdpSocket();
            this.setBufSize(instance);
            Network.setBlock(this._fd, false);
            this._addr = new InetSocketAddress(host, port);
            if (this._traceLevels.network >= 2) {
                s = "attempting to bind to udp socket " + Network.addrToString(this._addr);
                this._logger.trace(this._traceLevels.networkCat, s);
            }
            this._addr = Network.doBind(this._fd, this._addr);
            if (this._traceLevels.network >= 1) {
                s = "starting to receive udp packets\n" + this.toString();
                this._logger.trace(this._traceLevels.networkCat, s);
            }
        }
        catch (LocalException ex) {
            this._fd = null;
            throw ex;
        }
    }

    private synchronized void setBufSize(Instance instance) {
        if (!$assertionsDisabled && this._fd == null) {
            throw new AssertionError();
        }
        for (int i = 0; i < 2; ++i) {
            int sizeSet;
            int messageSizeMax;
            int dfltSize;
            String prop;
            String direction;
            if (i == 0) {
                direction = "receive";
                prop = "Ice.UDP.RcvSize";
                this._rcvSize = dfltSize = Network.getRecvBufferSize(this._fd);
            } else {
                direction = "send";
                prop = "Ice.UDP.SndSize";
                this._sndSize = dfltSize = Network.getSendBufferSize(this._fd);
            }
            int sizeRequested = instance.properties().getPropertyAsIntWithDefault(prop, dfltSize);
            if (sizeRequested < 28) {
                this._logger.warning("Invalid " + prop + " value of " + sizeRequested + " adjusted to " + dfltSize);
                sizeRequested = dfltSize;
            }
            if (sizeRequested > (messageSizeMax = instance.messageSizeMax()) + 28) {
                int newSize = Math.min(messageSizeMax, 65507) + 28;
                this._logger.warning("UDP " + direction + " buffer size: request size of " + sizeRequested + " adjusted to " + newSize + " (Ice.MessageSizeMax takes precendence)");
                sizeRequested = newSize;
            }
            if (sizeRequested == dfltSize) continue;
            if (i == 0) {
                Network.setRecvBufferSize(this._fd, sizeRequested);
                sizeSet = this._rcvSize = Network.getRecvBufferSize(this._fd);
            } else {
                Network.setSendBufferSize(this._fd, sizeRequested);
                sizeSet = this._sndSize = Network.getSendBufferSize(this._fd);
            }
            if (sizeSet >= sizeRequested) continue;
            this._logger.warning("UDP " + direction + " buffer size: requested size of " + sizeRequested + " adjusted to " + sizeSet);
        }
    }

    protected void finalize() throws Throwable {
        if (!$assertionsDisabled && this._fd != null) {
            throw new AssertionError();
        }
        super.finalize();
    }

    static {
        $assertionsDisabled = !UdpTransceiver.class.desiredAssertionStatus();
    }
}

