/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.SelectionListenerAction;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.ProjectLocationSelectionDialog;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.progress.ProgressMonitorJobsDialog;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class CopyProjectAction
extends SelectionListenerAction {
    private static String COPY_TOOL_TIP = IDEWorkbenchMessages.getString("CopyProjectAction.toolTip");
    private static String COPY_TITLE = IDEWorkbenchMessages.getString("CopyProjectAction.title");
    private static String COPY_PROGRESS_TITLE = IDEWorkbenchMessages.getString("CopyProjectAction.progressTitle");
    private static String PROBLEMS_TITLE = IDEWorkbenchMessages.getString("CopyProjectAction.copyFailedTitle");
    public static final String ID = "org.eclipse.ui.CopyProjectAction";
    protected Shell shell;
    protected IStatus errorStatus;

    public CopyProjectAction(Shell shell) {
        this(shell, COPY_TITLE);
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.ui.ide.copy_project_action_context");
    }

    CopyProjectAction(Shell shell, String name) {
        super(name);
        this.setToolTipText(COPY_TOOL_TIP);
        this.setId(ID);
        if (shell == null) {
            throw new IllegalArgumentException();
        }
        this.shell = shell;
    }

    protected IProjectDescription createDescription(IProject project, String projectName, IPath rootLocation) throws CoreException {
        IProjectDescription newDescription = project.getDescription();
        newDescription.setName(projectName);
        if (rootLocation.equals((Object)Platform.getLocation())) {
            newDescription.setLocation(null);
        } else {
            newDescription.setLocation(rootLocation);
        }
        return newDescription;
    }

    void displayError(String message) {
        MessageDialog.openError((Shell)this.shell, (String)this.getErrorsTitle(), (String)message);
    }

    protected String getErrorsTitle() {
        return PROBLEMS_TITLE;
    }

    protected AbstractUIPlugin getPlugin() {
        return (AbstractUIPlugin)Platform.getPlugin((String)"org.eclipse.ui");
    }

    boolean performCopy(final IProject project, final String projectName, final IPath newLocation) {
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void execute(IProgressMonitor monitor) {
                monitor.beginTask(COPY_PROGRESS_TITLE, 100);
                try {
                    try {
                        if (monitor.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                        IProjectDescription newDescription = CopyProjectAction.this.createDescription(project, projectName, newLocation);
                        monitor.worked(50);
                        project.copy(newDescription, 33, monitor);
                        monitor.worked(50);
                    }
                    catch (CoreException e) {
                        CopyProjectAction.this.recordError(e);
                    }
                }
                catch (Throwable throwable) {
                    Object var3_5 = null;
                    monitor.done();
                    throw throwable;
                }
                {
                    Object var3_6 = null;
                }
                monitor.done();
            }
        };
        try {
            new ProgressMonitorJobsDialog(this.shell).run(true, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            this.displayError(IDEWorkbenchMessages.format("CopyProjectAction.internalError", new Object[]{e.getTargetException().getMessage()}));
            return false;
        }
        return true;
    }

    protected Object[] queryDestinationParameters(IProject project) {
        ProjectLocationSelectionDialog dialog = new ProjectLocationSelectionDialog(this.shell, project);
        dialog.setTitle(IDEWorkbenchMessages.getString("CopyProjectAction.copyTitle"));
        dialog.open();
        return dialog.getResult();
    }

    final void recordError(CoreException error) {
        this.errorStatus = error.getStatus();
    }

    public void run() {
        this.errorStatus = null;
        IProject project = (IProject)this.getSelectedResources().get(0);
        Object[] destinationPaths = this.queryDestinationParameters(project);
        if (destinationPaths == null) {
            return;
        }
        String newName = (String)destinationPaths[0];
        Path newLocation = new Path((String)destinationPaths[1]);
        boolean completed = this.performCopy(project, newName, (IPath)newLocation);
        if (!completed) {
            return;
        }
        if (this.errorStatus != null) {
            ErrorDialog.openError((Shell)this.shell, (String)this.getErrorsTitle(), null, (IStatus)this.errorStatus);
            this.errorStatus = null;
        }
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        if (!super.updateSelection(selection)) {
            return false;
        }
        if (this.getSelectedNonResources().size() > 0) {
            return false;
        }
        List selectedResources = this.getSelectedResources();
        if (selectedResources.size() != 1) {
            return false;
        }
        IResource source = (IResource)selectedResources.get(0);
        return source instanceof IProject && ((IProject)source).isOpen();
    }
}

