/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.SelectionListenerAction;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.StatusUtil;
import org.eclipse.ui.internal.progress.ProgressMonitorJobsDialog;

public abstract class WorkspaceAction
extends SelectionListenerAction {
    private MultiStatus errorStatus;
    private Shell shell;

    protected WorkspaceAction(Shell shell, String text) {
        super(text);
        if (shell == null) {
            throw new IllegalArgumentException();
        }
        this.shell = shell;
    }

    void displayError(String message) {
        if (message == null) {
            message = IDEWorkbenchMessages.getString("WorkbenchAction.internalError");
        }
        MessageDialog.openError((Shell)this.shell, (String)this.getProblemsTitle(), (String)message);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final void execute(IProgressMonitor monitor) {
        List resources = this.getActionResources();
        if (this.shouldPerformResourcePruning()) {
            resources = this.pruneResources(resources);
        }
        Iterator resourcesEnum = resources.iterator();
        monitor.beginTask("", resources.size() * 1000);
        monitor.setTaskName(this.getOperationMessage());
        try {
            while (resourcesEnum.hasNext()) {
                IResource resource = (IResource)resourcesEnum.next();
                try {
                    this.invokeOperation(resource, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
                }
                catch (CoreException e) {
                    this.recordError(e);
                }
                if (!monitor.isCanceled()) continue;
                throw new OperationCanceledException();
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        monitor.done();
    }

    abstract String getOperationMessage();

    String getProblemsMessage() {
        return IDEWorkbenchMessages.getString("WorkbenchAction.problemsMessage");
    }

    String getProblemsTitle() {
        return IDEWorkbenchMessages.getString("WorkspaceAction.problemsTitle");
    }

    Shell getShell() {
        return this.shell;
    }

    abstract void invokeOperation(IResource var1, IProgressMonitor var2) throws CoreException;

    boolean isAccessible(IResource resource) {
        switch (resource.getType()) {
            case 1: {
                return true;
            }
            case 2: {
                return true;
            }
            case 4: {
                return ((IProject)resource).isOpen();
            }
        }
        return false;
    }

    boolean isDescendent(List resources, IResource child) {
        IContainer parent = child.getParent();
        return parent != null && (resources.contains(parent) || this.isDescendent(resources, (IResource)parent));
    }

    List pruneResources(List resourceCollection) {
        ArrayList prunedList = new ArrayList(resourceCollection);
        Iterator elementsEnum = prunedList.iterator();
        while (elementsEnum.hasNext()) {
            IResource currentResource = (IResource)elementsEnum.next();
            if (!this.isDescendent(prunedList, currentResource)) continue;
            elementsEnum.remove();
        }
        return prunedList;
    }

    private void recordError(CoreException error) {
        if (this.errorStatus == null) {
            this.errorStatus = new MultiStatus("org.eclipse.ui.ide", 4, this.getProblemsMessage(), (Throwable)error);
        }
        this.errorStatus.merge(error.getStatus());
    }

    public void run() {
        try {
            WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

                public void execute(IProgressMonitor monitor) {
                    WorkspaceAction.this.execute(monitor);
                }
            };
            new ProgressMonitorJobsDialog(this.shell).run(true, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        catch (InvocationTargetException e) {
            String msg = IDEWorkbenchMessages.format("WorkspaceAction.logTitle", new Object[]{((Object)((Object)this)).getClass().getName(), e.getTargetException()});
            IDEWorkbenchPlugin.log(msg, StatusUtil.newStatus(4, msg, e.getTargetException()));
            this.displayError(e.getTargetException().getMessage());
        }
        if (this.errorStatus != null) {
            ErrorDialog.openError((Shell)this.shell, (String)this.getProblemsTitle(), null, (IStatus)this.errorStatus);
        }
        this.errorStatus = null;
    }

    boolean shouldPerformResourcePruning() {
        return true;
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        if (!super.updateSelection(selection) || selection.isEmpty()) {
            return false;
        }
        Iterator i = this.getSelectedResources().iterator();
        while (i.hasNext()) {
            IResource r = (IResource)i.next();
            if (this.isAccessible(r)) continue;
            return false;
        }
        return true;
    }

    protected List getActionResources() {
        return this.getSelectedResources();
    }

    public void runInBackground(ISchedulingRule rule) {
        Job backgroundJob = new Job(Action.removeMnemonics((String)this.getText())){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask("", 1);
                monitor.setTaskName(WorkspaceAction.this.getOperationMessage());
                WorkspaceAction.this.execute(monitor);
                monitor.done();
                IStatus returnStatus = Status.OK_STATUS;
                if (WorkspaceAction.this.errorStatus != null) {
                    returnStatus = WorkspaceAction.this.errorStatus;
                    WorkspaceAction.this.errorStatus = null;
                }
                return returnStatus;
            }
        };
        if (rule != null) {
            backgroundJob.setRule(rule);
        }
        backgroundJob.setUser(true);
        backgroundJob.schedule();
    }
}

