/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.ide.dialogs;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.WorkbenchEncoding;
import org.eclipse.ui.ide.IDEEncoding;
import org.eclipse.ui.ide.dialogs.AbstractEncodingFieldEditor;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.misc.Assert;

public class ResourceEncodingFieldEditor
extends AbstractEncodingFieldEditor {
    private IResource resource;

    public ResourceEncodingFieldEditor(String labelText, Composite parent, IResource charsetResource) {
        this.setLabelText(labelText);
        Assert.isTrue((charsetResource instanceof IContainer || charsetResource instanceof IFile ? 1 : 0) != 0);
        this.resource = charsetResource;
        this.createControl(parent);
    }

    protected String getStoredValue() {
        try {
            if (this.resource instanceof IContainer) {
                return ((IContainer)this.resource).getDefaultCharset();
            }
            return ((IFile)this.resource).getCharset();
        }
        catch (CoreException e) {
            WorkbenchPlugin.log((String)IDEWorkbenchMessages.getString("ResourceEncodingFieldEditor.ErrorLoadingMessage"), (IStatus)e.getStatus());
            return WorkbenchEncoding.getWorkbenchDefaultEncoding();
        }
    }

    protected void doStore() {
        MessageDialog dialog;
        String encoding = this.getSelectedEncoding();
        if (this.hasSameEncoding(encoding)) {
            return;
        }
        String descriptionCharset = this.getCharsetFromDescription();
        if (descriptionCharset != null && !descriptionCharset.equals(encoding) && (dialog = new MessageDialog(this.getPage().getShell(), IDEWorkbenchMessages.getString("ResourceEncodingFieldEditor.EncodingConflictTitle"), null, IDEWorkbenchMessages.format("ResourceEncodingFieldEditor.EncodingConflictMessage", new String[]{encoding, descriptionCharset}), 4, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0)).open() > 0) {
            return;
        }
        if (encoding.equals(this.getDefaultEnc())) {
            encoding = null;
        } else {
            IDEEncoding.addIDEEncoding(encoding);
        }
        final String finalEncoding = encoding;
        Job charsetJob = new Job(IDEWorkbenchMessages.getString("IDEEncoding.EncodingJob")){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    if (ResourceEncodingFieldEditor.this.resource instanceof IContainer) {
                        ((IContainer)ResourceEncodingFieldEditor.this.resource).setDefaultCharset(finalEncoding, monitor);
                    } else {
                        ((IFile)ResourceEncodingFieldEditor.this.resource).setCharset(finalEncoding, monitor);
                    }
                    return Status.OK_STATUS;
                }
                catch (CoreException e) {
                    WorkbenchPlugin.log((String)IDEWorkbenchMessages.getString("ResourceEncodingFieldEditor.ErrorStoringMessage"), (IStatus)e.getStatus());
                    return e.getStatus();
                }
            }
        };
        charsetJob.schedule();
    }

    public void store() {
        this.doStore();
    }

    public void load() {
        this.setPresentsDefaultValue(false);
        this.doLoad();
    }

    public void loadDefault() {
        this.setPresentsDefaultValue(true);
        this.doLoadDefault();
        this.refreshValidState();
    }

    protected String findDefaultEncoding() {
        if (this.resource instanceof IWorkspaceRoot) {
            return super.findDefaultEncoding();
        }
        String defaultCharset = this.getCharsetFromDescription();
        defaultCharset = this.getCharsetFromDescription();
        if (defaultCharset != null && defaultCharset.length() > 0) {
            return defaultCharset;
        }
        try {
            defaultCharset = this.resource.getParent().getDefaultCharset(true);
        }
        catch (CoreException coreException) {}
        if (defaultCharset != null && defaultCharset.length() > 0) {
            return defaultCharset;
        }
        return super.findDefaultEncoding();
    }

    private String getCharsetFromDescription() {
        IContentDescription description = this.getContentDescription();
        if (description != null) {
            return description.getCharset();
        }
        return null;
    }

    protected String defaultButtonText() {
        if (this.resource instanceof IWorkspaceRoot) {
            return super.defaultButtonText();
        }
        if (this.resource instanceof IFile) {
            try {
                IContentDescription description = ((IFile)this.resource).getContentDescription();
                if (description == null || description.getCharset() == null) {
                    return IDEWorkbenchMessages.format("ResourceInfo.fileContainerEncodingFormat", new String[]{this.getDefaultEnc()});
                }
                return IDEWorkbenchMessages.format("ResourceInfo.fileContentEncodingFormat", new String[]{this.getDefaultEnc()});
            }
            catch (CoreException coreException) {}
        }
        return IDEWorkbenchMessages.format("ResourceInfo.containerEncodingFormat", new String[]{this.getDefaultEnc()});
    }

    protected Group createEncodingGroup(Composite parent, int numColumns) {
        Group group = super.createEncodingGroup(parent, numColumns);
        String byteOrderLabel = IDEEncoding.getByteOrderMarkLabel(this.getContentDescription());
        if (byteOrderLabel != null) {
            Label label = new Label((Composite)group, 0);
            label.setText(IDEWorkbenchMessages.format("WorkbenchPreference.encoding.encodingMessage", new String[]{byteOrderLabel}));
            GridData layoutData = new GridData();
            layoutData.horizontalSpan = numColumns + 1;
            label.setLayoutData((Object)layoutData);
        }
        return group;
    }

    private IContentDescription getContentDescription() {
        try {
            if (this.resource instanceof IFile) {
                return ((IFile)this.resource).getContentDescription();
            }
        }
        catch (CoreException coreException) {}
        return null;
    }
}

