/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.IActivityManager;
import org.eclipse.ui.activities.IIdentifier;
import org.eclipse.ui.activities.IWorkbenchActivitySupport;
import org.eclipse.ui.activities.WorkbenchActivityHelper;

public class IDEWorkbenchActivityHelper {
    private IResourceChangeListener listener;
    private Map natureMap = new HashMap();
    private static IDEWorkbenchActivityHelper singleton;

    public static IDEWorkbenchActivityHelper getInstance() {
        if (singleton == null) {
            singleton = new IDEWorkbenchActivityHelper();
        }
        return singleton;
    }

    private IDEWorkbenchActivityHelper() {
        Platform.getExtensionRegistry().addRegistryChangeListener(new IRegistryChangeListener(){

            public void registryChanged(IRegistryChangeEvent event) {
                if (event.getExtensionDeltas("org.eclipse.core.resources", "natures").length > 0) {
                    IDEWorkbenchActivityHelper.this.loadNatures();
                }
            }
        }, "org.eclipse.core.resources");
        this.loadNatures();
        this.listener = this.getChangeListener();
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.listener);
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        IWorkbenchActivitySupport workbenchActivitySupport = PlatformUI.getWorkbench().getActivitySupport();
        int i = 0;
        while (i < projects.length) {
            try {
                this.processProject(projects[i], workbenchActivitySupport);
            }
            catch (CoreException coreException) {}
            ++i;
        }
    }

    public void loadNatures() {
        this.natureMap.clear();
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.core.resources.natures");
        IExtension[] extensions = point.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IExtension extension = extensions[i];
            final String localId = extension.getSimpleIdentifier();
            final String pluginId = extension.getNamespace();
            String natureId = extension.getUniqueIdentifier();
            this.natureMap.put(natureId, new IPluginContribution(){

                public String getLocalId() {
                    return localId;
                }

                public String getPluginId() {
                    return pluginId;
                }
            });
            ++i;
        }
    }

    private IResourceChangeListener getChangeListener() {
        return new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                if (!WorkbenchActivityHelper.isFiltering()) {
                    return;
                }
                IResourceDelta mainDelta = event.getDelta();
                if (mainDelta == null) {
                    return;
                }
                if (mainDelta.getKind() == 4 && mainDelta.getResource().getType() == 8) {
                    try {
                        IResourceDelta[] children = mainDelta.getAffectedChildren();
                        IWorkbenchActivitySupport workbenchActivitySupport = PlatformUI.getWorkbench().getActivitySupport();
                        int i = 0;
                        while (i < children.length) {
                            IResourceDelta delta = children[i];
                            if (delta.getResource().getType() == 4) {
                                IProject project = (IProject)delta.getResource();
                                IDEWorkbenchActivityHelper.this.processProject(project, workbenchActivitySupport);
                            }
                            ++i;
                        }
                    }
                    catch (CoreException coreException) {}
                }
            }
        };
    }

    protected void processProject(IProject project, IWorkbenchActivitySupport workbenchActivitySupport) throws CoreException {
        if (!project.isOpen()) {
            return;
        }
        IActivityManager activityManager = workbenchActivitySupport.getActivityManager();
        String[] ids = project.getDescription().getNatureIds();
        if (ids.length == 0) {
            return;
        }
        HashSet activities = new HashSet(activityManager.getEnabledActivityIds());
        boolean changed = false;
        int j = 0;
        while (j < ids.length) {
            IIdentifier identifier;
            IPluginContribution contribution = (IPluginContribution)this.natureMap.get(ids[j]);
            if (contribution != null && activities.addAll((identifier = activityManager.getIdentifier(WorkbenchActivityHelper.createUnifiedId((IPluginContribution)contribution))).getActivityIds())) {
                changed = true;
            }
            ++j;
        }
        if (changed) {
            workbenchActivitySupport.setEnabledActivityIds(activities);
        }
    }

    public void shutdown() {
        if (this.listener != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.listener);
        }
    }
}

