/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.dialogs;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.GlobalBuildAction;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class CleanDialog
extends MessageDialog {
    private Button allButton;
    private Button selectedButton;
    private Button buildNowButton;
    private Text projectName;
    private Object[] selection;
    private IWorkbenchWindow window;

    private static String getQuestion() {
        boolean autoBuilding = ResourcesPlugin.getWorkspace().isAutoBuilding();
        if (autoBuilding) {
            return IDEWorkbenchMessages.getString("CleanDialog.buildCleanAuto");
        }
        return IDEWorkbenchMessages.getString("CleanDialog.buildCleanManual");
    }

    public CleanDialog(IWorkbenchWindow window, IProject[] selection) {
        super(window.getShell(), IDEWorkbenchMessages.getString("CleanDialog.title"), null, CleanDialog.getQuestion(), 3, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
        this.window = window;
        this.selection = selection;
        if (this.selection == null) {
            this.selection = new Object[0];
        }
    }

    protected void browsePressed() {
        WorkbenchLabelProvider labelProvider = new WorkbenchLabelProvider();
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
        dialog.setMultipleSelection(true);
        dialog.setTitle("Project Selection");
        dialog.setMessage("Chose projects to clean:");
        dialog.setElements((Object[])ResourcesPlugin.getWorkspace().getRoot().getProjects());
        dialog.setInitialSelections(new Object[]{this.selection});
        if (dialog.open() == 0) {
            this.selection = dialog.getResult();
            if (this.selection == null) {
                this.selection = new Object[0];
            }
        }
        this.setProjectName();
        this.updateEnablement();
    }

    protected void buttonPressed(int buttonId) {
        final boolean cleanAll = this.allButton.getSelection();
        boolean buildAll = this.buildNowButton != null && this.buildNowButton.getSelection();
        super.buttonPressed(buttonId);
        if (buttonId == 0) {
            try {
                PlatformUI.getWorkbench().getProgressService().busyCursorWhile((IRunnableWithProgress)new WorkspaceModifyOperation(){

                    protected void execute(IProgressMonitor monitor) throws CoreException {
                        CleanDialog.this.doClean(cleanAll, monitor);
                    }
                });
                if (buildAll) {
                    GlobalBuildAction build = new GlobalBuildAction(this.window, 10);
                    build.run();
                }
            }
            catch (InvocationTargetException e) {
                Throwable target = e.getTargetException();
                if (target instanceof CoreException) {
                    ErrorDialog.openError((Shell)this.getShell(), null, null, (IStatus)((CoreException)target).getStatus());
                }
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        if (!ResourcesPlugin.getWorkspace().isAutoBuilding()) {
            GridLayout layout = (GridLayout)parent.getLayout();
            layout.numColumns += 2;
            layout.makeColumnsEqualWidth = false;
            this.buildNowButton = new Button(parent, 32);
            this.buildNowButton.setText(IDEWorkbenchMessages.getString("CleanDialog.buildNowButton"));
            this.buildNowButton.setSelection(true);
            this.buildNowButton.setLayoutData((Object)new GridData(32));
            Label spacer = new Label(parent, 0);
            GridData data = new GridData();
            data.horizontalAlignment = 4;
            data.widthHint = 200;
            spacer.setLayoutData((Object)data);
        }
        super.createButtonsForButtonBar(parent);
    }

    protected Control createCustomArea(Composite parent) {
        Composite radioGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 3;
        radioGroup.setLayout((Layout)layout);
        radioGroup.setLayoutData((Object)new GridData(1808));
        SelectionAdapter updateEnablement = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CleanDialog.this.updateEnablement();
            }
        };
        this.allButton = new Button(radioGroup, 16);
        this.allButton.setText(IDEWorkbenchMessages.getString("CleanDialog.cleanAllButton"));
        this.allButton.setSelection(true);
        this.allButton.addSelectionListener((SelectionListener)updateEnablement);
        new Label(radioGroup, 0);
        new Label(radioGroup, 0);
        this.selectedButton = new Button(radioGroup, 16);
        this.selectedButton.setText(IDEWorkbenchMessages.getString("CleanDialog.cleanSelectedButton"));
        this.selectedButton.addSelectionListener((SelectionListener)updateEnablement);
        this.projectName = new Text(radioGroup, 2056);
        GridData data = new GridData(768);
        data.widthHint = 200;
        this.projectName.setLayoutData((Object)data);
        this.setProjectName();
        Button browse = new Button(radioGroup, 8);
        browse.setText(IDEWorkbenchMessages.getString("CleanDialog.browse"));
        this.setButtonLayoutData(browse);
        browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CleanDialog.this.browsePressed();
            }
        });
        return radioGroup;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doClean(boolean cleanAll, IProgressMonitor monitor) throws CoreException {
        if (cleanAll) {
            ResourcesPlugin.getWorkspace().build(15, monitor);
            return;
        }
        try {
            monitor.beginTask(IDEWorkbenchMessages.getString("CleanDialog.taskName"), this.selection.length);
            int i = 0;
            while (i < this.selection.length) {
                ((IProject)this.selection[i]).build(15, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        monitor.done();
    }

    private void setProjectName() {
        if (this.selection.length == 0) {
            this.projectName.setText(IDEWorkbenchMessages.getString("CleanDialog.noSelection"));
        } else {
            StringBuffer names = new StringBuffer(((IProject)this.selection[0]).getName());
            int i = 1;
            while (i < this.selection.length) {
                names.append(',');
                names.append(((IProject)this.selection[i]).getName());
                ++i;
            }
            this.projectName.setText(names.toString());
        }
    }

    protected void updateEnablement() {
        boolean enabled = this.allButton.getSelection() || this.selection.length > 0;
        this.getButton(0).setEnabled(enabled);
    }
}

