/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.wizards.datatransfer;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ui.internal.wizards.datatransfer.TarEntry;
import org.eclipse.ui.internal.wizards.datatransfer.TarException;
import org.eclipse.ui.internal.wizards.datatransfer.TarFile;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;

public class TarFileStructureProvider
implements IImportStructureProvider {
    private TarFile tarFile;
    private TarEntry root = new TarEntry("/");
    private Map children;
    private Map directoryEntryCache = new HashMap();

    public TarFileStructureProvider(TarFile sourceFile) {
        this.tarFile = sourceFile;
        this.root.setFileType(53);
    }

    protected void addToChildren(TarEntry parent, TarEntry child) {
        ArrayList<TarEntry> childList = (ArrayList<TarEntry>)this.children.get(parent);
        if (childList == null) {
            childList = new ArrayList<TarEntry>();
            this.children.put(parent, childList);
        }
        childList.add(child);
    }

    protected void createContainer(IPath pathname) {
        if (this.directoryEntryCache.containsKey(pathname)) {
            return;
        }
        TarEntry parent = pathname.segmentCount() == 1 ? this.root : (TarEntry)this.directoryEntryCache.get(pathname.removeLastSegments(1));
        TarEntry newEntry = new TarEntry(pathname.toString());
        newEntry.setFileType(53);
        this.directoryEntryCache.put(pathname, newEntry);
        this.addToChildren(parent, newEntry);
    }

    protected void createFile(TarEntry entry) {
        Path pathname = new Path(entry.getName());
        TarEntry parent = pathname.segmentCount() == 1 ? this.root : (TarEntry)this.directoryEntryCache.get(pathname.removeLastSegments(1));
        this.addToChildren(parent, entry);
    }

    public List getChildren(Object element) {
        if (this.children == null) {
            this.initialize();
        }
        return (List)this.children.get(element);
    }

    public InputStream getContents(Object element) {
        try {
            return this.tarFile.getInputStream((TarEntry)element);
        }
        catch (TarException tarException) {
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public String getFullPath(Object element) {
        return ((TarEntry)element).getName();
    }

    public String getLabel(Object element) {
        if (element.equals(this.root)) {
            return ((TarEntry)element).getName();
        }
        return new Path(((TarEntry)element).getName()).lastSegment();
    }

    public TarEntry getRoot() {
        return this.root;
    }

    public TarFile getTarFile() {
        return this.tarFile;
    }

    protected void initialize() {
        this.children = new HashMap(1000);
        Enumeration entries = this.tarFile.entries();
        while (entries.hasMoreElements()) {
            TarEntry entry = (TarEntry)entries.nextElement();
            if (entry.getFileType() != 48) continue;
            IPath path = new Path(entry.getName()).addTrailingSeparator();
            int pathSegmentCount = path.segmentCount();
            int i = 1;
            while (i < pathSegmentCount) {
                this.createContainer(path.uptoSegment(i));
                ++i;
            }
            this.createFile(entry);
        }
    }

    public boolean isFolder(Object element) {
        return ((TarEntry)element).getFileType() == 53;
    }
}

