/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.SelectionProviderAction;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.MarkerTransfer;
import org.eclipse.ui.progress.WorkbenchJob;
import org.eclipse.ui.views.markers.internal.ActionCopyMarker;
import org.eclipse.ui.views.markers.internal.ActionMarkerProperties;
import org.eclipse.ui.views.markers.internal.ActionOpenMarker;
import org.eclipse.ui.views.markers.internal.ActionPasteMarker;
import org.eclipse.ui.views.markers.internal.ActionRemoveMarker;
import org.eclipse.ui.views.markers.internal.ActionRevealMarker;
import org.eclipse.ui.views.markers.internal.ActionSelectAll;
import org.eclipse.ui.views.markers.internal.ConcreteMarker;
import org.eclipse.ui.views.markers.internal.DefaultMarkerResourceAdapter;
import org.eclipse.ui.views.markers.internal.FiltersAction;
import org.eclipse.ui.views.markers.internal.MarkerFilter;
import org.eclipse.ui.views.markers.internal.MarkerList;
import org.eclipse.ui.views.markers.internal.Messages;
import org.eclipse.ui.views.markers.internal.RestartableJob;
import org.eclipse.ui.views.markers.internal.SortUtil;
import org.eclipse.ui.views.markers.internal.TableView;
import org.eclipse.ui.views.navigator.ShowInNavigatorAction;
import org.eclipse.ui.views.tasklist.ITaskListResourceAdapter;

public abstract class MarkerView
extends TableView {
    private static final String WAITING_FOR_WORKSPACE_CHANGES_TO_FINISH = Messages.getString("MarkerView.waiting_on_changes");
    private static final String SEARCHING_FOR_MARKERS = Messages.getString("MarkerView.searching_for_markers");
    private static final String REFRESHING_MARKER_COUNTS = Messages.getString("MarkerView.refreshing_counts");
    private static final String QUEUEING_VIEWER_UPDATES = Messages.getString("MarkerView.queueing_updates");
    private static final String FILTERING_ON_MARKER_LIMIT = Messages.getString("MarkerView.18");
    private static final String TAG_SELECTION = "selection";
    private static final String TAG_MARKER = "marker";
    private static final String TAG_RESOURCE = "resource";
    private static final String TAG_ID = "id";
    private int preBusyMarkers = 0;
    protected IResource[] focusResources;
    private Clipboard clipboard;
    IResourceChangeListener resourceListener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent event) {
            String[] markerTypes = MarkerView.this.getMarkerTypes();
            boolean refreshNeeded = false;
            int idx = 0;
            while (idx < markerTypes.length) {
                IMarkerDelta[] markerDeltas = event.findMarkerDeltas(markerTypes[idx], true);
                ArrayList changes = new ArrayList(markerDeltas.length);
                MarkerView.examineDelta(markerDeltas, changes);
                if (markerDeltas.length != changes.size()) {
                    refreshNeeded = true;
                }
                MarkerList changed = MarkerView.this.currentMarkers.findMarkers(changes);
                changed.refresh();
                MarkerView.this.change(changed.asList());
                ++idx;
            }
            if (refreshNeeded) {
                MarkerView.this.markerCountDirty = true;
                MarkerView.this.refresh();
            }
        }
    };
    protected ActionCopyMarker copyAction;
    protected ActionPasteMarker pasteAction;
    protected SelectionProviderAction revealAction;
    protected SelectionProviderAction openAction;
    protected SelectionProviderAction showInNavigatorAction;
    protected SelectionProviderAction deleteAction;
    protected SelectionProviderAction selectAllAction;
    protected SelectionProviderAction propertiesAction;
    private ISelectionListener focusListener = new ISelectionListener(){

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            MarkerView.this.focusSelectionChanged(part, selection);
        }
    };
    private MarkerList currentMarkers = new MarkerList();
    private int totalMarkers = 0;
    private boolean markerCountDirty = true;
    WorkbenchJob uiJob;
    private RestartableJob refreshJob = null;
    static /* synthetic */ Class class$0;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void internalRefresh(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        IWorkspaceRoot root;
        IJobManager jobMan;
        int markerLimit;
        block21: {
            block20: {
                block19: {
                    markerLimit = this.getMarkerLimit();
                    monitor.beginTask(Messages.getString("MarkerView.19"), markerLimit == -1 ? 60 : 100);
                    this.haltTableUpdates();
                    jobMan = Platform.getJobManager();
                    root = ResourcesPlugin.getWorkspace().getRoot();
                    try {
                        try {
                            monitor.subTask(WAITING_FOR_WORKSPACE_CHANGES_TO_FINISH);
                            jobMan.beginRule((ISchedulingRule)root, monitor);
                            if (monitor.isCanceled()) {
                                Object var7_5 = null;
                                break block19;
                            }
                            monitor.subTask(SEARCHING_FOR_MARKERS);
                            SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 10);
                            MarkerList markerList = MarkerList.compute(this.getFilter(), (IProgressMonitor)subMonitor, true);
                            if (monitor.isCanceled()) {
                                break block20;
                            }
                            if (this.markerCountDirty) {
                                monitor.subTask(REFRESHING_MARKER_COUNTS);
                                this.totalMarkers = MarkerList.compute(this.getMarkerTypes()).length;
                                this.markerCountDirty = false;
                            }
                            this.currentMarkers = markerList;
                            break block21;
                        }
                        catch (CoreException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var7_7 = null;
                        jobMan.endRule((ISchedulingRule)root);
                        throw throwable;
                    }
                }
                jobMan.endRule((ISchedulingRule)root);
                return;
            }
            Object var7_6 = null;
            jobMan.endRule((ISchedulingRule)root);
            return;
        }
        Object var7_8 = null;
        jobMan.endRule((ISchedulingRule)root);
        if (monitor.isCanceled()) {
            return;
        }
        Collection<ConcreteMarker> markers = Arrays.asList(this.currentMarkers.toArray());
        if (markerLimit != -1) {
            monitor.subTask(FILTERING_ON_MARKER_LIMIT);
            SubProgressMonitor mon = new SubProgressMonitor(monitor, 40);
            markers = SortUtil.getFirst(markers, this.getSorter(), markerLimit, (IProgressMonitor)mon);
            if (monitor.isCanceled()) {
                return;
            }
            this.currentMarkers = new MarkerList(markers);
        }
        monitor.subTask(QUEUEING_VIEWER_UPDATES);
        SubProgressMonitor sub = new SubProgressMonitor(monitor, 50);
        this.setContents(markers, (IProgressMonitor)sub);
        if (monitor.isCanceled()) {
            return;
        }
        this.uiJob.schedule();
        try {
            try {
                this.uiJob.join();
            }
            catch (InterruptedException interruptedException) {
                this.uiJob.cancel();
                monitor.done();
            }
        }
        catch (Throwable throwable) {
            var7_8 = null;
            if (monitor.isCanceled()) {
                this.uiJob.cancel();
            }
            throw throwable;
        }
        {
            var7_8 = null;
        }
        if (monitor.isCanceled()) {
            this.uiJob.cancel();
        }
        monitor.done();
    }

    protected void refresh() {
        if (this.uiJob == null) {
            this.createUIJob();
        }
        if (this.refreshJob == null) {
            this.refreshJob = new RestartableJob(Messages.format("MarkerView.refreshTitle", new Object[]{this.getTitle()}), new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    MarkerView.this.internalRefresh(monitor);
                }
            }, this.getProgressService());
        }
        this.refreshJob.restart();
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.getProgressService().showBusyForFamily(ResourcesPlugin.FAMILY_MANUAL_BUILD);
        this.getProgressService().showBusyForFamily(ResourcesPlugin.FAMILY_AUTO_BUILD);
    }

    public void createPartControl(Composite parent) {
        this.clipboard = new Clipboard(parent.getDisplay());
        super.createPartControl(parent);
        this.initDragAndDrop();
        this.getSite().getPage().addSelectionListener(this.focusListener);
        this.focusSelectionChanged(this.getSite().getPage().getActivePart(), this.getSite().getPage().getSelection());
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceListener);
        this.refresh();
        this.getViewer().getControl().addHelpListener(new HelpListener(){

            public void helpRequested(HelpEvent e) {
                String contextId = null;
                ConcreteMarker marker = (ConcreteMarker)((IStructuredSelection)MarkerView.this.getViewer().getSelection()).getFirstElement();
                if (marker != null) {
                    contextId = IDE.getMarkerHelpRegistry().getHelp(marker.getMarker());
                }
                if (contextId == null) {
                    contextId = "org.eclipse.ui.task_list_view_context";
                }
                WorkbenchHelp.displayHelp((String)contextId);
            }
        });
    }

    protected void viewerSelectionChanged(IStructuredSelection selection) {
        Object[] rawSelection = selection.toArray();
        Object[] markers = new IMarker[rawSelection.length];
        int idx = 0;
        while (idx < rawSelection.length) {
            markers[idx] = ((ConcreteMarker)rawSelection[idx]).getMarker();
            ++idx;
        }
        this.setSelection((IStructuredSelection)new StructuredSelection(markers));
        this.updateStatusMessage(selection);
    }

    public void dispose() {
        super.dispose();
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceListener);
        this.getSite().getPage().removeSelectionListener(this.focusListener);
        this.openAction.dispose();
        this.copyAction.dispose();
        this.selectAllAction.dispose();
        this.deleteAction.dispose();
        this.revealAction.dispose();
        this.showInNavigatorAction.dispose();
        this.propertiesAction.dispose();
        this.clipboard.dispose();
    }

    protected void createActions() {
        TableViewer viewer = this.getViewer();
        this.revealAction = new ActionRevealMarker((IWorkbenchPart)this, this.getSelectionProvider());
        this.openAction = new ActionOpenMarker((IWorkbenchPart)this, this.getSelectionProvider());
        this.copyAction = new ActionCopyMarker((IWorkbenchPart)this, this.getSelectionProvider());
        this.copyAction.setClipboard(this.clipboard);
        this.copyAction.setProperties(this.getFields());
        this.pasteAction = new ActionPasteMarker((IWorkbenchPart)this, this.getSelectionProvider());
        this.pasteAction.setClipboard(this.clipboard);
        this.pasteAction.setPastableTypes(this.getMarkerTypes());
        this.deleteAction = new ActionRemoveMarker((IWorkbenchPart)this, this.getSelectionProvider());
        this.selectAllAction = new ActionSelectAll(viewer);
        this.showInNavigatorAction = new ShowInNavigatorAction(this.getViewSite().getPage(), this.getSelectionProvider());
        this.propertiesAction = new ActionMarkerProperties((IWorkbenchPart)this, this.getSelectionProvider());
        super.createActions();
        this.putAction("filters", (IAction)new FiltersAction(this));
    }

    protected abstract String[] getMarkerTypes();

    protected void initToolBar(IToolBarManager tbm) {
        tbm.add((IAction)this.deleteAction);
        tbm.add(this.getAction("filters"));
        tbm.update(false);
    }

    protected void registerGlobalActions(IActionBars actionBars) {
        actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.copyAction);
        actionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), (IAction)this.pasteAction);
        actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this.deleteAction);
        actionBars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), (IAction)this.selectAllAction);
        actionBars.setGlobalActionHandler(ActionFactory.PROPERTIES.getId(), (IAction)this.propertiesAction);
    }

    protected void initDragAndDrop() {
        int operations = 1;
        Transfer[] transferTypes = new Transfer[]{MarkerTransfer.getInstance(), TextTransfer.getInstance()};
        DragSourceAdapter listener = new DragSourceAdapter(){

            public void dragSetData(DragSourceEvent event) {
                MarkerView.this.performDragSetData(event);
            }

            public void dragFinished(DragSourceEvent event) {
            }
        };
        this.getViewer().addDragSupport(operations, transferTypes, (DragSourceListener)listener);
    }

    private void performDragSetData(DragSourceEvent event) {
        if (MarkerTransfer.getInstance().isSupportedType(event.dataType)) {
            event.data = ((IStructuredSelection)this.getSelectionProvider().getSelection()).toArray();
            return;
        }
        if (TextTransfer.getInstance().isSupportedType(event.dataType)) {
            List selection = ((IStructuredSelection)this.getSelectionProvider().getSelection()).toList();
            try {
                IMarker[] markers = new IMarker[selection.size()];
                selection.toArray(markers);
                if (markers != null) {
                    event.data = this.copyAction.createMarkerReport(markers);
                }
            }
            catch (ArrayStoreException arrayStoreException) {}
        }
    }

    protected void fillContextMenu(IMenuManager manager) {
        if (manager == null) {
            return;
        }
        manager.add((IAction)this.openAction);
        manager.add((IAction)this.showInNavigatorAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.copyAction);
        this.pasteAction.updateEnablement();
        manager.add((IAction)this.pasteAction);
        manager.add((IAction)this.deleteAction);
        manager.add((IAction)this.selectAllAction);
        this.fillContextMenuAdditions(manager);
        manager.add((IContributionItem)new Separator("additions"));
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.propertiesAction);
    }

    protected void fillContextMenuAdditions(IMenuManager manager) {
    }

    protected abstract MarkerFilter getFilter();

    protected void handleKeyPressed(KeyEvent event) {
        if (event.character == '\u007f' && event.stateMask == 0 && this.deleteAction.isEnabled()) {
            this.deleteAction.run();
        }
    }

    protected void handleOpenEvent(OpenEvent event) {
        this.openAction.run();
    }

    protected void saveSelection(IMemento memento) {
        IStructuredSelection selection = (IStructuredSelection)this.getViewer().getSelection();
        IMemento selectionMem = memento.createChild(TAG_SELECTION);
        Iterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            ConcreteMarker marker = (ConcreteMarker)iterator.next();
            IMemento elementMem = selectionMem.createChild(TAG_MARKER);
            elementMem.putString(TAG_RESOURCE, marker.getMarker().getResource().getFullPath().toString());
            elementMem.putString(TAG_ID, String.valueOf(marker.getMarker().getId()));
        }
    }

    protected IStructuredSelection restoreSelection(IMemento memento) {
        if (memento == null) {
            return new StructuredSelection();
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IMemento selectionMemento = memento.getChild(TAG_SELECTION);
        if (selectionMemento == null) {
            return new StructuredSelection();
        }
        ArrayList<ConcreteMarker> selectionList = new ArrayList<ConcreteMarker>();
        IMemento[] markerMems = selectionMemento.getChildren(TAG_MARKER);
        int i = 0;
        while (i < markerMems.length) {
            try {
                IMarker marker;
                long id = new Long(markerMems[i].getString(TAG_ID));
                IResource resource = root.findMember(markerMems[i].getString(TAG_RESOURCE));
                if (resource != null && (marker = resource.findMarker(id)) != null) {
                    selectionList.add(this.currentMarkers.getMarker(marker));
                }
            }
            catch (CoreException coreException) {}
            ++i;
        }
        return new StructuredSelection(selectionList);
    }

    protected abstract String[] getRootTypes();

    protected void focusSelectionChanged(IWorkbenchPart part, ISelection selection) {
        ArrayList<Object> resources = new ArrayList<Object>();
        if (part instanceof IEditorPart) {
            IEditorInput input = ((IEditorPart)part).getEditorInput();
            if (input instanceof FileEditorInput) {
                resources.add(((FileEditorInput)input).getFile());
            }
        } else if (selection instanceof IStructuredSelection) {
            Iterator iterator = ((IStructuredSelection)selection).iterator();
            while (iterator.hasNext()) {
                Object adapter;
                ITaskListResourceAdapter taskListResourceAdapter;
                IResource resource;
                Object object = iterator.next();
                if (!(object instanceof IAdaptable)) continue;
                IAdaptable iAdaptable = (IAdaptable)object;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.ui.views.tasklist.ITaskListResourceAdapter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((resource = (taskListResourceAdapter = (adapter = iAdaptable.getAdapter((Class)clazz)) != null && adapter instanceof ITaskListResourceAdapter ? (ITaskListResourceAdapter)adapter : DefaultMarkerResourceAdapter.getDefault()).getAffectedResource((IAdaptable)object)) == null) continue;
                resources.add(resource);
            }
        }
        IResource[] focus = new IResource[resources.size()];
        resources.toArray(focus);
        this.updateFocusResource(focus);
    }

    protected abstract void updateFilterSelection(IResource[] var1);

    void updateFocusResource(IResource[] resources) {
        boolean updateNeeded = this.updateNeeded(this.focusResources, resources);
        if (updateNeeded) {
            this.focusResources = resources;
            this.updateFilterSelection(resources);
            this.refresh();
        }
    }

    private boolean updateNeeded(IResource[] oldResources, IResource[] newResources) {
        MarkerFilter filter = this.getFilter();
        if (!filter.isEnabled()) {
            return false;
        }
        int onResource = filter.getOnResource();
        if (onResource == 0 || onResource == 4) {
            return false;
        }
        if (newResources == null || newResources.length < 1) {
            return false;
        }
        if (oldResources == null || oldResources.length < 1) {
            return true;
        }
        if (Arrays.equals(oldResources, newResources)) {
            return false;
        }
        if (onResource == 3) {
            Collection oldProjects = MarkerFilter.getProjectsAsCollection(oldResources);
            Collection newProjects = MarkerFilter.getProjectsAsCollection(newResources);
            if (oldProjects.size() == newProjects.size()) {
                return !newProjects.containsAll(oldProjects);
            }
            return true;
        }
        return true;
    }

    private int getMarkerLimit() {
        MarkerFilter filter = this.getFilter();
        if (!filter.isEnabled() || !filter.getFilterOnMarkerLimit()) {
            return -1;
        }
        return filter.getMarkerLimit();
    }

    private boolean withinMarkerLimit(int toTest) {
        int limit = this.getMarkerLimit();
        return limit == -1 || toTest <= limit;
    }

    void updateTitle() {
        this.getTitle();
        this.getConfigurationElement().getAttribute("name");
        String status = "";
        int filteredCount = this.currentMarkers.getItemCount();
        int totalCount = this.getTotalMarkers();
        status = filteredCount == totalCount ? Messages.format("filter.itemsMessage", new Object[]{new Integer(totalCount)}) : Messages.format("filter.matchedMessage", new Object[]{new Integer(filteredCount), new Integer(totalCount)});
        this.setContentDescription(status);
    }

    protected void updateStatusMessage() {
        ISelection selection = this.getViewer().getSelection();
        if (selection instanceof IStructuredSelection) {
            this.updateStatusMessage((IStructuredSelection)selection);
        } else {
            this.updateStatusMessage(null);
        }
    }

    protected void updateStatusMessage(IStructuredSelection selection) {
        String message = "";
        if (selection == null || selection.size() == 0) {
            message = this.updateSummaryVisible();
        } else if (selection.size() == 1) {
            ConcreteMarker marker = (ConcreteMarker)selection.getFirstElement();
            message = marker.getDescription();
        } else if (selection.size() > 1) {
            message = this.updateSummarySelected(selection);
        }
        this.getViewSite().getActionBars().getStatusLineManager().setMessage(message);
    }

    protected String updateSummarySelected(IStructuredSelection selection) {
        return Messages.format("marker.statusSummarySelected", new Object[]{new Integer(selection.size()), ""});
    }

    protected String updateSummaryVisible() {
        return "";
    }

    public abstract void openFiltersDialog();

    public void setSelection(IStructuredSelection structuredSelection, boolean reveal) {
        TableViewer viewer = this.getViewer();
        ArrayList<ConcreteMarker> newSelection = new ArrayList<ConcreteMarker>(structuredSelection.size());
        Iterator i = structuredSelection.iterator();
        while (i.hasNext()) {
            ConcreteMarker marker;
            Object next = i.next();
            if (!(next instanceof IMarker) || (marker = this.currentMarkers.getMarker((IMarker)next)) == null) continue;
            newSelection.add(marker);
        }
        if (viewer != null) {
            viewer.setSelection((ISelection)new StructuredSelection(newSelection), reveal);
        }
    }

    void setContents(Collection contents, IProgressMonitor mon) {
        if (this.withinMarkerLimit(contents.size())) {
            super.setContents(contents, mon);
        } else {
            super.setContents(Collections.EMPTY_LIST, mon);
        }
    }

    protected MarkerList getVisibleMarkers() {
        return this.currentMarkers;
    }

    int getTotalMarkers() {
        return this.totalMarkers;
    }

    protected void sorterChanged() {
        this.refresh();
    }

    private static void examineDelta(IMarkerDelta[] deltas, List changes) {
        int idx = 0;
        while (idx < deltas.length) {
            IMarkerDelta delta = deltas[idx];
            int kind = delta.getKind();
            if (kind == 4) {
                changes.add(deltas[idx].getMarker());
            }
            ++idx;
        }
    }

    public void showBusy(boolean busy) {
        super.showBusy(busy);
        if (busy) {
            this.preBusyMarkers = this.totalMarkers;
        } else if (this.totalMarkers != this.preBusyMarkers) {
            this.getProgressService().warnOfContentChange();
        }
    }

    private void createUIJob() {
        this.uiJob = new WorkbenchJob(Messages.getString("MarkerView.refreshProgress")){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                MarkerView.this.updateStatusMessage();
                MarkerView.this.updateTitle();
                return Status.OK_STATUS;
            }
        };
        this.uiJob.setPriority(10);
        this.uiJob.setSystem(true);
    }
}

