/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.views.markers.internal.IField;
import org.eclipse.ui.views.markers.internal.Messages;
import org.eclipse.ui.views.markers.internal.MnemonicAssigner;
import org.eclipse.ui.views.markers.internal.TableSorter;

public class TableSortDialog
extends Dialog {
    private TableSorter sorter;
    private Combo[] priorityCombos;
    private String[] propertyText;
    private IField[] properties;
    private Button[] ascendingButtons;
    private Button[] descendingButtons;
    private boolean dirty;
    private final Comparator columnComparator = new Comparator(){

        public int compare(Object arg0, Object arg1) {
            int index0 = -1;
            int index1 = -1;
            int i = 0;
            while (i < TableSortDialog.this.propertyText.length) {
                if (TableSortDialog.this.propertyText[i].equals(arg0)) {
                    index0 = i;
                }
                if (TableSortDialog.this.propertyText[i].equals(arg1)) {
                    index1 = i;
                }
                ++i;
            }
            return index0 - index1;
        }
    };

    public TableSortDialog(Shell parentShell, TableSorter sorter) {
        super(parentShell);
        this.sorter = sorter;
        this.dirty = false;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.getString("sortDialog.title"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        if (this.sorter == null) {
            return composite;
        }
        MnemonicAssigner mnemonics = new MnemonicAssigner();
        this.createPrioritiesArea(composite, mnemonics);
        this.createRestoreDefaultsButton(composite, mnemonics);
        this.createSeparatorLine(composite);
        return composite;
    }

    private void createPrioritiesArea(Composite parent, MnemonicAssigner mnemonics) {
        Composite prioritiesArea = new Composite(parent, 0);
        prioritiesArea.setLayout((Layout)new GridLayout(3, false));
        int[] priorities = this.sorter.getPriorities();
        this.ascendingButtons = new Button[priorities.length];
        this.descendingButtons = new Button[priorities.length];
        this.priorityCombos = new Combo[Math.min(priorities.length, 4)];
        this.initPriotityText();
        Label sortByLabel = new Label(prioritiesArea, 0);
        sortByLabel.setText(Messages.getString("sortDialog.label"));
        GridData data = new GridData();
        data.horizontalSpan = 3;
        sortByLabel.setLayoutData((Object)data);
        int i = 0;
        while (i < this.priorityCombos.length) {
            final int index = i;
            Label numberLabel = new Label(prioritiesArea, 0);
            numberLabel.setText(mnemonics.assign(Messages.format("sortDialog.columnLabel", new Object[]{new Integer(i + 1)})));
            this.priorityCombos[i] = new Combo(prioritiesArea, 8);
            this.priorityCombos[i].setLayoutData((Object)new GridData(768));
            Composite directionGroup = new Composite(prioritiesArea, 0);
            directionGroup.setLayout((Layout)new GridLayout(2, false));
            this.ascendingButtons[i] = new Button(directionGroup, 16);
            this.ascendingButtons[i].setText(mnemonics.assign(Messages.getString("sortDirectionAscending.text")));
            this.ascendingButtons[i].addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TableSortDialog.this.markDirty();
                }
            });
            this.descendingButtons[i] = new Button(directionGroup, 16);
            this.descendingButtons[i].setText(mnemonics.assign(Messages.getString("sortDirectionDescending.text")));
            this.descendingButtons[i].addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TableSortDialog.this.markDirty();
                }
            });
            if (i < this.priorityCombos.length - 1) {
                this.priorityCombos[i].addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        String newSelection;
                        int oldSelectionDirection = 1;
                        if (TableSortDialog.this.descendingButtons[index].getSelection()) {
                            oldSelectionDirection = -1;
                        }
                        ArrayList<String> oldSelectionList = new ArrayList<String>(Arrays.asList(TableSortDialog.this.priorityCombos[index].getItems()));
                        oldSelectionList.removeAll(Arrays.asList(TableSortDialog.this.priorityCombos[index + 1].getItems()));
                        if (oldSelectionList.size() != 1) {
                            return;
                        }
                        String oldSelection = oldSelectionList.get(0);
                        if (oldSelection.equals(newSelection = TableSortDialog.this.priorityCombos[index].getItem(TableSortDialog.this.priorityCombos[index].getSelectionIndex()))) {
                            return;
                        }
                        int j = index + 1;
                        while (j < TableSortDialog.this.priorityCombos.length) {
                            int insertionPoint;
                            int newSelectionIndex = TableSortDialog.this.priorityCombos[j].indexOf(newSelection);
                            if (TableSortDialog.this.priorityCombos[j].getSelectionIndex() == newSelectionIndex) {
                                TableSortDialog.this.priorityCombos[j].remove(newSelection);
                                insertionPoint = -1 - Arrays.binarySearch(TableSortDialog.this.priorityCombos[j].getItems(), oldSelection, TableSortDialog.this.columnComparator);
                                if (insertionPoint >= 0 && insertionPoint <= TableSortDialog.this.priorityCombos[j].getItemCount()) {
                                    TableSortDialog.this.priorityCombos[j].add(oldSelection, insertionPoint);
                                } else {
                                    TableSortDialog.this.priorityCombos[j].add(oldSelection);
                                }
                                TableSortDialog.this.priorityCombos[j].select(TableSortDialog.this.priorityCombos[j].indexOf(oldSelection));
                                TableSortDialog.this.ascendingButtons[index].setSelection(TableSortDialog.this.ascendingButtons[j].getSelection());
                                TableSortDialog.this.descendingButtons[index].setSelection(TableSortDialog.this.descendingButtons[j].getSelection());
                                TableSortDialog.this.ascendingButtons[j].setSelection(oldSelectionDirection == 1);
                                TableSortDialog.this.descendingButtons[j].setSelection(oldSelectionDirection == -1);
                            } else if (newSelectionIndex >= 0) {
                                TableSortDialog.this.priorityCombos[j].remove(newSelection);
                                insertionPoint = -1 - Arrays.binarySearch(TableSortDialog.this.priorityCombos[j].getItems(), oldSelection, TableSortDialog.this.columnComparator);
                                if (insertionPoint >= 0 && insertionPoint <= TableSortDialog.this.priorityCombos[j].getItemCount()) {
                                    TableSortDialog.this.priorityCombos[j].add(oldSelection, insertionPoint);
                                } else {
                                    TableSortDialog.this.priorityCombos[j].add(oldSelection);
                                }
                            }
                            ++j;
                        }
                        TableSortDialog.this.markDirty();
                    }
                });
            } else {
                this.priorityCombos[i].addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        TableSortDialog.this.markDirty();
                    }
                });
            }
            ++i;
        }
        this.updateUIFromSorter();
    }

    private void createRestoreDefaultsButton(Composite parent, MnemonicAssigner mnemonics) {
        Button defaultsButton = new Button(parent, 8);
        defaultsButton.setText(mnemonics.assign(Messages.getString("restoreDefaults.text")));
        this.setButtonSize(defaultsButton, new GridData(896));
        defaultsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableSortDialog.this.restoreDefaults();
                TableSortDialog.this.markDirty();
            }
        });
    }

    private void createSeparatorLine(Composite parent) {
        Label separator = new Label(parent, 258);
        separator.setLayoutData((Object)new GridData(772));
    }

    private void restoreDefaults() {
        this.updateUI(this.sorter.getDefaultPriorities(), this.sorter.getDefaultDirections());
    }

    private void updateUIFromSorter() {
        this.updateUI(this.sorter.getPriorities(), this.sorter.getDirections());
    }

    private void updateUI(int[] priorities, int[] directions) {
        ArrayList<String> availablePriorities = new ArrayList<String>(Arrays.asList(this.propertyText));
        int i = 0;
        while (i < this.priorityCombos.length) {
            this.priorityCombos[i].removeAll();
            int j = 0;
            while (j < availablePriorities.size()) {
                this.priorityCombos[i].add(availablePriorities.get(j));
                ++j;
            }
            this.priorityCombos[i].select(this.priorityCombos[i].indexOf(this.propertyText[priorities[i]]));
            availablePriorities.remove(this.propertyText[priorities[i]]);
            this.ascendingButtons[i].setSelection(directions[priorities[i]] == 1);
            this.descendingButtons[i].setSelection(directions[priorities[i]] == -1);
            ++i;
        }
    }

    protected void okPressed() {
        if (this.isDirty()) {
            int i = this.priorityCombos.length - 1;
            while (i >= 0) {
                String column = this.priorityCombos[i].getItem(this.priorityCombos[i].getSelectionIndex());
                int index = -1;
                int j = 0;
                while (j < this.propertyText.length && index == -1) {
                    if (this.propertyText[j].equals(column)) {
                        index = j;
                    }
                    ++j;
                }
                if (index == -1) {
                    this.sorter.resetState();
                    return;
                }
                this.sorter.setTopPriority(this.properties[index]);
                int direction = 1;
                if (this.descendingButtons[i].getSelection()) {
                    direction = -1;
                }
                this.sorter.setTopPriorityDirection(direction);
                --i;
            }
        }
        super.okPressed();
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void markDirty() {
        this.dirty = true;
    }

    private void setButtonSize(Button button, GridData buttonData) {
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        buttonData.widthHint = Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
        button.setLayoutData((Object)buttonData);
    }

    private void initPriotityText() {
        IField[] unorderedProperties = this.sorter.getFields();
        this.properties = new IField[unorderedProperties.length];
        System.arraycopy(unorderedProperties, 0, this.properties, 0, this.properties.length);
        this.propertyText = new String[this.properties.length];
        int i = 0;
        while (i < this.properties.length) {
            this.propertyText[i] = this.properties[i].getDescription();
            ++i;
        }
    }

    public TableSorter getSorter() {
        return this.sorter;
    }
}

