/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.wizards.datatransfer;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.wizards.datatransfer.DataTransferMessages;
import org.eclipse.ui.internal.wizards.datatransfer.WizardArchiveFileResourceImportPage1;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ZipFileImportWizard
extends Wizard
implements IImportWizard {
    private IWorkbench workbench;
    private IStructuredSelection selection;
    private WizardArchiveFileResourceImportPage1 mainPage;

    public ZipFileImportWizard() {
        AbstractUIPlugin plugin = (AbstractUIPlugin)Platform.getPlugin((String)"org.eclipse.ui");
        IDialogSettings workbenchSettings = plugin.getDialogSettings();
        IDialogSettings section = workbenchSettings.getSection("ZipFileImportWizard");
        if (section == null) {
            section = workbenchSettings.addNewSection("ZipFileImportWizard");
        }
        this.setDialogSettings(section);
    }

    public void addPages() {
        super.addPages();
        this.mainPage = new WizardArchiveFileResourceImportPage1(this.workbench, this.selection);
        this.addPage((IWizardPage)this.mainPage);
    }

    private ImageDescriptor getImageDescriptor(String relativePath) {
        String iconPath = "icons/full/";
        try {
            AbstractUIPlugin plugin = (AbstractUIPlugin)Platform.getPlugin((String)"org.eclipse.ui");
            URL installURL = plugin.getDescriptor().getInstallURL();
            URL url = new URL(installURL, String.valueOf(iconPath) + relativePath);
            return ImageDescriptor.createFromURL((URL)url);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
        this.workbench = workbench;
        this.selection = currentSelection;
        List selectedResources = IDE.computeSelectedResources(currentSelection);
        if (!selectedResources.isEmpty()) {
            this.selection = new StructuredSelection(selectedResources);
        }
        this.setWindowTitle(DataTransferMessages.getString("DataTransfer.importTitle"));
        this.setDefaultPageImageDescriptor(this.getImageDescriptor("wizban/importzip_wiz.gif"));
        this.setNeedsProgressMonitor(true);
    }

    public boolean performCancel() {
        return this.mainPage.cancel();
    }

    public boolean performFinish() {
        return this.mainPage.finish();
    }
}

