/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.filebuffers.manipulation;

import java.util.ArrayList;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.IFileBuffer;
import org.eclipse.core.filebuffers.IFileBufferManager;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.manipulation.IFileBufferOperation;
import org.eclipse.core.filebuffers.manipulation.Messages;
import org.eclipse.core.internal.filebuffers.Progress;
import org.eclipse.core.internal.filebuffers.TextFileBufferManager;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;

public class FileBufferOperationRunner {
    private final Object fValidationContext;
    private final IFileBufferManager fFileBufferManager;
    private final Object fCompletionLock = new Object();
    private transient boolean fIsCompleted;
    private transient Throwable fThrowable;

    public FileBufferOperationRunner(IFileBufferManager fileBufferManager, Object validationContext) {
        this.fFileBufferManager = fileBufferManager;
        this.fValidationContext = validationContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute(IPath[] locations, final IFileBufferOperation operation, IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        int size = locations.length;
        final IProgressMonitor progressMonitor = Progress.getMonitor(monitor);
        progressMonitor.beginTask(operation.getOperationName(), size * 200);
        try {
            IProgressMonitor subMonitor = Progress.getSubMonitor(progressMonitor, size * 10);
            IFileBuffer[] fileBuffers = this.createFileBuffers(locations, subMonitor);
            subMonitor.done();
            IFileBuffer[] fileBuffers2Save = this.findFileBuffersToSave(fileBuffers);
            subMonitor = Progress.getSubMonitor(progressMonitor, size * 10);
            this.fFileBufferManager.validateState(fileBuffers2Save, subMonitor, this.fValidationContext);
            subMonitor.done();
            if (!this.isCommitable(fileBuffers2Save)) {
                throw new OperationCanceledException();
            }
            IFileBuffer[] unsynchronizedFileBuffers = this.findUnsynchronizedFileBuffers(fileBuffers);
            this.performOperation(unsynchronizedFileBuffers, operation, progressMonitor);
            final IFileBuffer[] synchronizedFileBuffers = this.findSynchronizedFileBuffers(fileBuffers);
            this.fIsCompleted = false;
            this.fThrowable = null;
            Object object = this.fCompletionLock;
            synchronized (object) {
                this.executeInContext(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    public void run() {
                        Object object = FileBufferOperationRunner.this.fCompletionLock;
                        synchronized (object) {
                            try {
                                Platform.run((ISafeRunnable)new ISafeRunnable(this, synchronizedFileBuffers, operation, progressMonitor){
                                    final /* synthetic */ 1 this$1;
                                    private final /* synthetic */ IFileBuffer[] val$synchronizedFileBuffers;
                                    private final /* synthetic */ IFileBufferOperation val$operation;
                                    private final /* synthetic */ IProgressMonitor val$progressMonitor;
                                    {
                                        this.this$1 = var1_1;
                                        this.val$synchronizedFileBuffers = iFileBufferArray;
                                        this.val$operation = iFileBufferOperation;
                                        this.val$progressMonitor = iProgressMonitor;
                                    }

                                    public void handleException(Throwable throwable) {
                                        FileBufferOperationRunner.access$2(1.access$0(this.this$1), throwable);
                                    }

                                    public void run() throws Exception {
                                        FileBufferOperationRunner.access$3(1.access$0(this.this$1), this.val$synchronizedFileBuffers, this.val$operation, this.val$progressMonitor);
                                    }
                                });
                                Object var2_4 = null;
                            }
                            catch (Throwable throwable) {
                                Object var2_3 = null;
                                FileBufferOperationRunner.this.fIsCompleted = true;
                                FileBufferOperationRunner.this.fCompletionLock.notifyAll();
                                throw throwable;
                            }
                            FileBufferOperationRunner.this.fIsCompleted = true;
                            FileBufferOperationRunner.this.fCompletionLock.notifyAll();
                            return;
                        }
                    }

                    static /* synthetic */ FileBufferOperationRunner access$0(1 var0) {
                        return var0.FileBufferOperationRunner.this;
                    }
                });
                while (!this.fIsCompleted) {
                    try {
                        this.fCompletionLock.wait(500L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            if (this.fThrowable != null) {
                if (!(this.fThrowable instanceof CoreException)) throw new CoreException((IStatus)new Status(4, "org.eclipse.core.filebuffers", 1, this.fThrowable.getLocalizedMessage(), this.fThrowable));
                throw (CoreException)this.fThrowable;
            }
            subMonitor = Progress.getSubMonitor(progressMonitor, size * 80);
            this.commit(fileBuffers2Save, subMonitor);
            subMonitor.done();
            Object var12_14 = null;
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            try {
                IProgressMonitor subMonitor = Progress.getSubMonitor(progressMonitor, size * 10);
                this.releaseFileBuffers(locations, subMonitor);
                subMonitor.done();
                Object var15_20 = null;
            }
            catch (Throwable throwable2) {
                Object var15_19 = null;
                progressMonitor.done();
                throw throwable2;
            }
            progressMonitor.done();
            throw throwable;
        }
        try {}
        catch (Throwable throwable) {
            Object var15_21 = null;
            progressMonitor.done();
            throw throwable;
        }
        IProgressMonitor subMonitor = Progress.getSubMonitor(progressMonitor, size * 10);
        this.releaseFileBuffers(locations, subMonitor);
        subMonitor.done();
        Object var15_22 = null;
        progressMonitor.done();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void performOperation(IFileBuffer fileBuffer, IFileBufferOperation operation, IProgressMonitor progressMonitor) throws CoreException, OperationCanceledException {
        ISchedulingRule rule = fileBuffer.computeCommitRule();
        IJobManager manager = Platform.getJobManager();
        try {
            manager.beginRule(rule, progressMonitor);
            String name = fileBuffer.getLocation().lastSegment();
            progressMonitor.beginTask(name, 100);
            try {
                IProgressMonitor subMonitor = Progress.getSubMonitor(progressMonitor, 100);
                operation.run(fileBuffer, subMonitor);
                subMonitor.done();
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                progressMonitor.done();
                throw throwable;
            }
            {
                Object var8_10 = null;
                progressMonitor.done();
            }
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            manager.endRule(rule);
            throw throwable;
        }
        {
            Object var10_13 = null;
        }
        manager.endRule(rule);
    }

    private void performOperation(IFileBuffer[] fileBuffers, IFileBufferOperation operation, IProgressMonitor progressMonitor) throws CoreException, OperationCanceledException {
        int i = 0;
        while (i < fileBuffers.length) {
            if (progressMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            IProgressMonitor subMonitor = Progress.getSubMonitor(progressMonitor, 100);
            this.performOperation(fileBuffers[i], operation, subMonitor);
            subMonitor.done();
            ++i;
        }
    }

    private void executeInContext(Runnable runnable) {
        ITextFileBufferManager fileBufferManager = FileBuffers.getTextFileBufferManager();
        if (fileBufferManager instanceof TextFileBufferManager) {
            TextFileBufferManager manager = (TextFileBufferManager)fileBufferManager;
            manager.execute(runnable, true);
        } else {
            runnable.run();
        }
    }

    private IFileBuffer[] findUnsynchronizedFileBuffers(IFileBuffer[] fileBuffers) {
        ArrayList<IFileBuffer> list = new ArrayList<IFileBuffer>();
        int i = 0;
        while (i < fileBuffers.length) {
            if (!fileBuffers[i].isSynchronizationContextRequested()) {
                list.add(fileBuffers[i]);
            }
            ++i;
        }
        return list.toArray(new IFileBuffer[list.size()]);
    }

    private IFileBuffer[] findSynchronizedFileBuffers(IFileBuffer[] fileBuffers) {
        ArrayList<IFileBuffer> list = new ArrayList<IFileBuffer>();
        int i = 0;
        while (i < fileBuffers.length) {
            if (fileBuffers[i].isSynchronizationContextRequested()) {
                list.add(fileBuffers[i]);
            }
            ++i;
        }
        return list.toArray(new IFileBuffer[list.size()]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IFileBuffer[] createFileBuffers(IPath[] locations, IProgressMonitor progressMonitor) throws CoreException {
        IFileBuffer[] iFileBufferArray;
        progressMonitor.beginTask(Messages.getString("FileBufferOperationRunner.task.connecting"), locations.length);
        try {
            try {
                IFileBuffer[] fileBuffers = new ITextFileBuffer[locations.length];
                int i = 0;
                while (true) {
                    if (i >= locations.length) {
                        iFileBufferArray = fileBuffers;
                        Object var6_8 = null;
                        break;
                    }
                    IProgressMonitor subMonitor = Progress.getSubMonitor(progressMonitor, 1);
                    this.fFileBufferManager.connect(locations[i], subMonitor);
                    subMonitor.done();
                    fileBuffers[i] = this.fFileBufferManager.getFileBuffer(locations[i]);
                    ++i;
                }
            }
            catch (CoreException x) {
                try {
                    this.releaseFileBuffers(locations, Progress.getMonitor());
                    throw x;
                }
                catch (CoreException coreException) {}
                throw x;
            }
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            progressMonitor.done();
            throw throwable;
        }
        progressMonitor.done();
        return iFileBufferArray;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void releaseFileBuffers(IPath[] locations, IProgressMonitor progressMonitor) throws CoreException {
        progressMonitor.beginTask(Messages.getString("FileBufferOperationRunner.task.disconnecting"), locations.length);
        try {
            ITextFileBufferManager fileBufferManager = FileBuffers.getTextFileBufferManager();
            int i = 0;
            while (i < locations.length) {
                IProgressMonitor subMonitor = Progress.getSubMonitor(progressMonitor, 1);
                fileBufferManager.disconnect(locations[i], subMonitor);
                subMonitor.done();
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            progressMonitor.done();
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        progressMonitor.done();
    }

    private IFileBuffer[] findFileBuffersToSave(IFileBuffer[] fileBuffers) {
        ArrayList<IFileBuffer> list = new ArrayList<IFileBuffer>();
        int i = 0;
        while (i < fileBuffers.length) {
            IFileBuffer buffer = fileBuffers[i];
            if (!buffer.isDirty()) {
                list.add(buffer);
            }
            ++i;
        }
        return list.toArray(new IFileBuffer[list.size()]);
    }

    private boolean isCommitable(IFileBuffer[] fileBuffers) {
        int i = 0;
        while (i < fileBuffers.length) {
            if (!fileBuffers[i].isCommitable()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private ISchedulingRule computeCommitRule(IFileBuffer[] fileBuffers) {
        ArrayList<ISchedulingRule> list = new ArrayList<ISchedulingRule>();
        int i = 0;
        while (i < fileBuffers.length) {
            ISchedulingRule rule = fileBuffers[i].computeCommitRule();
            if (rule != null) {
                list.add(rule);
            }
            ++i;
        }
        ISchedulingRule[] rules = new ISchedulingRule[list.size()];
        list.toArray(rules);
        return new MultiRule(rules);
    }

    private void commit(final IFileBuffer[] fileBuffers, IProgressMonitor progressMonitor) throws CoreException {
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run(IProgressMonitor monitor) throws CoreException {
                monitor = Progress.getMonitor(monitor);
                monitor.beginTask(Messages.getString("FileBufferOperationRunner.task.committing"), fileBuffers.length);
                try {
                    int i = 0;
                    while (i < fileBuffers.length) {
                        IProgressMonitor subMonitor = Progress.getSubMonitor(monitor, 1);
                        fileBuffers[i].commit(subMonitor, true);
                        subMonitor.done();
                        ++i;
                    }
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    monitor.done();
                    throw throwable;
                }
                {
                    Object var4_6 = null;
                }
                monitor.done();
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, this.computeCommitRule(fileBuffers), 1, progressMonitor);
    }

    static /* synthetic */ void access$2(FileBufferOperationRunner fileBufferOperationRunner, Throwable throwable) {
        fileBufferOperationRunner.fThrowable = throwable;
    }

    static /* synthetic */ void access$3(FileBufferOperationRunner fileBufferOperationRunner, IFileBuffer[] iFileBufferArray, IFileBufferOperation iFileBufferOperation, IProgressMonitor iProgressMonitor) {
        fileBufferOperationRunner.performOperation(iFileBufferArray, iFileBufferOperation, iProgressMonitor);
    }
}

