/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.filebuffers;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.internal.filebuffers.AbstractFileBuffer;
import org.eclipse.core.internal.filebuffers.FileBuffersMessages;
import org.eclipse.core.internal.filebuffers.FileBuffersPlugin;
import org.eclipse.core.internal.filebuffers.TextFileBufferManager;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

public abstract class JavaFileBuffer
extends AbstractFileBuffer {
    protected IPath fLocation;
    protected File fFile;
    protected int fReferenceCount;
    protected boolean fCanBeSaved = false;
    protected IStatus fStatus;
    protected long fSynchronizationStamp = -1L;
    protected int fSynchronizationContextCount;
    protected TextFileBufferManager fManager;

    public JavaFileBuffer(TextFileBufferManager manager) {
        this.fManager = manager;
    }

    protected abstract void addFileBufferContentListeners();

    protected abstract void removeFileBufferContentListeners();

    protected abstract void initializeFileBufferContent(IProgressMonitor var1) throws CoreException;

    protected abstract void commitFileBufferContent(IProgressMonitor var1, boolean var2) throws CoreException;

    public void create(IPath location, IProgressMonitor monitor) throws CoreException {
        this.fLocation = location;
        File file = FileBuffers.getSystemFileAtLocation(location);
        if (file.exists()) {
            this.fFile = file;
        }
        this.initializeFileBufferContent(monitor);
        if (this.fFile != null) {
            this.fSynchronizationStamp = this.fFile.lastModified();
        }
        this.addFileBufferContentListeners();
    }

    public void connect() {
        ++this.fReferenceCount;
        if (this.fReferenceCount == 1) {
            this.connected();
        }
    }

    protected void connected() {
    }

    public void disconnect() throws CoreException {
        --this.fReferenceCount;
        if (this.fReferenceCount == 0) {
            this.disconnected();
        }
    }

    protected void disconnected() {
    }

    public boolean isDisposed() {
        return this.fReferenceCount <= 0;
    }

    public IPath getLocation() {
        return this.fLocation;
    }

    public void commit(IProgressMonitor monitor, boolean overwrite) throws CoreException {
        if (!this.isDisposed() && this.fCanBeSaved) {
            this.fManager.fireStateChanging(this);
            try {
                this.commitFileBufferContent(monitor, overwrite);
            }
            catch (CoreException x) {
                this.fManager.fireStateChangeFailed(this);
                throw x;
            }
            catch (RuntimeException x) {
                this.fManager.fireStateChangeFailed(this);
                throw x;
            }
            this.fCanBeSaved = false;
            this.addFileBufferContentListeners();
            this.fManager.fireDirtyStateChanged(this, this.fCanBeSaved);
        }
    }

    public ISchedulingRule computeCommitRule() {
        return null;
    }

    public boolean isDirty() {
        return this.fCanBeSaved;
    }

    public void setDirty(boolean isDirty) {
        this.fCanBeSaved = isDirty;
    }

    public boolean isShared() {
        return this.fReferenceCount > 1;
    }

    public ISchedulingRule computeValidateStateRule() {
        return null;
    }

    public void validateState(IProgressMonitor monitor, Object computationContext) throws CoreException {
    }

    public boolean isStateValidated() {
        return true;
    }

    public void resetStateValidation() {
    }

    protected void handleFileMoved(IPath newLocation) {
        this.fManager.fireUnderlyingFileMoved(this, newLocation);
    }

    protected void handleCoreException(CoreException exception) {
        ILog log = FileBuffersPlugin.getDefault().getLog();
        log.log(exception.getStatus());
    }

    public boolean isSynchronized() {
        return this.fSynchronizationStamp == this.getModificationStamp();
    }

    public long getModificationStamp() {
        return this.fFile != null ? this.fFile.lastModified() : -1L;
    }

    public void requestSynchronizationContext() {
        ++this.fSynchronizationContextCount;
    }

    public void releaseSynchronizationContext() {
        --this.fSynchronizationContextCount;
    }

    public boolean isSynchronizationContextRequested() {
        return this.fSynchronizationContextCount > 0;
    }

    public boolean isCommitable() {
        File file = FileBuffers.getSystemFileAtLocation(this.getLocation());
        return file.exists() && file.canWrite();
    }

    public void validationStateChanged(boolean validationState, IStatus status) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IContentDescription getContentDescription() throws CoreException {
        IContentDescription iContentDescription;
        FileInputStream stream = null;
        try {
            try {
                stream = new FileInputStream(this.fFile);
                iContentDescription = Platform.getContentTypeManager().getDescriptionFor((InputStream)stream, this.fFile.getName(), IContentDescription.ALL);
                Object var3_3 = null;
            }
            catch (IOException x) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.core.filebuffers", 0, FileBuffersMessages.getFormattedString("JavaFileBuffer.error.queryContentDescription", this.fFile.getPath()), (Throwable)x));
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            try {
                if (stream == null) throw throwable;
                stream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                throw throwable;
            }
        }
        try {}
        catch (IOException iOException) {}
        if (stream == null) return iContentDescription;
        stream.close();
        return iContentDescription;
    }
}

