/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.ui.internal.search;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.help.internal.base.HelpBasePlugin;
import org.eclipse.help.ui.internal.ide.HelpIdeResources;
import org.eclipse.help.ui.internal.search.HelpSearchQuery;
import org.eclipse.help.ui.internal.search.SWTUtil;
import org.eclipse.help.ui.internal.search.SearchQueryData;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.search.ui.ISearchPage;
import org.eclipse.search.ui.ISearchPageContainer;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IWorkingSetSelectionDialog;
import org.eclipse.ui.help.WorkbenchHelp;

public class HelpSearchPage
extends DialogPage
implements ISearchPage {
    protected Combo searchWordCombo = null;
    protected static List previousSearchQueryData = new ArrayList(20);
    protected Button all;
    protected Button selected;
    protected Text selectedWorkingSetsText;
    private ISearchPageContainer scontainer = null;
    private boolean firstTime = true;
    protected SearchQueryData searchQueryData = new SearchQueryData();
    protected Button includeDisabledActivities;

    public void createControl(Composite parent) {
        Composite control = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        control.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        control.setLayoutData((Object)gd);
        Label expressionLabel = new Label(control, 16384);
        expressionLabel.setText(HelpIdeResources.getString("expression"));
        this.searchWordCombo = new Combo(control, 2052);
        gd = new GridData(768);
        gd.widthHint = this.convertWidthInCharsToPixels(30);
        this.searchWordCombo.setLayoutData((Object)gd);
        this.searchWordCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (HelpSearchPage.this.searchWordCombo.getSelectionIndex() < 0) {
                    return;
                }
                int index = previousSearchQueryData.size() - 1 - HelpSearchPage.this.searchWordCombo.getSelectionIndex();
                HelpSearchPage.this.searchQueryData = (SearchQueryData)previousSearchQueryData.get(index);
                HelpSearchPage.this.searchWordCombo.setText(HelpSearchPage.this.searchQueryData.getSearchWord());
                HelpSearchPage.this.all.setSelection(!HelpSearchPage.this.searchQueryData.isBookFiltering());
                HelpSearchPage.this.selected.setSelection(HelpSearchPage.this.searchQueryData.isBookFiltering());
                HelpSearchPage.this.includeDisabledActivities.setSelection(!HelpSearchPage.this.searchQueryData.isActivityFiltering());
                HelpSearchPage.this.displaySelectedBooks();
            }
        });
        this.searchWordCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                HelpSearchPage.this.updateSearchButtonState();
            }
        });
        new Label(control, 0);
        Label label = new Label(control, 16384);
        gd = new GridData(768);
        gd.horizontalSpan = 1;
        label.setLayoutData((Object)gd);
        label.setText(HelpIdeResources.getString("expression_label"));
        Group filteringGroup = new Group(control, 0);
        filteringGroup.setLayout((Layout)layout);
        gd = new GridData(1808);
        gd.horizontalSpan = 2;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        filteringGroup.setLayoutData((Object)gd);
        filteringGroup.setText(HelpIdeResources.getString("limit_to"));
        layout = new GridLayout();
        layout.numColumns = 3;
        filteringGroup.setLayout((Layout)layout);
        this.all = new Button((Composite)filteringGroup, 16);
        this.all.setSelection(!this.searchQueryData.isBookFiltering());
        this.all.setText(HelpIdeResources.getString("HelpSearchPage.allBooks"));
        gd = new GridData();
        gd.horizontalSpan = 3;
        this.all.setLayoutData((Object)gd);
        this.all.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HelpSearchPage.this.searchQueryData.setBookFiltering(false);
            }
        });
        this.selected = new Button((Composite)filteringGroup, 16);
        this.selected.setSelection(this.searchQueryData.isBookFiltering());
        this.selected.setText(HelpIdeResources.getString("HelpSearchPage.selectedBooks"));
        this.selected.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HelpSearchPage.this.searchQueryData.setBookFiltering(true);
                HelpSearchPage.this.updateSearchButtonState();
            }
        });
        this.selectedWorkingSetsText = new Text((Composite)filteringGroup, 2060);
        this.displaySelectedBooks();
        Button chooseWorkingSet = new Button((Composite)filteringGroup, 8);
        Dialog.applyDialogFont((Control)chooseWorkingSet);
        this.setButtonLayoutData(chooseWorkingSet);
        chooseWorkingSet.setText(HelpIdeResources.getString("HelpSearchPage.choose"));
        SWTUtil.setButtonDimensionHint(chooseWorkingSet);
        gd = new GridData(768);
        gd.horizontalIndent = 8;
        gd.widthHint = SWTUtil.convertWidthInCharsToPixels(30, this.selectedWorkingSetsText);
        this.selectedWorkingSetsText.setLayoutData((Object)gd);
        chooseWorkingSet.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IWorkingSetSelectionDialog dialog = PlatformUI.getWorkbench().getWorkingSetManager().createWorkingSetSelectionDialog(HelpSearchPage.this.selected.getShell(), false);
                if (dialog.open() == 0) {
                    HelpSearchPage.this.all.setSelection(false);
                    HelpSearchPage.this.selected.setSelection(true);
                    HelpSearchPage.this.searchQueryData.setBookFiltering(true);
                    HelpSearchPage.this.searchQueryData.setSelectedWorkingSets(dialog.getSelection());
                    HelpSearchPage.this.displaySelectedBooks();
                }
            }
        });
        this.includeDisabledActivities = new Button((Composite)filteringGroup, 32);
        gd = new GridData();
        gd.horizontalSpan = 3;
        this.includeDisabledActivities.setLayoutData((Object)gd);
        this.includeDisabledActivities.setText(HelpIdeResources.getString("searchDisabledActivities"));
        this.includeDisabledActivities.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                HelpSearchPage.this.searchQueryData.setActivityFiltering(!HelpSearchPage.this.includeDisabledActivities.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        Dialog.applyDialogFont((Control)control);
        this.setControl((Control)control);
        WorkbenchHelp.setHelp((Control)control, (String)"org.eclipse.help.ide.searchPage");
    }

    public boolean performAction() {
        this.searchQueryData.setSearchWord(this.searchWordCombo.getText());
        this.searchQueryData.setFieldsSearch(false);
        Preferences prefs = HelpBasePlugin.getDefault().getPluginPreferences();
        String lastWS = prefs.getString("workingSet");
        IWorkingSet[] iws = this.searchQueryData.getSelectedWorkingSets();
        if (this.searchQueryData.isBookFiltering() && iws != null && iws.length > 0 && !iws[0].getName().equals(lastWS)) {
            prefs.setValue("workingSet", iws[0].getName());
            HelpBasePlugin.getDefault().savePluginPreferences();
        } else if (!(this.searchQueryData.isBookFiltering() || lastWS == null && lastWS.length() <= 0)) {
            prefs.setValue("workingSet", "");
            HelpBasePlugin.getDefault().savePluginPreferences();
        }
        if (!previousSearchQueryData.contains(this.searchQueryData)) {
            previousSearchQueryData.add(this.searchQueryData);
        }
        HelpSearchQuery searchUIQuery = new HelpSearchQuery(this.searchQueryData);
        NewSearchUI.activateSearchResultView();
        NewSearchUI.runQueryInBackground((ISearchQuery)searchUIQuery);
        return true;
    }

    public void setContainer(ISearchPageContainer container) {
        this.scontainer = container;
    }

    public void setVisible(boolean visible) {
        if (visible && this.searchWordCombo != null) {
            if (this.firstTime) {
                this.firstTime = false;
                String[] patterns = new String[previousSearchQueryData.size()];
                int i = 0;
                while (i < previousSearchQueryData.size()) {
                    patterns[HelpSearchPage.previousSearchQueryData.size() - 1 - i] = ((SearchQueryData)previousSearchQueryData.get(i)).getSearchWord();
                    ++i;
                }
                this.searchWordCombo.setItems(patterns);
            }
            this.searchWordCombo.setFocus();
            this.updateSearchButtonState();
        }
        super.setVisible(visible);
    }

    protected void displaySelectedBooks() {
        String workingSetNames = "";
        if (this.searchQueryData.isBookFiltering()) {
            IWorkingSet[] workingSets = this.searchQueryData.getSelectedWorkingSets();
            int i = 0;
            while (i < workingSets.length) {
                String workingSet = workingSets[i].getName();
                workingSetNames = workingSetNames.length() <= 0 ? workingSet : String.valueOf(workingSetNames) + HelpIdeResources.getString("HelpSearchPage.bookLabelSeparator") + workingSet;
                ++i;
            }
        } else {
            workingSetNames = "";
        }
        this.selectedWorkingSetsText.setText(workingSetNames);
        this.updateSearchButtonState();
    }

    protected void updateSearchButtonState() {
        boolean searchWordValid = this.searchWordCombo.getText() != null && this.searchWordCombo.getText().trim().length() > 0;
        boolean workingSetValid = this.selectedWorkingSetsText.getText() != null && this.selectedWorkingSetsText.getText().length() > 0;
        this.scontainer.setPerformActionEnabled(searchWordValid && (this.all.getSelection() || workingSetValid));
    }
}

