/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.gui;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.GeneralPath;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.emboss.jemboss.JembossParams;
import org.emboss.jemboss.gui.MemoryComboBox;

public class Browser
extends JFrame
implements HyperlinkListener,
ActionListener {
    private MemoryComboBox urlField;
    private JEditorPane htmlPane;
    private String initialURL;
    private Cursor cbusy = new Cursor(3);
    private Cursor cdone = new Cursor(0);
    private String[] topics = new String[]{"About Jemboss", "User Guide", "File Manager", "Results Manager", "Sequence List", "Jemboss Alignment Editor"};
    private JList spLeft;
    private JSplitPane sp;
    private JMenuItem backMenu;
    private JButton backBt;
    private JMenuItem fwdMenu;
    private JButton fwdBt;

    public Browser(String string, String string2, JembossParams jembossParams) throws IOException {
        this(string, string2, false, "", jembossParams);
    }

    public Browser(String string, String string2, boolean bl, String string3, JembossParams jembossParams) throws IOException {
        super(string2);
        this.initialURL = string;
        if (jembossParams.isBrowserProxy()) {
            System.setProperty("proxyHost", jembossParams.getBrowserProxyHost());
            System.setProperty("proxyPort", Integer.toString(jembossParams.getBrowserProxyPort()));
        }
        if (bl) {
            this.htmlPane = new JEditorPane();
            if (string3.indexOf("<html>") > -1 || string3.indexOf("<HTML>") > -1) {
                this.htmlPane.setContentType("text/html");
            }
            this.htmlPane.setText(string3);
            this.htmlPane.addHyperlinkListener(this);
            this.setBrowserSize();
            Vector<String> vector = new Vector<String>();
            vector.add(string2 + ".html");
            this.setUpJMenuBar(vector);
            this.addToScrollPane();
            this.setVisible(true);
        } else {
            URL uRL = new URL(string);
            this.setURL(uRL, string);
        }
    }

    public Browser(URL uRL, String string) throws IOException {
        super(string);
        this.initialURL = string;
        this.setURL(uRL, string);
    }

    public void setURL(URL uRL, String string) {
        try {
            this.htmlPane = new JEditorPane(uRL);
            this.htmlPane.addHyperlinkListener(this);
            Vector<URL> vector = new Vector<URL>();
            vector.add(uRL);
            this.setBrowserSize();
            this.setUpJMenuBar(vector);
            this.setTitle(string);
            this.addToScrollPane();
            this.setVisible(true);
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(null, "Cannot Load URL\n" + string, "Error", 0);
        }
    }

    private void setUpJMenuBar(Vector vector) {
        JMenuBar jMenuBar = new JMenuBar();
        JToolBar jToolBar = new JToolBar();
        JToolBar jToolBar2 = new JToolBar();
        JMenu jMenu = new JMenu("File");
        jMenu.setMnemonic(70);
        jMenuBar.add(jMenu);
        this.backMenu = new JMenuItem("Back");
        this.backMenu.setAccelerator(KeyStroke.getKeyStroke(66, 2));
        this.backMenu.setActionCommand("BACK");
        this.backMenu.addActionListener(this);
        jMenu.add(this.backMenu);
        this.backMenu.setEnabled(false);
        this.fwdMenu = new JMenuItem("Forward");
        this.fwdMenu.setAccelerator(KeyStroke.getKeyStroke(70, 2));
        this.fwdMenu.setActionCommand("FWD");
        this.fwdMenu.addActionListener(this);
        jMenu.add(this.fwdMenu);
        jMenu.addSeparator();
        JMenuItem jMenuItem = new JMenuItem("Close");
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Browser.this.setVisible(false);
            }
        });
        jMenu.add(jMenuItem);
        JMenu jMenu2 = new JMenu("View");
        jMenu2.setMnemonic(86);
        jMenuBar.add(jMenu2);
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem("Display help topics");
        jCheckBoxMenuItem.setSelected(true);
        jCheckBoxMenuItem.setAccelerator(KeyStroke.getKeyStroke(76, 2));
        jCheckBoxMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (Browser.this.sp.getDividerLocation() > 5) {
                    Browser.this.sp.setDividerLocation(0);
                } else {
                    Browser.this.sp.setDividerLocation(100);
                }
            }
        });
        jMenu2.add(jCheckBoxMenuItem);
        ClassLoader classLoader = this.getClass().getClassLoader();
        ImageIcon imageIcon = new ImageIcon(classLoader.getResource("images/Jemboss_logo_small.gif"));
        JIconButton jIconButton = new JIconButton(imageIcon);
        jIconButton.addActionListener(this);
        jIconButton.setActionCommand("JEMBOSS");
        JLabel jLabel = new JLabel("URL:");
        this.urlField = new MemoryComboBox(vector);
        int n = (int)this.urlField.getPreferredSize().getHeight();
        this.backBt = new JButton(){

            public void paintComponent(Graphics graphics) {
                super.paintComponent(graphics);
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setColor(new Color(0, 128, 0));
                graphics2D.fill(Browser.makeShape(4.0f, 12.0f, 14.0f, 22.0f, 14.0f, 16.0f, 18.0f, 16.0f, 18.0f, 12.0f));
                graphics2D.setColor(Color.green);
                graphics2D.fill(Browser.makeShape(4.0f, 12.0f, 14.0f, 2.0f, 14.0f, 8.0f, 18.0f, 8.0f, 18.0f, 12.0f));
                if (!this.isEnabled()) {
                    graphics2D.setColor(Color.gray);
                    graphics2D.fill(Browser.makeShape(5.0f, 12.0f, 14.0f, 21.0f, 14.0f, 15.0f, 18.0f, 15.0f, 18.0f, 12.0f));
                    graphics2D.setColor(Color.lightGray);
                    graphics2D.fill(Browser.makeShape(5.0f, 12.0f, 14.0f, 3.0f, 14.0f, 9.0f, 18.0f, 9.0f, 18.0f, 12.0f));
                }
                this.setSize(22, 24);
            }
        };
        Dimension dimension = new Dimension(22, 24);
        this.backBt.setPreferredSize(dimension);
        this.backBt.setMaximumSize(dimension);
        this.backBt.setPreferredSize(new Dimension(15, 15));
        this.backBt.setActionCommand("BACK");
        this.backBt.addActionListener(this);
        this.backBt.setEnabled(false);
        this.fwdBt = new JButton(){

            public void paintComponent(Graphics graphics) {
                super.paintComponent(graphics);
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setColor(new Color(0, 128, 0));
                graphics2D.fill(Browser.makeShape(4.0f, 12.0f, 4.0f, 16.0f, 8.0f, 16.0f, 8.0f, 22.0f, 18.0f, 12.0f));
                graphics2D.setColor(Color.green);
                graphics2D.fill(Browser.makeShape(4.0f, 12.0f, 4.0f, 8.0f, 8.0f, 8.0f, 8.0f, 2.0f, 18.0f, 12.0f));
                if (!this.isEnabled()) {
                    graphics2D.setColor(Color.gray);
                    graphics2D.fill(Browser.makeShape(4.0f, 12.0f, 4.0f, 15.0f, 8.0f, 15.0f, 8.0f, 21.0f, 17.0f, 12.0f));
                    graphics2D.setColor(Color.lightGray);
                    graphics2D.fill(Browser.makeShape(4.0f, 12.0f, 4.0f, 7.0f, 8.0f, 7.0f, 8.0f, 3.0f, 17.0f, 12.0f));
                }
                this.setSize(22, 24);
            }
        };
        this.fwdBt.setPreferredSize(dimension);
        this.fwdBt.setMaximumSize(dimension);
        this.fwdBt.setActionCommand("FWD");
        this.fwdBt.addActionListener(this);
        this.fwdBt.setEnabled(false);
        jToolBar2.add(this.backBt);
        jToolBar2.add(this.fwdBt);
        jToolBar2.add(jIconButton);
        jToolBar.add(jLabel);
        jToolBar.add(this.urlField);
        this.setJMenuBar(jMenuBar);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)jToolBar2, "North");
        jPanel.add((Component)jToolBar, "South");
        this.getContentPane().add((Component)jPanel, "North");
        int n2 = (int)jToolBar.getPreferredSize().getWidth();
        Dimension dimension2 = new Dimension(n2, n);
        this.urlField.setMaximumSize(dimension2);
        int n3 = (int)jToolBar2.getPreferredSize().getWidth();
        int n4 = imageIcon.getIconHeight();
        dimension2 = new Dimension(n3, n4);
        jToolBar2.setPreferredSize(dimension2);
    }

    private void setBrowserSize() {
        Dimension dimension = this.getToolkit().getScreenSize();
        int n = dimension.width * 5 / 10;
        int n2 = dimension.height * 7 / 10;
        this.setBounds(n / 5, n2 / 7, n, n2);
    }

    private void addToScrollPane() {
        this.htmlPane.setEditable(false);
        this.htmlPane.setCaretPosition(0);
        final ClassLoader classLoader = this.getClass().getClassLoader();
        final JList<String> jList = new JList<String>(this.topics);
        jList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                String string = (String)jList.getSelectedValue();
                URL uRL = null;
                if (string.equals("File Manager")) {
                    uRL = classLoader.getResource("resources/filemgr.html");
                } else if (string.equals("About Jemboss")) {
                    uRL = classLoader.getResource("resources/readme.html");
                } else if (string.equals("Jemboss Alignment Editor")) {
                    uRL = classLoader.getResource("resources/readmeAlign.html");
                } else if (string.equals("Sequence List")) {
                    uRL = classLoader.getResource("resources/seqList.html");
                } else if (string.equals("Results Manager")) {
                    uRL = classLoader.getResource("resources/results.html");
                } else if (string.equals("User Guide")) {
                    try {
                        uRL = new URL("http://www.rfcgr.mrc.ac.uk/Software/EMBOSS/Jemboss/guide.html");
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
                if (uRL != null) {
                    try {
                        Browser.this.htmlPane.setPage(uRL);
                        if (!Browser.this.urlField.isItem(uRL)) {
                            Browser.this.urlField.addURL(uRL);
                        } else {
                            Browser.this.urlField.setSelectedItem(uRL);
                            Browser.this.urlField.setLastIndex(uRL);
                        }
                    }
                    catch (IOException iOException) {
                        Browser.this.setCursor(Browser.this.cdone);
                        Browser.this.warnUser("Can't follow link to " + uRL);
                    }
                    Browser.this.backMenu.setEnabled(Browser.this.urlField.isBackPage());
                    Browser.this.backBt.setEnabled(Browser.this.urlField.isBackPage());
                    Browser.this.fwdMenu.setEnabled(Browser.this.urlField.isForwardPage());
                    Browser.this.fwdBt.setEnabled(Browser.this.urlField.isForwardPage());
                }
            }
        });
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalGlue());
        JButton jButton = new JButton(){

            public void paintComponent(Graphics graphics) {
                super.paintComponent(graphics);
                BasicStroke basicStroke = new BasicStroke(2.0f);
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setStroke(basicStroke);
                graphics2D.setColor(Color.gray);
                graphics2D.drawLine(4, 5, 9, 10);
                graphics2D.drawLine(9, 5, 4, 10);
                graphics2D.setColor(Color.black);
                graphics2D.drawLine(4, 4, 9, 9);
                graphics2D.drawLine(9, 3, 3, 9);
                this.setSize(15, 15);
            }
        };
        jButton.addActionListener(this);
        jButton.setActionCommand("CLOSE");
        jButton.setPreferredSize(new Dimension(15, 15));
        box.add(jButton);
        JPanel jPanel = new JPanel(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane(jList);
        jPanel.add((Component)box, "North");
        jPanel.add((Component)jScrollPane, "Center");
        jScrollPane.getViewport().setBackground(Color.white);
        this.sp = new JSplitPane(1, jPanel, this.htmlPane);
        this.sp.setDividerSize(8);
        this.sp.setDividerLocation(100);
        this.sp.setOneTouchExpandable(true);
        JScrollPane jScrollPane2 = new JScrollPane(this.htmlPane);
        this.sp.add(jScrollPane2);
        this.htmlPane.setPreferredSize(this.getPreferredSize());
        this.getContentPane().add((Component)this.sp, "Center");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        URL uRL = null;
        this.setCursor(this.cbusy);
        if (actionEvent.getSource() == this.urlField) {
            Object object = this.urlField.getSelectedItem();
            if (object instanceof String) {
                try {
                    uRL = new URL((String)object);
                }
                catch (MalformedURLException malformedURLException) {}
            } else {
                uRL = (URL)object;
            }
        } else if (actionEvent.getActionCommand().equals("JEMBOSS")) {
            try {
                uRL = new URL("http://www.rfcgr.mrc.ac.uk/Software/EMBOSS/Jemboss/");
            }
            catch (MalformedURLException malformedURLException) {}
        } else if (actionEvent.getActionCommand().equals("BACK")) {
            int n = this.urlField.getIndexOf(this.urlField.getSelectedItem()) - 1;
            if (n > -1 && n < this.urlField.getItemCount()) {
                uRL = this.urlField.getURLAt(n);
            }
        } else if (actionEvent.getActionCommand().equals("FWD")) {
            int n = this.urlField.getIndexOf(this.urlField.getSelectedItem()) + 1;
            if (n > -1 && n < this.urlField.getItemCount()) {
                uRL = this.urlField.getURLAt(n);
            }
        } else if (actionEvent.getActionCommand().equals("CLOSE")) {
            this.setCursor(this.cdone);
            this.sp.setDividerLocation(0);
            return;
        }
        try {
            this.htmlPane.setPage(uRL);
            if (!this.urlField.isItem(uRL)) {
                this.urlField.addURL(uRL);
            } else {
                this.urlField.setSelectedItem(uRL);
            }
            this.backMenu.setEnabled(this.urlField.isBackPage());
            this.backBt.setEnabled(this.urlField.isBackPage());
            this.fwdMenu.setEnabled(this.urlField.isForwardPage());
            this.fwdBt.setEnabled(this.urlField.isForwardPage());
        }
        catch (IOException iOException) {
            this.setCursor(this.cdone);
            this.warnUser("Can't follow link to " + uRL);
        }
        this.setCursor(this.cdone);
    }

    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            this.setCursor(this.cbusy);
            try {
                URL uRL = hyperlinkEvent.getURL();
                this.htmlPane.setPage(uRL);
                if (!this.urlField.isItem(uRL)) {
                    this.urlField.addURL(uRL);
                } else {
                    this.urlField.setSelectedItem(uRL);
                    this.urlField.setLastIndex(uRL);
                }
            }
            catch (IOException iOException) {
                this.setCursor(this.cdone);
                this.warnUser("Can't follow link to " + hyperlinkEvent.getURL().toExternalForm());
            }
            this.setCursor(this.cdone);
        }
    }

    private void warnUser(String string) {
        JOptionPane.showMessageDialog(this, string, "Warning", 0);
    }

    public static GeneralPath makeShape(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10) {
        GeneralPath generalPath = new GeneralPath(1);
        generalPath.moveTo(f, f2);
        generalPath.lineTo(f3, f4);
        generalPath.lineTo(f5, f6);
        generalPath.lineTo(f7, f8);
        generalPath.lineTo(f9, f10);
        generalPath.closePath();
        return generalPath;
    }

    public static void main(String[] stringArray) {
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        try {
            URL uRL = classLoader.getResource("resources/seqList.html");
            new Browser(uRL, "resources/seqList.html");
        }
        catch (Exception exception) {
            System.out.println("Didn't find resources/seqList.html");
        }
    }

    public class JIconButton
    extends JButton {
        public JIconButton(ImageIcon imageIcon) {
            super(imageIcon);
            this.setContentAreaFilled(false);
            this.setBorderPainted(false);
            this.setFocusPainted(false);
        }
    }
}

