package bilab;


import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.part.*;
import org.eclipse.jface.viewers.*;
import org.eclipse.swt.graphics.Image;
import org.eclipse.jface.action.*;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ui.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.SWT;
import org.openscience.jmol.viewer.JmolViewer;


// a view for a scigol.Value
public class ValueView extends ViewPart implements ISelectionListener 
{

  public ValueView() {
    //!!! tmp hack (see below)
    instance = this;
	}

  
  
  
  
	public void createPartControl(Composite parent) {
	  valueViewer = new ValueViewer(parent);
    
    //!!!
    scigol.List l = (scigol.List)Util.readResource("molecules/1GP2.pdb","").value;
	  setInput(new scigol.Value(l.get_head())); //!!!
	  
    makeActions();
    contributeToActionBars();
    
	  // the ValueView may want to provide selection events & also listen for them
	  //  So, we need to adapt between the ISelectionChangeListenr interface of jface & the platform ui ISelectionListener method
	  
	  // register our listener to listen to the value viewer and pass on the events as an ISelection
	  
	  
      getSite().setSelectionProvider(valueViewer);
      getSite().getPage().addSelectionListener(this);
      
	}

  
  
  private void contributeToActionBars() {
    IActionBars bars = getViewSite().getActionBars();
    fillLocalPullDown(bars.getMenuManager());
    fillLocalToolBar(bars.getToolBarManager());
  }
  
  private void fillLocalPullDown(IMenuManager manager) {
    manager.add(openAction);
    //manager.add(new Separator());
    //manager.add(action2);
  }
  
  private void fillLocalToolBar(IToolBarManager manager) {
    manager.add(openAction);
  }
  
  
  
  
	
	public void setInput(scigol.Value v)
	{
	  valueViewer.setInput(v);
	  String title = valueViewer.get_title();
	  if (title.length()>0) {
	    setPartName(title);
	    setContentDescription(valueViewer.get_description());
	  }
	  else {
	    setPartName("Value");
	    setContentDescription("");
	  }
	}

	
	public void selectionChanged(IWorkbenchPart source, ISelection selection)
	{
	  if (selection instanceof ValueSelection) {
	    setInput( ((ValueSelection)selection).value );
	  }
	  
    valueViewer.selectionChanged(source, selection); //!!! why was this commented out?? 
	}
	
	
	public void dispose()
	{
	  getSite().getPage().removeSelectionListener(valueViewer);
	  super.dispose();
	}
	
	
	public void setFocus() {
	  valueViewer.getControl().setFocus();
	}
	
  
  // open a file as a resource and show its value
  private void open()
  {
    //!!! do this in another thread later FIXME !!!
    Shell shell = valueViewer.getControl().getShell();
    FileDialog fileDialog = new FileDialog(shell, SWT.OPEN);
    String selectedFile = fileDialog.open();
    
    if (selectedFile==null) return; // cancelled
    
    ResourceManager rm = BilabPlugin.getResourceManager();
    
    String resName = ResourceManager.filenameToResourceName(selectedFile); 
    
    Object o = rm.instantiateObjectFromResource(resName,"unknown");
    
    if (o != null)
      this.setInput(new scigol.Value(o));
    else
      Notify.userWarning(this,"unable to determine file content type for import.  File:"+selectedFile);
  }
  
  
  private void makeActions()
  {
    openAction = new Action() {
        public void run() {
          open();
        }
      };
      openAction.setText("Open");
      openAction.setToolTipText("Open file and show content");
      openAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor(ISharedImages.IMG_OBJ_FOLDER));
  }
  
  
  
	
	private ValueViewer valueViewer;
  private Action openAction;
  
  //!!! hack for EnvNavigatorView to set our input (see explanation there)
  public static ValueView getInstance() { return instance; }
  private static ValueView instance=null;
	  
}