package nsdb;


/**
* nsdb/_NucFeatureWriterStub.java .
* Generated by the IDL-to-Java compiler (portable), version "3.1"
* from corba/nsdb_write.idl
* Monday, August 23, 2004 12:02:44 PM BST
*/

public class _NucFeatureWriterStub extends org.omg.CORBA.portable.ObjectImpl implements nsdb.NucFeatureWriter
{


  /**
       * Set the key, location and qualifiers of this NucFeature
       * @parm key The new feature key
       * @parm location The new feature location
       * @raises InvalidKey if the given key is not a possible EMBL key.
       * @raises LocationParse If the location string is not a valid location.
       * @raises type::IndexOutOfRange If any part of the location is out
       *   of range for the sequence.
       * @raises type::InvalidRelation if one of the qualifiers in this
       *   feature cannot be associated with the given feature key.
       * @raises QualifierParse if the format of any the qualifiers is not
       *   appropriate for a Qualifier with the given name.  For
       *   example the value part of /codon_start qualifier must be a number: 1,
       *   2 or 3.  Also thrown if a qualifier has value when it should not or
       *   vice versa.
       * @raises InvalidQualifier if the name of the Qualifier is not a
       *   valid embl qualifier name.
       * @raises ReadOnlyException If this Feature cannot be changed.
       * @raises OutOfDate If the key has changed since the time given by
       *   datestamp.
       */
  public void set (nsdb.Datestamp datestamp, String key, String location, nsdb.NucFeaturePackage.Qualifier[] qualifier_list) throws nsdb.InvalidKey, nsdb.LocationParse, type.IndexOutOfRange, type.InvalidRelation, nsdb.QualifierParse, nsdb.InvalidQualifier, nsdb.OutOfDate, nsdb.ReadOnlyException
  {
            org.omg.CORBA.portable.InputStream $in = null;
            try {
                org.omg.CORBA.portable.OutputStream $out = _request ("set", true);
                nsdb.DatestampHelper.write ($out, datestamp);
                $out.write_string (key);
                $out.write_string (location);
                nsdb.NucFeaturePackage.QualifierListHelper.write ($out, qualifier_list);
                $in = _invoke ($out);
                return;
            } catch (org.omg.CORBA.portable.ApplicationException $ex) {
                $in = $ex.getInputStream ();
                String _id = $ex.getId ();
                if (_id.equals ("IDL:nsdb/InvalidKey:1.0"))
                    throw nsdb.InvalidKeyHelper.read ($in);
                else if (_id.equals ("IDL:nsdb/LocationParse:1.0"))
                    throw nsdb.LocationParseHelper.read ($in);
                else if (_id.equals ("IDL:type/IndexOutOfRange:1.0"))
                    throw type.IndexOutOfRangeHelper.read ($in);
                else if (_id.equals ("IDL:type/InvalidRelation:1.0"))
                    throw type.InvalidRelationHelper.read ($in);
                else if (_id.equals ("IDL:nsdb/QualifierParse:1.0"))
                    throw nsdb.QualifierParseHelper.read ($in);
                else if (_id.equals ("IDL:nsdb/InvalidQualifier:1.0"))
                    throw nsdb.InvalidQualifierHelper.read ($in);
                else if (_id.equals ("IDL:nsdb/OutOfDate:1.0"))
                    throw nsdb.OutOfDateHelper.read ($in);
                else if (_id.equals ("IDL:nsdb/ReadOnlyException:1.0"))
                    throw nsdb.ReadOnlyExceptionHelper.read ($in);
                else
                    throw new org.omg.CORBA.MARSHAL (_id);
            } catch (org.omg.CORBA.portable.RemarshalException $rm) {
                set (datestamp, key, location, qualifier_list        );
            } finally {
                _releaseReply ($in);
            }
  } // set


  /**
       * Set the key of this NucFeature
       * @parm key The new feature key
       * @raises InvalidKey if the given key is not a possible EMBL key.
       * @raises type::InvalidRelation if one of the qualifiers in this
       *   feature cannot be associated with the given feature key.
       * @raises OutOfDate If the key has changed since the time given by
       *   datestamp.
       */
  public void setKey (nsdb.Datestamp datestamp, String key) throws nsdb.InvalidKey, type.InvalidRelation, nsdb.OutOfDate, nsdb.ReadOnlyException
  {
            org.omg.CORBA.portable.InputStream $in = null;
            try {
                org.omg.CORBA.portable.OutputStream $out = _request ("setKey", true);
                nsdb.DatestampHelper.write ($out, datestamp);
                $out.write_string (key);
                $in = _invoke ($out);
                return;
            } catch (org.omg.CORBA.portable.ApplicationException $ex) {
                $in = $ex.getInputStream ();
                String _id = $ex.getId ();
                if (_id.equals ("IDL:nsdb/InvalidKey:1.0"))
                    throw nsdb.InvalidKeyHelper.read ($in);
                else if (_id.equals ("IDL:type/InvalidRelation:1.0"))
                    throw type.InvalidRelationHelper.read ($in);
                else if (_id.equals ("IDL:nsdb/OutOfDate:1.0"))
                    throw nsdb.OutOfDateHelper.read ($in);
                else if (_id.equals ("IDL:nsdb/ReadOnlyException:1.0"))
                    throw nsdb.ReadOnlyExceptionHelper.read ($in);
                else
                    throw new org.omg.CORBA.MARSHAL (_id);
            } catch (org.omg.CORBA.portable.RemarshalException $rm) {
                setKey (datestamp, key        );
            } finally {
                _releaseReply ($in);
            }
  } // setKey


  /**
       * Set the location of this NucFeature
       * @parm location The new feature location
       * @raises LocationParse If the location string is not a valid location.
       * @raises type::IndexOutOfRange If any part of the location is out
       *   of range for the sequence.
       * @raises OutOfDate If the location has changed since the time given by
       *   datestamp.
       */
  public void setLocation (nsdb.Datestamp datestamp, String location) throws nsdb.LocationParse, type.IndexOutOfRange, nsdb.OutOfDate, nsdb.ReadOnlyException
  {
            org.omg.CORBA.portable.InputStream $in = null;
            try {
                org.omg.CORBA.portable.OutputStream $out = _request ("setLocation", true);
                nsdb.DatestampHelper.write ($out, datestamp);
                $out.write_string (location);
                $in = _invoke ($out);
                return;
            } catch (org.omg.CORBA.portable.ApplicationException $ex) {
                $in = $ex.getInputStream ();
                String _id = $ex.getId ();
                if (_id.equals ("IDL:nsdb/LocationParse:1.0"))
                    throw nsdb.LocationParseHelper.read ($in);
                else if (_id.equals ("IDL:type/IndexOutOfRange:1.0"))
                    throw type.IndexOutOfRangeHelper.read ($in);
                else if (_id.equals ("IDL:nsdb/OutOfDate:1.0"))
                    throw nsdb.OutOfDateHelper.read ($in);
                else if (_id.equals ("IDL:nsdb/ReadOnlyException:1.0"))
                    throw nsdb.ReadOnlyExceptionHelper.read ($in);
                else
                    throw new org.omg.CORBA.MARSHAL (_id);
            } catch (org.omg.CORBA.portable.RemarshalException $rm) {
                setLocation (datestamp, location        );
            } finally {
                _releaseReply ($in);
            }
  } // setLocation


  /**
       * Set the qualifiers of this feature, replacing the current qualifiers.
       * @raises InvalidRelationException if this Feature cannot
       *   contain one of the given qualifiers.
       * @raises QualifierParse if the format of any the qualifiers is not
       *   appropriate for a Qualifier with the given name.  For
       *   example the value part of /codon_start qualifier must be a number: 1,
       *   2 or 3.  Also thrown if a qualifier has value when it should not or
       *   vice versa.
       * @raises InvalidQualifier if the name of the Qualifier is not a
       *   valid embl qualifier name.
       * @raises OutOfDate if any of the qualifiers has changed since the time
       *   given by datestamp.
       */
  public void setQualifiers (nsdb.Datestamp datestamp, nsdb.NucFeaturePackage.Qualifier[] qualifier_list) throws type.InvalidRelation, nsdb.QualifierParse, nsdb.InvalidQualifier, nsdb.OutOfDate, nsdb.ReadOnlyException
  {
            org.omg.CORBA.portable.InputStream $in = null;
            try {
                org.omg.CORBA.portable.OutputStream $out = _request ("setQualifiers", true);
                nsdb.DatestampHelper.write ($out, datestamp);
                nsdb.NucFeaturePackage.QualifierListHelper.write ($out, qualifier_list);
                $in = _invoke ($out);
                return;
            } catch (org.omg.CORBA.portable.ApplicationException $ex) {
                $in = $ex.getInputStream ();
                String _id = $ex.getId ();
                if (_id.equals ("IDL:type/InvalidRelation:1.0"))
                    throw type.InvalidRelationHelper.read ($in);
                else if (_id.equals ("IDL:nsdb/QualifierParse:1.0"))
                    throw nsdb.QualifierParseHelper.read ($in);
                else if (_id.equals ("IDL:nsdb/InvalidQualifier:1.0"))
                    throw nsdb.InvalidQualifierHelper.read ($in);
                else if (_id.equals ("IDL:nsdb/OutOfDate:1.0"))
                    throw nsdb.OutOfDateHelper.read ($in);
                else if (_id.equals ("IDL:nsdb/ReadOnlyException:1.0"))
                    throw nsdb.ReadOnlyExceptionHelper.read ($in);
                else
                    throw new org.omg.CORBA.MARSHAL (_id);
            } catch (org.omg.CORBA.portable.RemarshalException $rm) {
                setQualifiers (datestamp, qualifier_list        );
            } finally {
                _releaseReply ($in);
            }
  } // setQualifiers


  /**
       * Add the given Qualifier to this Feature.  If this Feature contains a
       * Qualifier with the same name as the new Qualifier it will be replaced.
       * @parm qualifier The new qualifier to add.
       * @raises InvalidRelationException if this Feature cannot
       *   contain the given Qualifier.
       * @raises QualifierParse if the format of the qualifier is not
       *   appropriate for a Qualifier with the given name.  For
       *   example the value part of /codon_start qualifier must be a number: 1,
       *   2 or 3.  Also thrown if a qualifier has value when it should not or
       *   vice versa.
       * @raises InvalidQualifier if the name of the Qualifier is not a
       *   valid embl qualifier name.
       * @raises OutOfDate if there is a an existing qualifier with the same
       *   name as the argument qualifier and it has changed since the time
       *   given by datestamp.
       */
  public void setQualifier (nsdb.Datestamp datestamp, nsdb.NucFeaturePackage.Qualifier qualifier) throws type.InvalidRelation, nsdb.QualifierParse, nsdb.InvalidQualifier, nsdb.OutOfDate, nsdb.ReadOnlyException
  {
            org.omg.CORBA.portable.InputStream $in = null;
            try {
                org.omg.CORBA.portable.OutputStream $out = _request ("setQualifier", true);
                nsdb.DatestampHelper.write ($out, datestamp);
                nsdb.NucFeaturePackage.QualifierHelper.write ($out, qualifier);
                $in = _invoke ($out);
                return;
            } catch (org.omg.CORBA.portable.ApplicationException $ex) {
                $in = $ex.getInputStream ();
                String _id = $ex.getId ();
                if (_id.equals ("IDL:type/InvalidRelation:1.0"))
                    throw type.InvalidRelationHelper.read ($in);
                else if (_id.equals ("IDL:nsdb/QualifierParse:1.0"))
                    throw nsdb.QualifierParseHelper.read ($in);
                else if (_id.equals ("IDL:nsdb/InvalidQualifier:1.0"))
                    throw nsdb.InvalidQualifierHelper.read ($in);
                else if (_id.equals ("IDL:nsdb/OutOfDate:1.0"))
                    throw nsdb.OutOfDateHelper.read ($in);
                else if (_id.equals ("IDL:nsdb/ReadOnlyException:1.0"))
                    throw nsdb.ReadOnlyExceptionHelper.read ($in);
                else
                    throw new org.omg.CORBA.MARSHAL (_id);
            } catch (org.omg.CORBA.portable.RemarshalException $rm) {
                setQualifier (datestamp, qualifier        );
            } finally {
                _releaseReply ($in);
            }
  } // setQualifier


  /**
       * Remove the Qualifier with the given name.  If there is no Qualifier
       * with that name, then return immediately.
       * @parm name The Qualifier name to look for.
       * @raises OutOfDate if there is a an existing qualifier with the same
       *   name as the argument name and it has changed since the time given by
       *   the datestamp.
       */
  public void removeQualiferByName (nsdb.Datestamp datestamp, String name) throws type.InvalidRelation, nsdb.OutOfDate, nsdb.ReadOnlyException
  {
            org.omg.CORBA.portable.InputStream $in = null;
            try {
                org.omg.CORBA.portable.OutputStream $out = _request ("removeQualiferByName", true);
                nsdb.DatestampHelper.write ($out, datestamp);
                $out.write_string (name);
                $in = _invoke ($out);
                return;
            } catch (org.omg.CORBA.portable.ApplicationException $ex) {
                $in = $ex.getInputStream ();
                String _id = $ex.getId ();
                if (_id.equals ("IDL:type/InvalidRelation:1.0"))
                    throw type.InvalidRelationHelper.read ($in);
                else if (_id.equals ("IDL:nsdb/OutOfDate:1.0"))
                    throw nsdb.OutOfDateHelper.read ($in);
                else if (_id.equals ("IDL:nsdb/ReadOnlyException:1.0"))
                    throw nsdb.ReadOnlyExceptionHelper.read ($in);
                else
                    throw new org.omg.CORBA.MARSHAL (_id);
            } catch (org.omg.CORBA.portable.RemarshalException $rm) {
                removeQualiferByName (datestamp, name        );
            } finally {
                _releaseReply ($in);
            }
  } // removeQualiferByName


  /**
       * Return a Datestamp that will be passed to the set methods on the
       * EmblSeqWriter methods and NucFeatureWriter methods.  The object that is
       * returned represents the time when the feature was last changed (the
       * last time the key, location or qualifiers changed).
       */
  public nsdb.Datestamp getDatestamp ()
  {
            org.omg.CORBA.portable.InputStream $in = null;
            try {
                org.omg.CORBA.portable.OutputStream $out = _request ("getDatestamp", true);
                $in = _invoke ($out);
                nsdb.Datestamp $result = nsdb.DatestampHelper.read ($in);
                return $result;
            } catch (org.omg.CORBA.portable.ApplicationException $ex) {
                $in = $ex.getInputStream ();
                String _id = $ex.getId ();
                throw new org.omg.CORBA.MARSHAL (_id);
            } catch (org.omg.CORBA.portable.RemarshalException $rm) {
                return getDatestamp (        );
            } finally {
                _releaseReply ($in);
            }
  } // getDatestamp


  /**
  	 * Retrieve sequence of qualifiers.
  	 * @raises type::NoResult if no qualifiers are associated with
  	 *    the feature.
  	 */
  public nsdb.NucFeaturePackage.Qualifier[] getQualifiers () throws type.NoResult
  {
            org.omg.CORBA.portable.InputStream $in = null;
            try {
                org.omg.CORBA.portable.OutputStream $out = _request ("getQualifiers", true);
                $in = _invoke ($out);
                nsdb.NucFeaturePackage.Qualifier $result[] = nsdb.NucFeaturePackage.QualifierListHelper.read ($in);
                return $result;
            } catch (org.omg.CORBA.portable.ApplicationException $ex) {
                $in = $ex.getInputStream ();
                String _id = $ex.getId ();
                if (_id.equals ("IDL:type/NoResult:1.0"))
                    throw type.NoResultHelper.read ($in);
                else
                    throw new org.omg.CORBA.MARSHAL (_id);
            } catch (org.omg.CORBA.portable.RemarshalException $rm) {
                return getQualifiers (        );
            } finally {
                _releaseReply ($in);
            }
  } // getQualifiers


  /**
  	 * retrieve qualifier of a certain type.
  	 * To find out which qualifier/feature combinations are valid, a client should
  	 * query the NucFeatureMeta server.
  	 * @raises type::NoResult if no qualifier of this type is associated with
  	 *   the feature
  	 * @raises type::InvalidRelation if the requested qualifier cannot be
  	 *   associated to the current feature type
  	 * @see metafeature::NucFeatureMeta
  	 */
  public nsdb.NucFeaturePackage.Qualifier getQualifier (String qualifier_name) throws type.NoResult, type.InvalidRelation
  {
            org.omg.CORBA.portable.InputStream $in = null;
            try {
                org.omg.CORBA.portable.OutputStream $out = _request ("getQualifier", true);
                $out.write_string (qualifier_name);
                $in = _invoke ($out);
                nsdb.NucFeaturePackage.Qualifier $result = nsdb.NucFeaturePackage.QualifierHelper.read ($in);
                return $result;
            } catch (org.omg.CORBA.portable.ApplicationException $ex) {
                $in = $ex.getInputStream ();
                String _id = $ex.getId ();
                if (_id.equals ("IDL:type/NoResult:1.0"))
                    throw type.NoResultHelper.read ($in);
                else if (_id.equals ("IDL:type/InvalidRelation:1.0"))
                    throw type.InvalidRelationHelper.read ($in);
                else
                    throw new org.omg.CORBA.MARSHAL (_id);
            } catch (org.omg.CORBA.portable.RemarshalException $rm) {
                return getQualifier (qualifier_name        );
            } finally {
                _releaseReply ($in);
            }
  } // getQualifier


  /**
  	 * If the location of the feature references multiple sequences, get a 
  	 * sequence of all sequences referenced
  	 * This method is equivalent to retrieving the feature location, and looping
  	 *  through all location nodes to find the referenced sequences, converting 
  	 * the accession numbers into DbXref's.
  	 */
  public type.DbXref[] getNucSeqs ()
  {
            org.omg.CORBA.portable.InputStream $in = null;
            try {
                org.omg.CORBA.portable.OutputStream $out = _request ("getNucSeqs", true);
                $in = _invoke ($out);
                type.DbXref $result[] = type.DbXrefListHelper.read ($in);
                return $result;
            } catch (org.omg.CORBA.portable.ApplicationException $ex) {
                $in = $ex.getInputStream ();
                String _id = $ex.getId ();
                throw new org.omg.CORBA.MARSHAL (_id);
            } catch (org.omg.CORBA.portable.RemarshalException $rm) {
                return getNucSeqs (        );
            } finally {
                _releaseReply ($in);
            }
  } // getNucSeqs


  /**
  	 * retrieve location of feature.
  	 * @raises type::NoResult if no location is associated with the feature.
  	 */
  public nsdb.FeatureLocation getLocation () throws type.NoResult
  {
            org.omg.CORBA.portable.InputStream $in = null;
            try {
                org.omg.CORBA.portable.OutputStream $out = _request ("getLocation", true);
                $in = _invoke ($out);
                nsdb.FeatureLocation $result = nsdb.FeatureLocationHelper.read ($in);
                return $result;
            } catch (org.omg.CORBA.portable.ApplicationException $ex) {
                $in = $ex.getInputStream ();
                String _id = $ex.getId ();
                if (_id.equals ("IDL:type/NoResult:1.0"))
                    throw type.NoResultHelper.read ($in);
                else
                    throw new org.omg.CORBA.MARSHAL (_id);
            } catch (org.omg.CORBA.portable.RemarshalException $rm) {
                return getLocation (        );
            } finally {
                _releaseReply ($in);
            }
  } // getLocation


  /**
  	 * feature identifier.
  	 */
  public String getFeatureId ()
  {
            org.omg.CORBA.portable.InputStream $in = null;
            try {
                org.omg.CORBA.portable.OutputStream $out = _request ("getFeatureId", true);
                $in = _invoke ($out);
                String $result = $in.read_string ();
                return $result;
            } catch (org.omg.CORBA.portable.ApplicationException $ex) {
                $in = $ex.getInputStream ();
                String _id = $ex.getId ();
                throw new org.omg.CORBA.MARSHAL (_id);
            } catch (org.omg.CORBA.portable.RemarshalException $rm) {
                return getFeatureId (        );
            } finally {
                _releaseReply ($in);
            }
  } // getFeatureId


  /**
  	 * Feature types are defined by a key.
  	 */
  public String getKey ()
  {
            org.omg.CORBA.portable.InputStream $in = null;
            try {
                org.omg.CORBA.portable.OutputStream $out = _request ("getKey", true);
                $in = _invoke ($out);
                String $result = $in.read_string ();
                return $result;
            } catch (org.omg.CORBA.portable.ApplicationException $ex) {
                $in = $ex.getInputStream ();
                String _id = $ex.getId ();
                throw new org.omg.CORBA.MARSHAL (_id);
            } catch (org.omg.CORBA.portable.RemarshalException $rm) {
                return getKey (        );
            } finally {
                _releaseReply ($in);
            }
  } // getKey


  /**
  	 * return current version of the feature. returns 0 if 
  	 * no versioning is implemented.
  	 */
  public int getFeatureVersion ()
  {
            org.omg.CORBA.portable.InputStream $in = null;
            try {
                org.omg.CORBA.portable.OutputStream $out = _request ("getFeatureVersion", true);
                $in = _invoke ($out);
                int $result = $in.read_ulong ();
                return $result;
            } catch (org.omg.CORBA.portable.ApplicationException $ex) {
                $in = $ex.getInputStream ();
                String _id = $ex.getId ();
                throw new org.omg.CORBA.MARSHAL (_id);
            } catch (org.omg.CORBA.portable.RemarshalException $rm) {
                return getFeatureVersion (        );
            } finally {
                _releaseReply ($in);
            }
  } // getFeatureVersion

  // Type-specific CORBA::Object operations
  private static String[] __ids = {
    "IDL:nsdb/NucFeatureWriter:1.0", 
    "IDL:nsdb/NucFeature:1.0", 
    "IDL:seqdb/Feature:1.0"};

  public String[] _ids ()
  {
    return (String[])__ids.clone ();
  }

  private void readObject (java.io.ObjectInputStream s) throws java.io.IOException
  {
     String str = s.readUTF ();
     String[] args = null;
     java.util.Properties props = null;
     org.omg.CORBA.Object obj = org.omg.CORBA.ORB.init (args, props).string_to_object (str);
     org.omg.CORBA.portable.Delegate delegate = ((org.omg.CORBA.portable.ObjectImpl) obj)._get_delegate ();
     _set_delegate (delegate);
  }

  private void writeObject (java.io.ObjectOutputStream s) throws java.io.IOException
  {
     String[] args = null;
     java.util.Properties props = null;
     String str = org.omg.CORBA.ORB.init (args, props).object_to_string (this);
     s.writeUTF (str);
  }
} // class _NucFeatureWriterStub
