/* Copyright (C) 1999 Chris Vine, G3XXF

This program is distributed under the General Public Licence, version 2.
For particulars of this and relevant disclaimers see the file
COPYRIGHT distributed with the source files.

*/

#ifndef COM_H
#define COM_H

#include <unistd.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <signal.h>
#include <iostream.h>
#include <iomanip.h>
#include <strstream.h>
#include <stdio.h>
#include <fstream.h>
#include <stdlib.h>
#include <termios.h>
#include "prog_defs.h"

#ifndef LOCK_DIR
#define LOCK_DIR "/var/lock"
#endif

typedef unsigned char uchar;

class Com {
    FILE* comstream;
    termios startsettings;
    char* lockfile_name;
public:
    Com(int speed = 0, const char* port = 0);
    ~Com(void);
    int send(const uchar*);
    int send(uchar);
    int receive(void) {return fgetc(comstream);}
    static int check_port(const char* port = 0);
};

#endif

// Usage:

// pass the com object constructor the port name, and the speed(which
// may be 300, 600, 1200, 2400, 4800 or 9600 baud)

// if no port name is given, the object will default to /dev/modem

// if no speed is given, or a speed of 0 is given, the object will default
// to 9600 baud

// int check_port() is made static so that lock files can be checked before the
// com object is created - this can be useful if the com object is to be created
// in a separate child process, and this source of error is to be checked before forking.
// It returns 0 if there are no lock file problems, otherwise it returns -1.
// It prints error messages to cerr.

// The port name to be passed to check_port() is the same as the value to be  passed
// to the constructor of a com object.
