/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.shell.commands;

import java.util.Map;
import org.apache.accumulo.core.data.constraints.Constraint;
import org.apache.accumulo.shell.Shell;
import org.apache.accumulo.shell.ShellCommandException;
import org.apache.accumulo.shell.commands.OptUtil;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;

public class ConstraintCommand
extends Shell.Command {
    protected Option namespaceOpt;

    @Override
    public int execute(String fullCommand, CommandLine cl, Shell shellState) throws Exception {
        String namespace = cl.hasOption(this.namespaceOpt.getOpt()) ? cl.getOptionValue(this.namespaceOpt.getOpt()) : null;
        String tableName = cl.hasOption(OptUtil.tableOpt().getOpt()) || !shellState.getTableName().isEmpty() ? OptUtil.getTableOpt(cl, shellState) : null;
        switch (OptUtil.getAldOpt(cl)) {
            case ADD: {
                for (String constraint : cl.getArgs()) {
                    int i;
                    if (namespace != null) {
                        if (!shellState.getAccumuloClient().namespaceOperations().testClassLoad(namespace, constraint, Constraint.class.getName())) {
                            throw new ShellCommandException(ShellCommandException.ErrorCode.INITIALIZATION_FAILURE, "Servers are unable to load " + constraint + " as type " + Constraint.class.getName());
                        }
                        i = shellState.getAccumuloClient().namespaceOperations().addConstraint(namespace, constraint);
                        shellState.getWriter().println("Added constraint " + constraint + " to namespace " + namespace + " with number " + i);
                        continue;
                    }
                    if (tableName != null && !tableName.isEmpty()) {
                        if (!shellState.getAccumuloClient().tableOperations().testClassLoad(tableName, constraint, Constraint.class.getName())) {
                            throw new ShellCommandException(ShellCommandException.ErrorCode.INITIALIZATION_FAILURE, "Servers are unable to load " + constraint + " as type " + Constraint.class.getName());
                        }
                        i = shellState.getAccumuloClient().tableOperations().addConstraint(tableName, constraint);
                        shellState.getWriter().println("Added constraint " + constraint + " to table " + tableName + " with number " + i);
                        continue;
                    }
                    throw new IllegalArgumentException("Please specify either a table or a namespace");
                }
                break;
            }
            case DELETE: {
                for (String constraint : cl.getArgs()) {
                    int i = Integer.parseInt(constraint);
                    if (namespace != null) {
                        shellState.getAccumuloClient().namespaceOperations().removeConstraint(namespace, i);
                        shellState.getWriter().println("Removed constraint " + i + " from namespace " + namespace);
                        continue;
                    }
                    if (tableName != null) {
                        shellState.getAccumuloClient().tableOperations().removeConstraint(tableName, i);
                        shellState.getWriter().println("Removed constraint " + i + " from table " + tableName);
                        continue;
                    }
                    throw new IllegalArgumentException("Please specify either a table or a namespace");
                }
                break;
            }
            case LIST: {
                if (namespace != null) {
                    for (Map.Entry property : shellState.getAccumuloClient().namespaceOperations().listConstraints(namespace).entrySet()) {
                        shellState.getWriter().println(property.toString());
                    }
                    break;
                }
                if (tableName != null) {
                    for (Map.Entry property : shellState.getAccumuloClient().tableOperations().listConstraints(tableName).entrySet()) {
                        shellState.getWriter().println(property.toString());
                    }
                    break;
                }
                throw new IllegalArgumentException("Please specify either a table or a namespace");
            }
        }
        return 0;
    }

    @Override
    public String description() {
        return "adds, deletes, or lists constraints for a table";
    }

    @Override
    public int numArgs() {
        return -1;
    }

    @Override
    public String usage() {
        return this.getName() + " <constraint>{ <constraint>}";
    }

    @Override
    public Options getOptions() {
        Options o = new Options();
        o.addOptionGroup(OptUtil.addListDeleteGroup("constraint"));
        OptionGroup grp = new OptionGroup();
        grp.addOption(OptUtil.tableOpt("table to add, delete, or list constraints for"));
        this.namespaceOpt = new Option("ns", "namespace", true, "name of a namespace to operate on");
        this.namespaceOpt.setArgName("namespace");
        grp.addOption(this.namespaceOpt);
        o.addOptionGroup(grp);
        return o;
    }
}

