/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.common;

import org.apache.datasketches.common.ArrayOfItemsSerDe;
import org.apache.datasketches.common.Util;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;

public class ArrayOfUtf16StringsSerDe
extends ArrayOfItemsSerDe<String> {
    public byte[] serializeToByteArray(String[] items) {
        int length = 0;
        for (int i = 0; i < items.length; ++i) {
            length += items[i].length() * 2 + 4;
        }
        byte[] bytes = new byte[length];
        WritableMemory mem = WritableMemory.writableWrap((byte[])bytes);
        long offsetBytes = 0L;
        for (int i = 0; i < items.length; ++i) {
            mem.putInt(offsetBytes, items[i].length());
            mem.putCharArray(offsetBytes += 4L, items[i].toCharArray(), 0, items[i].length());
            offsetBytes += (long)items[i].length() * 2L;
        }
        return bytes;
    }

    public String[] deserializeFromMemory(Memory mem, int numItems) {
        String[] array = new String[numItems];
        long offsetBytes = 0L;
        for (int i = 0; i < numItems; ++i) {
            Util.checkBounds(offsetBytes, 4L, mem.getCapacity());
            int strLength = mem.getInt(offsetBytes);
            char[] chars = new char[strLength];
            Util.checkBounds(offsetBytes += 4L, (long)strLength * 2L, mem.getCapacity());
            mem.getCharArray(offsetBytes, chars, 0, strLength);
            array[i] = new String(chars);
            offsetBytes += (long)strLength * 2L;
        }
        return array;
    }
}

