/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.manager.tableOps.clone;

import java.util.Map;
import java.util.Set;
import org.apache.accumulo.core.clientImpl.thrift.TableOperation;
import org.apache.accumulo.core.data.NamespaceId;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.fate.Repo;
import org.apache.accumulo.manager.Manager;
import org.apache.accumulo.manager.tableOps.ManagerRepo;
import org.apache.accumulo.manager.tableOps.Utils;
import org.apache.accumulo.manager.tableOps.clone.CloneInfo;
import org.apache.accumulo.manager.tableOps.clone.ClonePermissions;

public class CloneTable
extends ManagerRepo {
    private static final long serialVersionUID = 1L;
    private final CloneInfo cloneInfo;

    public CloneTable(String user, NamespaceId srcNamespaceId, TableId srcTableId, NamespaceId namespaceId, String tableName, Map<String, String> propertiesToSet, Set<String> propertiesToExclude, boolean keepOffline) {
        this.cloneInfo = new CloneInfo(srcNamespaceId, srcTableId, namespaceId, tableName, propertiesToSet, propertiesToExclude, keepOffline, user);
    }

    @Override
    public long isReady(long tid, Manager environment) throws Exception {
        long val = Utils.reserveNamespace(environment, this.cloneInfo.getNamespaceId(), tid, false, true, TableOperation.CLONE);
        return val += Utils.reserveTable(environment, this.cloneInfo.getSrcTableId(), tid, false, true, TableOperation.CLONE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Repo<Manager> call(long tid, Manager environment) throws Exception {
        Utils.getIdLock().lock();
        try {
            this.cloneInfo.setTableId(Utils.getNextId(this.cloneInfo.getTableName(), environment.getContext(), TableId::of));
            ClonePermissions clonePermissions = new ClonePermissions(this.cloneInfo);
            return clonePermissions;
        }
        finally {
            Utils.getIdLock().unlock();
        }
    }

    @Override
    public void undo(long tid, Manager environment) {
        Utils.unreserveNamespace(environment, this.cloneInfo.getNamespaceId(), tid, false);
        Utils.unreserveTable(environment, this.cloneInfo.getSrcTableId(), tid, false);
    }
}

