/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver;

import com.google.common.collect.ImmutableSortedMap;
import java.util.Collections;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.tserver.tablet.Tablet;

public class OnlineTablets {
    private volatile SortedMap<KeyExtent, Tablet> snapshot = Collections.emptySortedMap();
    private final SortedMap<KeyExtent, Tablet> onlineTablets = new TreeMap<KeyExtent, Tablet>();

    public synchronized void put(KeyExtent ke, Tablet t) {
        this.onlineTablets.put(ke, t);
        this.snapshot = ImmutableSortedMap.copyOf(this.onlineTablets);
    }

    public synchronized void remove(KeyExtent ke) {
        this.onlineTablets.remove(ke);
        this.snapshot = ImmutableSortedMap.copyOf(this.onlineTablets);
    }

    public synchronized void split(KeyExtent oldTablet, Tablet newTablet1, Tablet newTablet2) {
        this.onlineTablets.remove(oldTablet);
        this.onlineTablets.put(newTablet1.getExtent(), newTablet1);
        this.onlineTablets.put(newTablet2.getExtent(), newTablet2);
        this.snapshot = ImmutableSortedMap.copyOf(this.onlineTablets);
    }

    SortedMap<KeyExtent, Tablet> snapshot() {
        return this.snapshot;
    }
}

