/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver.log;

import com.google.common.collect.Iterators;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.accumulo.core.crypto.CryptoEnvironmentImpl;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.file.FileOperations;
import org.apache.accumulo.core.file.FileSKVIterator;
import org.apache.accumulo.core.iterators.IteratorAdapter;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.spi.crypto.CryptoEnvironment;
import org.apache.accumulo.core.spi.crypto.CryptoService;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.server.log.SortedLogState;
import org.apache.accumulo.tserver.logger.LogEvents;
import org.apache.accumulo.tserver.logger.LogFileKey;
import org.apache.accumulo.tserver.logger.LogFileValue;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecoveryLogsIterator
implements Iterator<Map.Entry<LogFileKey, LogFileValue>>,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(RecoveryLogsIterator.class);
    private final List<FileSKVIterator> fileIters;
    private final Iterator<Map.Entry<Key, Value>> iter;
    private final CryptoEnvironment env = new CryptoEnvironmentImpl(CryptoEnvironment.Scope.RECOVERY);

    public RecoveryLogsIterator(ServerContext context, List<Path> recoveryLogDirs, LogFileKey start, LogFileKey end, boolean checkFirstKey) throws IOException {
        ArrayList<IteratorAdapter> iterators = new ArrayList<IteratorAdapter>(recoveryLogDirs.size());
        this.fileIters = new ArrayList<FileSKVIterator>();
        Range range = start == null ? null : LogFileKey.toRange(start, end);
        VolumeManager vm = context.getVolumeManager();
        CryptoService cryptoService = context.getCryptoFactory().getService(this.env, context.getConfiguration().getAllCryptoProperties());
        for (Path logDir : recoveryLogDirs) {
            LOG.debug("Opening recovery log dir {}", (Object)logDir.getName());
            SortedSet<Path> logFiles = this.getFiles(vm, logDir);
            FileSystem fs = vm.getFileSystemByPath(logDir);
            if (checkFirstKey && !logFiles.isEmpty()) {
                this.validateFirstKey(context, cryptoService, fs, logFiles, logDir);
            }
            for (Path log : logFiles) {
                IteratorAdapter scanIter;
                FileSKVIterator fileIter = FileOperations.getInstance().newReaderBuilder().forFile(log.toString(), fs, fs.getConf(), cryptoService).withTableConfiguration(context.getConfiguration()).seekToBeginning().build();
                if (range != null) {
                    fileIter.seek(range, Collections.emptySet(), false);
                }
                if ((scanIter = new IteratorAdapter((SortedKeyValueIterator)fileIter)).hasNext()) {
                    LOG.debug("Write ahead log {} has data in range {} {}", new Object[]{log.getName(), start, end});
                    iterators.add(scanIter);
                    this.fileIters.add(fileIter);
                    continue;
                }
                LOG.debug("Write ahead log {} has no data in range {} {}", new Object[]{log.getName(), start, end});
                fileIter.close();
            }
        }
        this.iter = Iterators.mergeSorted(iterators, Map.Entry.comparingByKey());
    }

    @Override
    public boolean hasNext() {
        return this.iter.hasNext();
    }

    @Override
    public Map.Entry<LogFileKey, LogFileValue> next() {
        Map.Entry<Key, Value> e = this.iter.next();
        return new AbstractMap.SimpleImmutableEntry<LogFileKey, LogFileValue>(LogFileKey.fromKey(e.getKey()), LogFileValue.fromValue(e.getValue()));
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove");
    }

    @Override
    public void close() throws IOException {
        for (FileSKVIterator fskv : this.fileIters) {
            fskv.close();
        }
    }

    private SortedSet<Path> getFiles(VolumeManager fs, Path directory) throws IOException {
        boolean foundFinish = false;
        TreeSet<Path> logFiles = new TreeSet<Path>(Comparator.comparing(Path::getName));
        for (FileStatus child : fs.listStatus(directory)) {
            if (child.getPath().getName().startsWith("_")) continue;
            if (SortedLogState.isFinished((String)child.getPath().getName())) {
                foundFinish = true;
                continue;
            }
            if (SortedLogState.FAILED.getMarker().equals(child.getPath().getName())) continue;
            FileSystem ns = fs.getFileSystemByPath(child.getPath());
            Path fullLogPath = ns.makeQualified(child.getPath());
            logFiles.add(fullLogPath);
        }
        if (!foundFinish) {
            throw new IOException("Sort '" + SortedLogState.FINISHED.getMarker() + "' flag not found in " + String.valueOf(directory));
        }
        return logFiles;
    }

    private void validateFirstKey(ServerContext context, CryptoService cs, FileSystem fs, SortedSet<Path> logFiles, Path fullLogPath) throws IOException {
        try (FileSKVIterator fileIter = FileOperations.getInstance().newReaderBuilder().forFile(logFiles.first().toString(), fs, fs.getConf(), cs).withTableConfiguration(context.getConfiguration()).seekToBeginning().build();){
            Key firstKey;
            LogFileKey key;
            IteratorAdapter iterator = new IteratorAdapter((SortedKeyValueIterator)fileIter);
            if (iterator.hasNext() && (key = LogFileKey.fromKey(firstKey = (Key)((Map.Entry)iterator.next()).getKey())).getEvent() != LogEvents.OPEN) {
                throw new IllegalStateException("First log entry is not OPEN " + String.valueOf(fullLogPath));
            }
        }
    }
}

