/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.file.rfile.bcfile;

import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.accumulo.core.file.rfile.bcfile.CompressionAlgorithm;
import org.apache.accumulo.core.spi.file.rfile.compression.Bzip2;
import org.apache.accumulo.core.spi.file.rfile.compression.CompressionAlgorithmConfiguration;
import org.apache.accumulo.core.spi.file.rfile.compression.Gz;
import org.apache.accumulo.core.spi.file.rfile.compression.Lz4;
import org.apache.accumulo.core.spi.file.rfile.compression.Lzo;
import org.apache.accumulo.core.spi.file.rfile.compression.NoCompression;
import org.apache.accumulo.core.spi.file.rfile.compression.Snappy;
import org.apache.accumulo.core.spi.file.rfile.compression.ZStandard;
import org.apache.hadoop.conf.Configuration;

public final class Compression {
    protected static final Configuration conf = new Configuration();
    private static final ServiceLoader<CompressionAlgorithmConfiguration> FOUND_ALGOS = ServiceLoader.load(CompressionAlgorithmConfiguration.class);
    private static final Set<CompressionAlgorithmConfiguration> BUILTIN_ALGOS = Set.of(new Gz(), new Bzip2(), new Lz4(), new Lzo(), new NoCompression(), new Snappy(), new ZStandard());
    private static final Map<String, CompressionAlgorithm> CONFIGURED_ALGORITHMS = Stream.concat(BUILTIN_ALGOS.stream(), StreamSupport.stream(FOUND_ALGOS.spliterator(), false)).map(a -> new CompressionAlgorithm((CompressionAlgorithmConfiguration)a, conf)).collect(Collectors.toMap(CompressionAlgorithm::getName, Function.identity()));

    private Compression() {
        throw new UnsupportedOperationException();
    }

    public static List<String> getSupportedAlgorithms() {
        return CONFIGURED_ALGORITHMS.entrySet().stream().filter(e -> ((CompressionAlgorithm)((Object)((Object)e.getValue()))).isSupported()).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    public static CompressionAlgorithm getCompressionAlgorithmByName(String name) {
        CompressionAlgorithm algorithm = CONFIGURED_ALGORITHMS.get(name);
        if (algorithm != null) {
            return algorithm;
        }
        throw new IllegalArgumentException("Unsupported compression algorithm name: " + name);
    }
}

